/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.mpe;

import com.tssap.editors.tag.ICloseableEditor;
import com.tssap.editors.tag.ITagEditor;
import com.tssap.editors.tag.TagEditor;
import com.tssap.editors.tag.mpe.internal.PreviewPage;
import com.tssap.editors.tag.ui.OutlinePage;
import com.tssap.util.ui.dialog.UserDialog;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class TagMpeEditor
extends MultiPageEditorPart
implements ICloseableEditor {
    private String editorName = "";
    private ITagEditor sourcePage;
    private PreviewPage previewPage;
    private URL pageUrl;
    private int previewIndex;
    private int sourceIndex;
    private static IAction dummyCutAction = new DummyAction("cut", "org.eclipse.ui.edit.cut");
    private static IAction dummyPasteAction = new DummyAction("paste", "org.eclipse.ui.edit.paste");
    private InnerChangeListener changeListener;

    protected void createPages() {
        try {
            PreviewPage previewPage = new PreviewPage(this.getContainer(), this.getPageUrl());
            int previewIndex = this.addPage(previewPage.getControl());
            this.setPageText(previewIndex, "Preview");
            this.setPreviewIndex(previewIndex);
            this.previewPage = previewPage;
            ITagEditor sourcePage = this.getSpecificSourcePage();
            int sourceIndex = this.addPage(sourcePage, this.getEditorInput());
            this.setPageText(sourceIndex, "Source");
            this.setSourceIndex(sourceIndex);
            this.sourcePage = sourcePage;
        }
        catch (PartInitException ex) {
            TagEditor.getTracer().error("createPages()", ex.getMessage(), (Throwable)ex);
        }
        this.updateActions();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.getChangeListener());
        this.getSite().getWorkbenchWindow().getShell().addShellListener((ShellListener)this.getChangeListener());
    }

    public abstract ITagEditor getSpecificSourcePage();

    public void doSave(IProgressMonitor monitor) {
        if (this.getSourcePage() != null) {
            this.getSourcePage().doSave(monitor);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.getSourcePage().doSaveAs();
        IFile file = this.getSourcePage().getFile();
        this.setEditorName(file.getName());
        String sFile = file.getLocation().toOSString();
        try {
            URL pageUrl = new URL("file", "/", sFile);
            this.setPageUrl(pageUrl);
        }
        catch (MalformedURLException ex) {
            TagEditor.getTracer().error("init(IEditorSite site, IEditorInput input)", ex.getMessage(), (Throwable)ex);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput file = (IFileEditorInput)input;
            this.setEditorName(file.getFile().getName());
            try {
                String sFile = file.getFile().getLocation().toOSString();
                URL pageUrl = new URL("file", "/", sFile);
                this.setPageUrl(pageUrl);
            }
            catch (MalformedURLException ex) {
                TagEditor.getTracer().error("init(IEditorSite site, IEditorInput input)", ex.getMessage(), (Throwable)ex);
            }
        } else {
            String inputType = input != null ? input.getClass().getName() : "null";
            throw new PartInitException("Unsupported editor input type " + inputType);
        }
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getShell().removeShellListener((ShellListener)this.getChangeListener());
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.getChangeListener());
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        Object retAdapter;
        Object object = retAdapter = this.getSourcePage() != null ? this.getSourcePage().getAdapter(adapter) : null;
        if (retAdapter instanceof OutlinePage) {
            OutlinePage outlinePage = (OutlinePage)((Object)retAdapter);
            outlinePage.addSelectionChangedListener(new MpeOutlineSelectionListener());
        }
        return retAdapter;
    }

    protected String getEditorName() {
        return this.editorName;
    }

    private void setEditorName(String editorName) {
        this.editorName = editorName;
        super.setTitle(editorName);
    }

    protected URL getPageUrl() {
        return this.pageUrl;
    }

    private void setPageUrl(URL pageUrl) {
        this.pageUrl = pageUrl;
        if (this.getPreviewPage() != null) {
            this.getPreviewPage().navigate(pageUrl);
        }
    }

    protected void pageChange(int newPageIndex) {
        if (this.getSourcePage() != null && newPageIndex == this.getPreviewIndex() && this.getSourcePage().isDirty() && UserDialog.openConfirm((Shell)this.getSourcePage().getEditorSite().getShell(), (String)"Page Change", (String)"Save changes in order to update preview ?")) {
            this.getSourcePage().doSave(null);
        }
        super.pageChange(newPageIndex);
        if (this.getPreviewPage() != null && newPageIndex == this.getPreviewIndex()) {
            this.getPreviewPage().refresh();
        }
        this.updateActions();
    }

    private void updateActions() {
        int pageIndex = this.getActivePage();
        if (this.getCutAction() != null) {
            if (pageIndex == this.getSourceIndex()) {
                this.getEditorSite().getKeyBindingService().registerAction(this.getCutAction());
            } else {
                this.getEditorSite().getKeyBindingService().unregisterAction(this.getCutAction());
            }
        }
        if (this.getPasteAction() != null) {
            if (pageIndex == this.getSourceIndex()) {
                this.getEditorSite().getKeyBindingService().registerAction(this.getPasteAction());
            } else {
                this.getEditorSite().getKeyBindingService().unregisterAction(this.getPasteAction());
            }
        }
    }

    private IAction getCutAction() {
        IAction cutAction = null;
        if (this.getEditorSite().getActionBars() != null) {
            cutAction = this.getEditorSite().getActionBars().getGlobalActionHandler("cut");
        }
        if (cutAction == null) {
            cutAction = dummyCutAction;
        }
        return cutAction;
    }

    private IAction getPasteAction() {
        IAction pasteAction = null;
        if (this.getEditorSite().getActionBars() != null) {
            pasteAction = this.getEditorSite().getActionBars().getGlobalActionHandler("paste");
        }
        if (pasteAction == null) {
            pasteAction = dummyPasteAction;
        }
        return pasteAction;
    }

    protected int getPreviewIndex() {
        return this.previewIndex;
    }

    protected int getSourceIndex() {
        return this.sourceIndex;
    }

    private void setPreviewIndex(int previewIndex) {
        this.previewIndex = previewIndex;
    }

    private void setSourceIndex(int sourceIndex) {
        this.sourceIndex = sourceIndex;
    }

    protected PreviewPage getPreviewPage() {
        return this.previewPage;
    }

    protected ITagEditor getSourcePage() {
        return this.sourcePage;
    }

    protected void handlePropertyChange(int propertyId) {
        if (propertyId == 257) {
            this.firePropertyChange(257);
        }
    }

    public void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                TagMpeEditor.this.getSite().getPage().closeEditor((IEditorPart)TagMpeEditor.this, save);
            }
        });
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(this.getSourceIndex());
        this.getSourcePage().gotoMarker(marker);
    }

    private InnerChangeListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new InnerChangeListener();
        }
        return this.changeListener;
    }

    private class InnerChangeListener
    implements IPartListener,
    ShellListener {
        private boolean isActivePart = false;

        private InnerChangeListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part.equals(TagMpeEditor.this)) {
                this.isActivePart = true;
                ITagEditor tagEdit = TagMpeEditor.this.getSourcePage();
                if (tagEdit != null) {
                    tagEdit.checkSanityState();
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part.equals(TagMpeEditor.this)) {
                this.isActivePart = false;
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void shellActivated(ShellEvent e) {
            ITagEditor tagEdit;
            if (this.isActivePart && (tagEdit = TagMpeEditor.this.getSourcePage()) != null) {
                tagEdit.checkSanityState();
            }
        }

        public void shellClosed(ShellEvent e) {
        }

        public void shellDeactivated(ShellEvent e) {
        }

        public void shellDeiconified(ShellEvent e) {
        }

        public void shellIconified(ShellEvent e) {
        }
    }

    private class MpeOutlineSelectionListener
    implements ISelectionChangedListener {
        private MpeOutlineSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TagMpeEditor.super.setActivePage(TagMpeEditor.this.getSourceIndex());
        }
    }

    private static class DummyAction
    extends Action {
        public DummyAction(String actionId, String actionDefinitionId) {
            this.setId(actionId);
            this.setActionDefinitionId(actionDefinitionId);
        }

        public void run() {
            super.run();
        }
    }
}

