/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.basic;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.tag.TagEditor;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.Vector;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class BasicTagEditorContentAssistProcessor
implements IContentAssistProcessor {
    public static final String[] HTML_TAGS = new String[]{"a", "acronym", "address", "applet", "area", "b", "base", "basefont", "bdo", "big", "blockquote", "body", "br", "button", "caption", "center", "cite", "code", "col", "colgroup", "dd", "el", "dfn", "dir", "div", "dl", "dt", "em", "fieldset", "font", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "html", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "label", "legend", "li", "link", "map", "menu", "meta", "noframes", "noscript", "object", "ol", "optgroup", "option", "p", "param", "pre", "q", "s", "samp", "script", "select", "small", "span", "strike", "strong", "style", "sub", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "tt", "u", "ul", "var"};
    private String[] tags;
    private int maxTagLength = 0;
    private Image completionImage = SapIdeUtilImages.createImageFromIconsDirectory((IPluginDescriptor)EditorPlugin.getInstance().getDescriptor(), (String)"tag/element.gif");

    public BasicTagEditorContentAssistProcessor() {
        this.tags = new String[HTML_TAGS.length * 2];
        int tagNum = 0;
        while (tagNum < HTML_TAGS.length) {
            String tag = HTML_TAGS[tagNum];
            this.tags[tagNum] = "<" + tag + ">";
            this.tags[tagNum + BasicTagEditorContentAssistProcessor.HTML_TAGS.length] = "</" + tag + ">";
            int tagLength = this.tags[tagNum + HTML_TAGS.length].length();
            if (tagLength > this.maxTagLength) {
                this.maxTagLength = tagLength;
            }
            ++tagNum;
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IDocument document = viewer.getDocument();
        String tagPrefix = this.searchPrefixBackward(document, documentOffset);
        Vector<CompletionProposal> compPropVec = new Vector<CompletionProposal>();
        int tagNum = 0;
        while (tagNum < this.getTags().length) {
            String tag = this.getTags()[tagNum];
            if (tag.startsWith(tagPrefix)) {
                compPropVec.add(new CompletionProposal(tag, documentOffset - tagPrefix.length(), tagPrefix.length(), tag.length(), this.getCompletionImage(), tag, null, null));
            }
            ++tagNum;
        }
        return compPropVec.toArray(new ICompletionProposal[compPropVec.size()]);
    }

    private String searchPrefixBackward(IDocument document, int documentOffset) {
        StringBuffer prefixBuffer = new StringBuffer(this.getMaxTagLength());
        char previousChar = ' ';
        int numberOfReadChars = 0;
        while (--documentOffset >= 0 && previousChar != '<' && numberOfReadChars < this.getMaxTagLength()) {
            try {
                previousChar = document.getChar(documentOffset);
            }
            catch (BadLocationException ex) {
                TagEditor.getTracer().error("searchPrefixBackward(IDocument document, int documentOffset)", ex.getMessage(), (Throwable)ex);
            }
            prefixBuffer.insert(0, previousChar);
            ++numberOfReadChars;
        }
        String prefix = "";
        if (previousChar == '<') {
            prefix = prefixBuffer.toString();
        }
        return prefix.toLowerCase();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        char[] completionCharacters = new char[]{'<', '/'};
        return completionCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return "Error Message !";
    }

    public Image getCompletionImage() {
        return this.completionImage;
    }

    public int getMaxTagLength() {
        return this.maxTagLength;
    }

    public String[] getTags() {
        return this.tags;
    }
}

