/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag.basic;

import com.tssap.editors.Messages;
import com.tssap.editors.tag.ICloseableEditor;
import com.tssap.editors.tag.TagEditor;
import com.tssap.editors.tag.basic.BasicTagEditorSourceViewerConfiguration;
import com.tssap.editors.tag.source.TagSourceViewerConfiguration;
import com.tssap.editors.tag.ui.OutlinePageTreeModel;
import com.tssap.editors.tag.util.DefaultParserController;
import com.tssap.editors.tag.util.ITagParserController;
import com.tssap.editors.tag.util.state.Utility;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class BasicTagEditor
extends TagEditor {
    public static final String FORMAT_DEF_ID = "Format";
    public static final String FORMAT_ID = "Format";
    private ITagParserController controller;
    private String DEFAULT_ROOT_NAME = "<root>";

    public BasicTagEditor() {
    }

    public BasicTagEditor(ICloseableEditor ce) {
        super(ce);
    }

    protected OutlinePageTreeModel getOutlinePageTreeModel(boolean updateTaskPane) {
        LineNumberReader inputReader = new LineNumberReader(new InputStreamReader(this.getStream()));
        ITagParserController controller = this.getParserController();
        controller.initializeController(inputReader);
        controller.setTrimmingWhitespaces(true);
        Utility.parseFromBasicToFinish(controller);
        try {
            inputReader.close();
        }
        catch (IOException ex) {
            TagEditor.getTracer().error("getOutlinePageTreeModel(boolean updateTaskPane)", ex.getMessage(), (Throwable)ex);
        }
        IFile file = this.getFile();
        String rootName = file != null ? file.getName() : this.DEFAULT_ROOT_NAME;
        return controller.finalizeControllerAsTreeModel(rootName);
    }

    protected TagSourceViewerConfiguration getSpecificSourceViewerConfiguration() {
        return new BasicTagEditorSourceViewerConfiguration(this);
    }

    protected Composite getSpecificParent(Composite parent) {
        return parent;
    }

    public final void createPartControl(Composite parent) {
        this.setSourceViewerConfiguration(this.getSpecificSourceViewerConfiguration());
        Composite specificParent = this.getSpecificParent(parent);
        super.createPartControl(specificParent);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "Format");
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction action = new TextOperationAction(Messages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("Format");
        action.setId("Format");
        this.setAction("Format", (IAction)action);
        action = new ContentAssistAction(Messages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        action = new TextOperationAction(Messages.getResourceBundle(), "ContentAssistTip.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
    }

    public ITagParserController getParserController() {
        if (this.controller == null) {
            this.controller = new DefaultParserController();
        }
        return this.controller;
    }

    public void contentReplaced(Object content) {
    }
}

