/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.tag;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.tag.ICloseableEditor;
import com.tssap.editors.tag.ITagEditor;
import com.tssap.editors.tag.ui.OutlinePage;
import com.tssap.editors.tag.ui.OutlinePageTreeModel;
import com.tssap.editors.tag.util.DocumentProvider;
import com.tssap.editors.tag.util.ElementStateListener;
import com.tssap.editors.tag.util.ITagParserController;
import com.tssap.editors.tag.util.TreeNode;
import com.tssap.editors.util.SrcLocation;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class TagEditor
extends TextEditor
implements ITagEditor {
    private static TracerI tagTracer = TracingManager.getTracer((String)(class$com$tssap$editors$tag$TagEditor == null ? (class$com$tssap$editors$tag$TagEditor = TagEditor.class$("com.tssap.editors.tag.TagEditor")) : class$com$tssap$editors$tag$TagEditor).getName());
    private DocumentProvider documentProvider;
    private InnerTextListener textListener;
    private ICloseableEditor closeableEditor;
    private OutlinePage outlinePage;
    static /* synthetic */ Class class$com$tssap$editors$tag$TagEditor;
    static /* synthetic */ Class class$org$eclipse$ui$editors$text$IEncodingSupport;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public TagEditor() {
    }

    public TagEditor(ICloseableEditor ce) {
        this();
        this.closeableEditor = ce;
    }

    public void doSaveAs() {
        super.doSaveAs();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.updateOutlinePage(true);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setPreferenceStore(EditorPlugin.getInstance().getPreferenceStore());
        this.getSourceViewer().addTextListener(this.getTextListener());
    }

    public IFile getFile() {
        IFile file = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        return file;
    }

    public IStorage getStorage() {
        IStorage storage = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IStorageEditorInput) {
            try {
                storage = ((IStorageEditorInput)input).getStorage();
            }
            catch (CoreException ex) {
                TagEditor.getTracer().error("getStorage()", ex.getMessage(), (Throwable)ex);
            }
        }
        return storage;
    }

    public InputStream getStream() {
        ByteArrayInputStream inpStream = null;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document != null) {
            byte[] byteArr = new byte[]{};
            try {
                String enc = this.getEncoding();
                byteArr = enc != null ? document.get().getBytes(enc) : document.get().getBytes();
            }
            catch (UnsupportedEncodingException ex) {
                TagEditor.getTracer().error("getEncoding()", (Throwable)ex);
            }
            inpStream = new ByteArrayInputStream(byteArr);
        }
        return inpStream;
    }

    public String getEncoding() {
        IEncodingSupport encSup;
        String enc = null;
        Object adapt = this.getAdapter(class$org$eclipse$ui$editors$text$IEncodingSupport == null ? (class$org$eclipse$ui$editors$text$IEncodingSupport = TagEditor.class$("org.eclipse.ui.editors.text.IEncodingSupport")) : class$org$eclipse$ui$editors$text$IEncodingSupport);
        if (adapt instanceof IEncodingSupport && (enc = (encSup = (IEncodingSupport)adapt).getEncoding()) == null) {
            enc = encSup.getDefaultEncoding();
        }
        return enc;
    }

    public IDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = new DocumentProvider();
            this.documentProvider.addElementStateListener(new ElementStateListener(this));
        }
        return this.documentProvider;
    }

    protected ITextListener getTextListener() {
        if (this.textListener == null) {
            this.textListener = new InnerTextListener();
        }
        return this.textListener;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = TagEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    protected abstract OutlinePageTreeModel getOutlinePageTreeModel(boolean var1);

    public abstract void contentReplaced(Object var1);

    protected void updateOutlinePage(boolean updateTaskPane) {
        OutlinePageTreeModel newModel = this.getOutlinePageTreeModel(updateTaskPane);
        if (this.getOutlinePage() != null) {
            this.getOutlinePage().updateTreeModel(newModel);
        }
    }

    public OutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            OutlinePageTreeModel initialModel = this.getOutlinePageTreeModel(true);
            this.outlinePage = new OutlinePage(initialModel);
            this.outlinePage.addSelectionChangedListener(new InnerSelectionChangedListener());
        }
        return this.outlinePage;
    }

    public ICloseableEditor getCloseableEditor() {
        return this.closeableEditor;
    }

    public boolean isPartOfCloseableEditor() {
        return this.closeableEditor != null;
    }

    public void close(boolean save) {
        if (this.isPartOfCloseableEditor()) {
            this.getCloseableEditor().close(save);
        } else {
            super.close(save);
        }
    }

    public static TracerI getTracer() {
        return tagTracer;
    }

    public void checkSanityState() {
        this.sanityCheckState(this.getEditorInput());
    }

    public abstract ITagParserController getParserController();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerSelectionChangedListener
    implements ISelectionChangedListener {
        private InnerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISourceViewer sv;
            SrcLocation info = null;
            ISelection selection = event.getSelection();
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext() && info == null) {
                Object o2;
                Object o = iter.next();
                if (!(o instanceof TreeNode) || !((o2 = ((TreeNode)o).getUserObject()) instanceof SrcLocation)) continue;
                info = (SrcLocation)o2;
            }
            if (info != null && info.getBeginLine() != -1 && (sv = TagEditor.super.getSourceViewer()) != null) {
                IDocument doc = sv.getDocument();
                int offset = 0;
                int length = 0;
                try {
                    offset = doc.getLineOffset(info.getBeginLine());
                    length = doc.getLineLength(info.getBeginLine());
                }
                catch (BadLocationException ex) {
                    TagEditor.getTracer().error("Cannot compute offset and lenght of node in document", (Throwable)ex);
                }
                sv.revealRange(offset, length);
                sv.setSelectedRange(offset, length);
            }
        }
    }

    private class InnerTextListener
    implements ITextListener {
        private InnerTextListener() {
        }

        public void textChanged(TextEvent event) {
            String newText = event.getText();
            if (newText != null && (newText.equals(">") || newText.equals("\n") || newText.equals("\r") || newText.length() > 1)) {
                TagEditor.this.updateOutlinePage(false);
            }
        }
    }
}

