/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.mpe.action;

import com.tssap.editors.mpe.Editor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractPageAction
extends Action {
    private Editor myEditor;

    public AbstractPageAction(Editor editor, String actionId, String actionDefinitionId) {
        this.setEditor(editor);
        this.setId(actionId);
        this.setActionDefinitionId(actionDefinitionId);
    }

    public final void run() {
        if (this.getEditor().isSourcePageActive()) {
            IAction act = this.getEditor().getSourcePage().getAction(this.getId());
            act.run();
        } else {
            Control pageControl = this.getEditor().getCurrentControl();
            Control focusControl = AbstractPageAction.recursiveFocusControlSearch(pageControl);
            if (focusControl != null) {
                this.runOnControl(focusControl);
            }
        }
    }

    public abstract void runOnControl(Control var1);

    private static Control recursiveFocusControlSearch(Control parent) {
        Control focusControl = null;
        if (parent instanceof Composite) {
            Composite parentCompo = (Composite)parent;
            Control[] childs = parentCompo.getChildren();
            int c = 0;
            while (c < childs.length && focusControl == null) {
                Control control = childs[c];
                if (control.isFocusControl()) {
                    focusControl = control;
                } else if (control instanceof Composite) {
                    focusControl = AbstractPageAction.recursiveFocusControlSearch(control);
                }
                ++c;
            }
        } else if (parent.isFocusControl()) {
            focusControl = parent;
        }
        return focusControl;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public void setEditor(Editor editor) {
        this.myEditor = editor;
    }

    public boolean isToBeContributed() {
        return true;
    }
}

