/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.mpe;

import com.tssap.editors.mpe.IEditor;
import com.tssap.editors.mpe.IEditorPage;
import com.tssap.util.ui.AbstractEditable;
import com.tssap.util.ui.dialog.UserDialog;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.table.ITableModifyListener;
import com.tssap.util.ui.reuse.table.ITableRow;
import com.tssap.util.ui.reuse.table.impl.TableModifyListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class EditorPage
extends AbstractEditable
implements IEditorPage {
    private Composite parent;
    private Control pageControl = null;
    private IEditor editor;
    private KeyListener keyStrokeHandler;
    private VerifyListener verifyHandler;
    private TableModifyListener tableModifyListener;

    public EditorPage(Composite parent, IEditor editor) {
        this.parent = parent;
        this.editor = editor;
    }

    public abstract String getPageName();

    protected abstract Control createControls(IGridLayoutPane var1);

    protected abstract void decorateControls();

    public abstract void initControls();

    public abstract void scanControls();

    protected Composite getParent() {
        return this.parent;
    }

    public Control getControl() {
        if (this.pageControl == null) {
            IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)this.getParent(), (int)1);
            glp.addTextLabel("Control not initialized!");
        }
        return this.pageControl;
    }

    protected final void setControl(Control control) {
        this.pageControl = control;
    }

    public IEditor getEditor() {
        return this.editor;
    }

    public IFile getUnderlyingFile() {
        IFile ret = null;
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof IFileEditorInput) {
            ret = ((IFileEditorInput)input).getFile();
        }
        return ret;
    }

    protected KeyListener getKeyStrokeHandler() {
        if (this.keyStrokeHandler == null) {
            this.keyStrokeHandler = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    short keyVal = (short)e.character;
                    if (keyVal > 0) {
                        EditorPage.this.makeEditorDirty();
                    }
                }
            };
        }
        return this.keyStrokeHandler;
    }

    protected VerifyListener getVerifyHandler() {
        if (this.verifyHandler == null) {
            this.verifyHandler = new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    EditorPage.this.makeEditorDirty();
                }
            };
        }
        return this.verifyHandler;
    }

    protected ITableModifyListener getEditorTableModifyListener() {
        if (this.tableModifyListener == null) {
            this.tableModifyListener = new TableModifyListener(){

                public void rowChanged(ITableRow row, int colNum, String newValue) {
                    EditorPage.this.makeEditorDirty();
                }

                public void rowsAdded(ITableRow[] rows) {
                    EditorPage.this.makeEditorDirty();
                }

                public void rowsRemoved(ITableRow[] rows) {
                    EditorPage.this.makeEditorDirty();
                }

                public void tableCleared() {
                    EditorPage.this.makeEditorDirty();
                }
            };
        }
        return this.tableModifyListener;
    }

    protected void makeEditorDirty() {
        if (this.getEditor() != null) {
            this.getEditor().setDirtyFlag(true);
        }
    }

    public boolean openConfirm(String title, String message) {
        return UserDialog.openConfirm((Shell)this.getParent().getShell(), (String)title, (String)message);
    }

    public void openError(String title, String message) {
        UserDialog.openError((Shell)this.getParent().getShell(), (String)title, (String)message);
    }

    public void openInformation(String title, String message) {
        UserDialog.openInformation((Shell)this.getParent().getShell(), (String)title, (String)message);
    }

    public String openInputDialog(String title, String message, String initialValue, IInputValidator validator) {
        return UserDialog.openInputDialog((Shell)this.getParent().getShell(), (String)title, (String)message, (String)initialValue, (IInputValidator)validator);
    }

    public String openInputDialog(String title, String message, String initialValue) {
        return UserDialog.openInputDialog((Shell)this.getParent().getShell(), (String)title, (String)message, (String)initialValue);
    }

    public boolean openQuestion(String title, String message) {
        return UserDialog.openQuestion((Shell)this.getParent().getShell(), (String)title, (String)message);
    }

    public void openWarning(String title, String message) {
        UserDialog.openWarning((Shell)this.getParent().getShell(), (String)title, (String)message);
    }
}

