/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.mpe;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.mpe.ActionContributor;
import com.tssap.editors.mpe.IEditor;
import com.tssap.editors.mpe.IEditorPage;
import com.tssap.editors.mpe.action.Copy;
import com.tssap.editors.mpe.action.Cut;
import com.tssap.editors.mpe.action.Find;
import com.tssap.editors.mpe.action.Paste;
import com.tssap.editors.mpe.action.SelectAll;
import com.tssap.editors.tag.ICloseableEditor;
import com.tssap.editors.xml.XmlEditor;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.xml.sax.EntityResolver;

public abstract class Editor
extends MultiPageEditorPart
implements IEditor,
ICloseableEditor {
    private Cut cutAction = new Cut(this);
    private Copy copyAction = new Copy(this);
    private Paste pasteAction = new Paste(this);
    private SelectAll selectAllAction = new SelectAll(this);
    private Find findAction = new Find(this);
    private static TracerI mpeTracer = TracingManager.getTracer((String)(class$com$tssap$editors$mpe$Editor == null ? (class$com$tssap$editors$mpe$Editor = Editor.class$("com.tssap.editors.mpe.Editor")) : class$com$tssap$editors$mpe$Editor).getName());
    private boolean dirty;
    private int count = 0;
    private IEditorPage[] specificPages;
    private int currentPage = 0;
    private int sourcePageID = 0;
    private XmlEditor sourcePage;
    private EntityResolver entityResolver;
    private String editorName = "";
    private InnerChangeListener changeListener;
    static /* synthetic */ Class class$com$tssap$editors$mpe$Editor;

    protected abstract IEditorPage[] createSpecificPages();

    protected abstract boolean modelCreated();

    protected abstract void writeModelToSourcePage();

    protected abstract boolean createModelFromSourcePage();

    public void doSave(IProgressMonitor monitor) {
        if (this.getActivePage() != this.getSourcePageID()) {
            this.getSpecificPages()[this.getCurrentPage()].scanControls();
            this.writeModelToSourcePage();
        }
        this.getSourcePage().doSave(monitor);
        this.setDirtyFlag(this.getSourcePage().isDirty());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        if (this.getActivePage() != this.getSourcePageID()) {
            this.getSpecificPages()[this.getCurrentPage()].scanControls();
            this.writeModelToSourcePage();
        }
        this.getSourcePage().doSaveAs();
        this.setDirtyFlag(this.getSourcePage().isDirty());
        this.setEditorName(this.getSourcePage().getFile().getName());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!(input instanceof IFileEditorInput)) {
            String inputType = input != null ? input.getClass().getName() : "null";
            throw new PartInitException("Unsupported editor input type " + inputType);
        }
        IFileEditorInput file = (IFileEditorInput)input;
        this.setEditorName(file.getFile().getName());
        this.setTitle(this.getEditorName());
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getShell().removeShellListener((ShellListener)this.getChangeListener());
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.getChangeListener());
        super.dispose();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(this.getSourcePageID());
        this.getSourcePage().gotoMarker(marker);
    }

    protected final void createPages() {
        int index;
        IEditorPage[] pages = this.createSpecificPages();
        this.setSpecificPages(pages);
        int i = 0;
        while (i < pages.length) {
            index = this.addPage(pages[i].getControl());
            this.setPageText(index, pages[i].getPageName());
            ++i;
        }
        try {
            EntityResolver resolver = this.getEntityResolver();
            if (resolver != null) {
                this.getSourcePage().setEntityResolver(resolver);
            }
            index = this.addPage(this.getSourcePage(), this.getEditorInput());
            this.setPageText(index, "Source");
            this.setSourcePageID(index);
            this.getSourcePage().parse(false, true);
        }
        catch (PartInitException ex) {
            Editor.getTracer().error("createPages()", ex.getMessage(), (Throwable)ex);
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"ErrorCreatingNestedEditor", null, (IStatus)ex.getStatus());
        }
        this.createModelFromSourcePage();
        if (!this.modelCreated()) {
            this.setActivePage(this.getSourcePageID());
        } else {
            this.setActivePage(0);
            if (this.getSpecificPages().length > 0) {
                this.getSpecificPages()[0].initControls();
            }
        }
        this.setCurrentPage(this.getActivePage());
        this.hideNonActivePages();
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.cutAction);
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.copyAction);
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.pasteAction);
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.selectAllAction);
        this.getEditorSite().getKeyBindingService().registerAction((IAction)this.findAction);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.getChangeListener());
        this.getSite().getWorkbenchWindow().getShell().addShellListener((ShellListener)this.getChangeListener());
    }

    protected void pageChange(int newPageIndex) {
        if (this.getCurrentPage() == this.getSourcePageID()) {
            if (this.createModelFromSourcePage()) {
                this.setCurrentPage(newPageIndex);
                super.pageChange(newPageIndex);
            } else {
                this.setActivePage(this.getSourcePageID());
                MessageDialog.openError((Shell)EditorPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(this.getEditorName() + " - Editor"), (String)"The source page has errors. Other pages cannot be used until these erros are corrected.");
            }
        } else {
            if (this.isDirty()) {
                this.getSpecificPages()[this.getCurrentPage()].scanControls();
                if (newPageIndex == this.getSourcePageID()) {
                    this.writeModelToSourcePage();
                }
            }
            this.setCurrentPage(newPageIndex);
            super.pageChange(newPageIndex);
        }
        if (this.getCurrentPage() != this.getSourcePageID()) {
            this.getSpecificPages()[this.getCurrentPage()].initControls();
        }
        this.hideNonActivePages();
    }

    protected void handlePropertyChange(int propertyId) {
        if (propertyId == 257) {
            this.setDirtyFlag(this.getSourcePage().isDirty());
        }
    }

    public Object getAdapter(Class adapter) {
        return this.getSourcePage().getAdapter(adapter);
    }

    private void hideNonActivePages() {
        int activePage = this.getActivePage();
        int i = 0;
        while (i < this.specificPages.length) {
            if (i == activePage) {
                this.setControl(i, this.specificPages[i].getControl());
            } else {
                this.setControl(i, null);
            }
            ++i;
        }
    }

    public boolean isSourcePageActive() {
        boolean ret = this.getCurrentPage() == this.getSourcePageID();
        return ret;
    }

    public XmlEditor getSourcePage() {
        if (this.sourcePage == null) {
            this.sourcePage = new XmlEditor(this);
            this.sourcePage.getDocumentProvider().addElementStateListener((IElementStateListener)new InnerElementStateListener());
        }
        return this.sourcePage;
    }

    public Control getCurrentControl() {
        Control pageControl = null;
        if (this.getCurrentPage() != this.getSourcePageID()) {
            pageControl = this.getSpecificPages()[this.getCurrentPage()].getControl();
        }
        return pageControl;
    }

    public void setDirtyFlag(boolean pDirty) {
        if (pDirty != this.isDirty()) {
            this.dirty = pDirty;
            this.firePropertyChange(257);
        }
        this.getSourcePage().checkSanityState();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private int getCurrentPage() {
        return this.currentPage;
    }

    private void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        this.enableOrDisablePageControls(currentPage);
    }

    private int getSourcePageID() {
        return this.sourcePageID;
    }

    private void setSourcePageID(int sourcePageID) {
        this.sourcePageID = sourcePageID;
    }

    private IEditorPage[] getSpecificPages() {
        return this.specificPages;
    }

    private void setSpecificPages(IEditorPage[] specificPages) {
        this.specificPages = specificPages;
    }

    private String getEditorName() {
        return this.editorName;
    }

    private void setEditorName(String editorName) {
        this.editorName = editorName;
    }

    protected EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    protected void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.getSourcePage().setEntityResolver(entityResolver);
    }

    public static TracerI getTracer() {
        return mpeTracer;
    }

    public void close(final boolean save) {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                Editor.this.getSite().getPage().closeEditor((IEditorPart)Editor.this, save);
            }
        });
    }

    private void enableOrDisablePageControls(int pageNum) {
        boolean readOnlyFlag = this.getReadOnlyFlag();
        IEditorPage[] pages = this.getSpecificPages();
        if (pages != null && pageNum < pages.length) {
            pages[pageNum].setEditable(!readOnlyFlag);
        }
    }

    protected boolean getReadOnlyFlag() {
        return this.getSourcePage().isFileReadOnly();
    }

    private void checkAndUpdateStatus() {
        this.getSourcePage().checkSanityState();
        boolean readOnlyFlag = this.getSourcePage().isFileReadOnly();
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof ActionContributor) {
            ActionContributor actionContributor = (ActionContributor)contributor;
            actionContributor.setReadOnly(readOnlyFlag);
        }
        this.enableOrDisablePageControls(this.getCurrentPage());
    }

    private InnerChangeListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new InnerChangeListener();
        }
        return this.changeListener;
    }

    public Copy getCopyAction() {
        return this.copyAction;
    }

    public Cut getCutAction() {
        return this.cutAction;
    }

    public Paste getPasteAction() {
        return this.pasteAction;
    }

    public SelectAll getSelectAllAction() {
        return this.selectAllAction;
    }

    public Find getFindAction() {
        return this.findAction;
    }

    public void setFocus() {
        super.setFocus();
        this.enableOrDisablePageControls(this.getCurrentPage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerChangeListener
    implements IPartListener,
    ShellListener {
        private boolean isActivePart = false;

        private InnerChangeListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> partActivated : " + part.getTitle());
            }
            if (part.equals(Editor.this)) {
                this.isActivePart = true;
                Editor.this.checkAndUpdateStatus();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> partBroughtToTop : " + part.getTitle());
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> partClosed : " + part.getTitle());
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> partDeactivated : " + part.getTitle());
            }
            if (part.equals(Editor.this)) {
                this.isActivePart = false;
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> partOpened : " + part.getTitle());
            }
        }

        public void shellActivated(ShellEvent e) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> shellActivated ");
            }
            if (this.isActivePart) {
                Editor.this.checkAndUpdateStatus();
            }
        }

        public void shellClosed(ShellEvent e) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> shellClosed ");
            }
        }

        public void shellDeactivated(ShellEvent e) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> shellDeactivated ");
            }
        }

        public void shellDeiconified(ShellEvent e) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> shellDeiconified ");
            }
        }

        public void shellIconified(ShellEvent e) {
            if (Editor.getTracer().path()) {
                Editor.getTracer().path("InnerPartListener -> shellIconified ");
            }
        }
    }

    private class InnerElementStateListener
    implements IElementStateListener {
        private InnerElementStateListener() {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
            if (Editor.this.getCurrentPage() != Editor.this.getSourcePageID()) {
                if (Editor.this.createModelFromSourcePage()) {
                    Editor.this.getSpecificPages()[Editor.this.getCurrentPage()].initControls();
                    Editor.this.setDirtyFlag(false);
                } else {
                    Editor.this.pageChange(Editor.this.getSourcePageID());
                }
            }
        }

        public void elementDeleted(Object element) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }
    }
}

