/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.jsp.util.scanner;

import com.tssap.editors.jsp.util.rule.JspBracketsRule;
import com.tssap.editors.util.ColorManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.jdt.internal.ui.text.JavaWordDetector;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JspCodeScanner
extends AbstractJavaScanner {
    private static final String SOURCE_VERSION = "org.eclipse.jdt.core.compiler.source";
    public static final String JSP_SCRIPTLET = "jsp:scriptlet";
    public static final String JSP_EXPRESSION = "jsp:expression";
    public static final String JSP_DECLARATION = "jsp:declaration";
    private static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "interface", "native", "new", "package", "private", "protected", "public", "return", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while"};
    private static String[] fgNewKeywords = new String[]{"assert"};
    private static String[] fgTypes = new String[]{"void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double"};
    private static String[] fgConstants = new String[]{"false", "null", "true"};
    private static String[] jspVariables = new String[]{"request", "response", "session", "out"};
    private static String[] jspDelimiters = new String[]{"jsp:scriptlet", "jsp:expression", "jsp:declaration"};
    private static String[] fgTokenProperties = new String[]{"java_keyword", "java_string", "java_default", "jsp_bracket", "jsp_variable"};
    private VersionedWordRule fVersionedWordRule;

    public JspCodeScanner(ColorManager jspManager, IPreferenceStore store) {
        super((IColorManager)jspManager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        JavaWordDetector javaWordDect = new JavaWordDetector();
        JavaWhitespaceDetector javaWsDect = new JavaWhitespaceDetector();
        InnerJspWordDetector jspWordDect = new InnerJspWordDetector();
        Token javaStringToken = this.getToken("java_string");
        rules.add(new SingleLineRule("'", "'", (IToken)javaStringToken, '\\'));
        rules.add(new SingleLineRule("\"", "\"", (IToken)javaStringToken, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)javaWsDect));
        Object version = null;
        try {
            version = JavaCore.getOptions().get(SOURCE_VERSION);
        }
        catch (NullPointerException x) {
            // empty catch block
        }
        Token javaKeywordToken = this.getToken("java_keyword");
        if (version instanceof String) {
            this.fVersionedWordRule = new VersionedWordRule((IWordDetector)javaWordDect, "1.4", true, version);
            int i = 0;
            while (i < fgNewKeywords.length) {
                this.fVersionedWordRule.addWord(fgNewKeywords[i], (IToken)javaKeywordToken);
                ++i;
            }
            rules.add((Object)this.fVersionedWordRule);
        }
        Token javaDefaultToken = this.getToken("java_default");
        WordRule wordRule = new WordRule((IWordDetector)javaWordDect, (IToken)javaDefaultToken);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)javaKeywordToken);
            ++i;
        }
        int i2 = 0;
        while (i2 < fgTypes.length) {
            wordRule.addWord(fgTypes[i2], (IToken)javaKeywordToken);
            ++i2;
        }
        int i3 = 0;
        while (i3 < fgConstants.length) {
            wordRule.addWord(fgConstants[i3], (IToken)javaKeywordToken);
            ++i3;
        }
        Token jspVarToken = this.getToken("jsp_variable");
        int i4 = 0;
        while (i4 < jspVariables.length) {
            wordRule.addWord(jspVariables[i4], (IToken)jspVarToken);
            ++i4;
        }
        rules.add(wordRule);
        Token jspBracketToken = this.getToken("jsp_bracket");
        WordRule jspWordRule = new WordRule((IWordDetector)jspWordDect);
        int i5 = 0;
        while (i5 < jspDelimiters.length) {
            jspWordRule.addWord(jspDelimiters[i5], (IToken)jspBracketToken);
            ++i5;
        }
        rules.add(jspWordRule);
        JspBracketsRule bracketRule = new JspBracketsRule((IToken)jspBracketToken);
        rules.add(bracketRule);
        this.setDefaultReturnToken((IToken)this.getToken("java_default"));
        return rules;
    }

    public void setRules(IRule[] rules) {
        int i = 0;
        while (i < rules.length) {
            if (rules[i].equals((Object)this.fVersionedWordRule)) break;
            ++i;
        }
        if (i == rules.length) {
            this.fVersionedWordRule = null;
        }
        super.setRules(rules);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(SOURCE_VERSION) || super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SOURCE_VERSION)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                String s = (String)value;
                if (this.fVersionedWordRule != null) {
                    this.fVersionedWordRule.setCurrentVersion(s);
                }
            }
        } else if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    private static class VersionedWordRule
    extends WordRule {
        private final String fVersion;
        private final boolean fEnable;
        private String fCurrentVersion;

        public VersionedWordRule(IWordDetector detector, String version, boolean enable, String currentVersion) {
            super(detector);
            this.fVersion = version;
            this.fEnable = enable;
            this.fCurrentVersion = currentVersion;
        }

        public void setCurrentVersion(String version) {
            this.fCurrentVersion = version;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            IToken token = super.evaluate(scanner);
            if (this.fEnable) {
                if (this.fCurrentVersion.equals(this.fVersion)) {
                    return token;
                }
                return Token.UNDEFINED;
            }
            if (this.fCurrentVersion.equals(this.fVersion)) {
                return Token.UNDEFINED;
            }
            return token;
        }
    }

    private static class InnerJspWordDetector
    implements IWordDetector {
        static final String prefix = "<jsp:";
        int charCount = 0;

        private InnerJspWordDetector() {
        }

        public boolean isWordPart(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':';
        }

        public boolean isWordStart(char c) {
            return c == 'j';
        }
    }
}

