/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.jsp.util;

import com.tssap.editors.jsp.util.IJspParserController;
import com.tssap.editors.jsp.util.node.IDeclarationTreeNode;
import com.tssap.editors.jsp.util.node.IDirectiveTreeNode;
import com.tssap.editors.jsp.util.node.IExpressionTreeNode;
import com.tssap.editors.jsp.util.node.IScriptletTreeNode;
import com.tssap.editors.jsp.util.node.impl.DeclarationTreeNode;
import com.tssap.editors.jsp.util.node.impl.DirectiveTreeNode;
import com.tssap.editors.jsp.util.node.impl.ExpressionTreeNode;
import com.tssap.editors.jsp.util.node.impl.ScriptletTreeNode;
import com.tssap.editors.jsp.util.state.JspTag;
import com.tssap.editors.tag.util.DefaultParserController;
import com.tssap.editors.tag.util.node.IAttrTreeNode;
import com.tssap.editors.tag.util.node.IElementTreeNode;
import com.tssap.editors.tag.util.node.ITextTreeNode;
import com.tssap.editors.tag.util.state.ITagParserState;
import java.io.LineNumberReader;
import javax.swing.tree.DefaultMutableTreeNode;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ToolFactory;

public class JspParserController
extends DefaultParserController
implements IJspParserController {
    public static final boolean JSP_DEFAULT_ERROR_PAGE = false;
    public static final boolean JSP_DEFAULT_SESSION = false;
    public static final String JSP_SUPER_CLASS = "HttpJspBase";
    public static final String JSP_DEFAULT_IMPORTS = "java.lang.*, javax.servlet.*, javax.servlet.jsp.*, javax.servlet.http.*";
    public static final String JSP_DEFAULT_DECLARATIONS = "PageContext context = null;\n JspWriter out = null;\n";
    private static ITagParserState jspBasicState = new JspTag();
    private StringBuffer methodBody;
    private boolean errorPage;
    private boolean session;
    private StringBuffer imports;
    private StringBuffer declarations;
    private String superClass;

    public ITagParserState provideExceptionalState(int readCharacter) {
        if ((char)readCharacter == '%') {
            return jspBasicState;
        }
        return null;
    }

    private void handleNode(DefaultMutableTreeNode node, String traceText, String stackItemKey) throws IllegalStateException {
        this.checkInitialization();
        if (DefaultParserController.trace) {
            System.out.println();
        }
        this.addLocationToNode(node);
        DefaultParserController.TagStackItem newItem = new DefaultParserController.TagStackItem(this, stackItemKey, node);
        this.getTagStack().push(newItem);
        String partition = this.retrieveInputString();
        DefaultParserController.PartitionVectorItem vecItem = new DefaultParserController.PartitionVectorItem(this, partition, node);
        this.getStringPartitions().add(vecItem);
    }

    public DefaultMutableTreeNode insertDeclaration(String declaration) throws IllegalStateException {
        DeclarationTreeNode declaNode = new DeclarationTreeNode(declaration);
        this.handleNode(declaNode, "\n Jsp Declaration: " + declaration, "<%!" + declaration);
        this.addJavaDeclaration(declaration);
        return declaNode;
    }

    public DefaultMutableTreeNode insertDirective(String directive, IAttrTreeNode[] attributeNodes) throws IllegalStateException {
        DirectiveTreeNode directNode = new DirectiveTreeNode(directive);
        this.handleNode(directNode, "\n Jsp Directive: " + directive, "<%@" + directive);
        int n = 0;
        while (n < attributeNodes.length) {
            IAttrTreeNode attrNode = attributeNodes[n];
            directNode.add(attrNode);
            String type = attrNode.getName();
            String value = attrNode.getValue();
            if (directive.equalsIgnoreCase("page")) {
                if (type.equalsIgnoreCase("import")) {
                    this.addImportStatements(value);
                } else if (type.equalsIgnoreCase("session")) {
                    this.setSession(value.trim().equalsIgnoreCase("true"));
                } else if (type.equalsIgnoreCase("errorPage")) {
                    this.setErrorPage(value.trim().equalsIgnoreCase("true"));
                }
            }
            ++n;
        }
        return directNode;
    }

    public DefaultMutableTreeNode insertExpression(String expression) throws IllegalStateException {
        ExpressionTreeNode directNode = new ExpressionTreeNode(expression);
        this.handleNode(directNode, "\n Jsp Expression: " + expression, "<%=" + expression);
        this.addJavaExpression(expression);
        return directNode;
    }

    public DefaultMutableTreeNode insertScriptlet(String scriptlet) throws IllegalStateException {
        ScriptletTreeNode directNode = new ScriptletTreeNode(scriptlet);
        this.handleNode(directNode, "\n Jsp Scriptlet: " + scriptlet, "<%" + scriptlet);
        this.addJavaStatement(scriptlet);
        return directNode;
    }

    protected String formatPartition(String partitionString, DefaultMutableTreeNode partitionNode, String tabCharacters, String newLine, int depth) {
        String formattedString = null;
        if (partitionNode instanceof IScriptletTreeNode) {
            String prefix = partitionNode instanceof IScriptletTreeNode ? "<%" : "<jsp:scriptlet>";
            String suffix = partitionNode instanceof IScriptletTreeNode ? "%>" : "<jsp:scriptlet>";
            String processString = partitionString;
            if (partitionString.startsWith(prefix)) {
                processString = processString.substring(prefix.length());
            } else {
                prefix = "";
            }
            if (partitionString.endsWith(suffix)) {
                processString = processString.substring(0, processString.length() - suffix.length());
            } else {
                suffix = "";
            }
            StringBuffer outputBuffer = new StringBuffer(partitionString.length());
            outputBuffer.append(newLine);
            int t = 0;
            while (t < depth) {
                outputBuffer.append(tabCharacters);
                ++t;
            }
            outputBuffer.append(prefix);
            outputBuffer.append(newLine);
            String formattedCode = JspParserController.getJavaFormatter().format(processString, depth + 1, null, newLine);
            outputBuffer.append(formattedCode);
            outputBuffer.append(newLine);
            int t2 = 0;
            while (t2 < depth) {
                outputBuffer.append(tabCharacters);
                ++t2;
            }
            outputBuffer.append(suffix);
            outputBuffer.append(newLine);
            formattedString = outputBuffer.toString();
        } else if (partitionNode instanceof ITextTreeNode) {
            formattedString = partitionNode.getParent() instanceof IElementTreeNode && ((IElementTreeNode)partitionNode.getParent()).getName().equalsIgnoreCase("jsp:scriptlet") ? "\n" + JspParserController.getJavaFormatter().format(partitionString, depth, null, newLine) : super.formatPartition(partitionString, partitionNode, tabCharacters, newLine, depth);
        } else if (partitionNode instanceof IDeclarationTreeNode || partitionNode instanceof IDirectiveTreeNode) {
            StringBuffer outputBuffer = new StringBuffer(partitionString.length());
            outputBuffer.append(newLine);
            int t = 0;
            while (t < depth) {
                outputBuffer.append(tabCharacters);
                ++t;
            }
            outputBuffer.append(partitionString);
            formattedString = outputBuffer.toString();
        } else {
            formattedString = partitionNode instanceof IExpressionTreeNode ? partitionString : super.formatPartition(partitionString, partitionNode, tabCharacters, newLine, depth);
        }
        return formattedString;
    }

    public String finalizeAsJavaSource() {
        StringBuffer classBuffer = new StringBuffer(4096);
        String locImports = this.getImports().toString();
        int commaIdx = locImports.indexOf(44);
        if (commaIdx >= 0) {
            int oldCommaIdx = 0;
            while (commaIdx >= 0) {
                if (commaIdx - oldCommaIdx > 0) {
                    classBuffer.append("import ");
                    classBuffer.append(this.imports.substring(oldCommaIdx, commaIdx));
                    classBuffer.append(";\n");
                }
                oldCommaIdx = commaIdx + 1;
                commaIdx = locImports.indexOf(44, oldCommaIdx + 1);
            }
            if (oldCommaIdx < this.imports.length()) {
                classBuffer.append("import ");
                classBuffer.append(this.imports.substring(oldCommaIdx, this.imports.length()));
                classBuffer.append(";\n");
            }
        } else if (locImports != null && !locImports.equals("")) {
            classBuffer.append("import ");
            classBuffer.append(locImports);
            classBuffer.append(";\n");
        }
        classBuffer.append("public class _JSPServlet extends " + this.getSuperClass() + " { \n");
        classBuffer.append((Object)this.getDeclarations());
        classBuffer.append("public void _jspService(HttpServletRequest request, HttpServletResponse  response) throws IOException, ServletException { \n");
        if (this.isSession()) {
            classBuffer.append("  HttpSession session = null; \n");
        }
        if (this.isErrorPage()) {
            classBuffer.append("  Exception exception = null; \n");
        }
        classBuffer.append((Object)this.getMethodBody());
        classBuffer.append("\n}\n}\n");
        this.setParserInitialized(false);
        return classBuffer.toString();
    }

    private StringBuffer getMethodBody() {
        if (this.methodBody == null) {
            this.methodBody = new StringBuffer(2048);
        }
        return this.methodBody;
    }

    protected void addJavaExpression(String expression) {
        this.getMethodBody().append("out.print(" + expression + ");\n");
    }

    protected void addJavaStatement(String statement) {
        this.getMethodBody().append(statement);
    }

    protected void addPositionMarker() {
        this.getMethodBody().append("<%*>");
    }

    protected void setErrorPage(boolean errorPageFlag) {
        this.errorPage = errorPageFlag;
    }

    protected void addImportStatements(String statement) {
        this.getImports().append("," + statement);
    }

    protected void setSession(boolean sessionFlag) {
        this.session = sessionFlag;
    }

    protected void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    protected boolean isErrorPage() {
        return this.errorPage;
    }

    protected boolean isSession() {
        return this.session;
    }

    protected void addJavaDeclaration(String declaration) {
        this.getDeclarations().append(declaration + "\n");
    }

    protected StringBuffer getDeclarations() {
        if (this.declarations == null) {
            this.declarations = new StringBuffer(JSP_DEFAULT_DECLARATIONS);
        }
        return this.declarations;
    }

    protected StringBuffer getImports() {
        if (this.imports == null) {
            this.imports = new StringBuffer(JSP_DEFAULT_IMPORTS);
        }
        return this.imports;
    }

    protected void clearDeclarations() {
        this.declarations = null;
    }

    protected void clearImports() {
        this.imports = null;
    }

    protected String getSuperClass() {
        return this.superClass;
    }

    public void initializeController(LineNumberReader reader) {
        super.initializeController(reader);
        this.clearDeclarations();
        this.clearImports();
        this.setErrorPage(false);
        this.setSession(false);
        this.setSuperClass(JSP_SUPER_CLASS);
        this.getMethodBody().setLength(0);
    }

    public DefaultMutableTreeNode openTag(String tagName, IAttrTreeNode[] attributeNodes) throws IllegalStateException {
        String nodeName;
        DefaultMutableTreeNode tagNode = super.openTag(tagName, attributeNodes);
        boolean watchForBeanInformation = false;
        if (tagNode instanceof IElementTreeNode && (nodeName = ((IElementTreeNode)((Object)tagNode)).getName()).equalsIgnoreCase("jsp:useBean")) {
            watchForBeanInformation = true;
        }
        String beanClass = null;
        String beanInstance = null;
        int i = 0;
        while (i < attributeNodes.length) {
            IAttrTreeNode attributeNode = attributeNodes[i];
            this.extractExpressions(attributeNode.getValue());
            if (watchForBeanInformation && (attributeNode.getName().equalsIgnoreCase("class") || attributeNode.getName().equalsIgnoreCase("type"))) {
                beanClass = attributeNode.getValue();
            }
            if (watchForBeanInformation && attributeNode.getName().equalsIgnoreCase("id")) {
                beanInstance = attributeNode.getValue();
            }
            ++i;
        }
        if (beanClass != null && beanInstance != null) {
            String javaStatement = beanClass + " " + beanInstance + " = null;";
            this.addJavaDeclaration(javaStatement);
        }
        return tagNode;
    }

    public DefaultMutableTreeNode insertComment(String commentText) throws IllegalStateException {
        this.extractExpressions(commentText);
        return super.insertComment(commentText);
    }

    private void extractExpressions(String valueString) {
        String expression;
        int beginIndex = valueString.indexOf("<%=");
        int endIndex = valueString.indexOf("%>");
        while (beginIndex >= 0 && endIndex > beginIndex + 3) {
            expression = valueString.substring(beginIndex + 3, endIndex);
            this.addJavaExpression(expression);
            beginIndex = valueString.indexOf("<%=", endIndex + 2);
            endIndex = valueString.indexOf("%>", endIndex + 2);
        }
        if (beginIndex >= 0 && endIndex < 0) {
            expression = valueString.substring(beginIndex + 3);
            this.addJavaExpression(expression);
        }
    }

    protected static ICodeFormatter getJavaFormatter() {
        return ToolFactory.createDefaultCodeFormatter(null);
    }
}

