/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.jsp.util;

import com.tssap.editors.jsp.JspEditor;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class JspMarkerAnnotation
extends MarkerAnnotation {
    private IDebugModelPresentation fPresentation;
    private boolean fIsProblemMarker;
    private boolean fNotRelevant = false;

    public JspMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    protected void initialize() {
        IMarker marker = this.getMarker();
        if (MarkerUtilities.isMarkerType((IMarker)marker, (String)IBreakpoint.BREAKPOINT_MARKER)) {
            if (this.fPresentation == null) {
                this.fPresentation = DebugUITools.newDebugModelPresentation();
            }
            this.setLayer(4);
            this.setImage(this.fPresentation.getImage((Object)marker));
            this.fIsProblemMarker = false;
        } else {
            try {
                this.fIsProblemMarker = marker.isSubtypeOf("org.eclipse.jdt.core.problem");
            }
            catch (CoreException ex) {
                JspEditor.getTracer().error("initialize()", ex.getMessage(), (Throwable)ex);
            }
            super.initialize();
        }
    }

    public String getMessage() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("message", "");
        }
        return "";
    }

    public boolean isError() {
        if (this.fIsProblemMarker) {
            int markerSeverity = this.getMarker().getAttribute("severity", -1);
            return markerSeverity == 2;
        }
        return false;
    }

    public boolean isWarning() {
        if (this.fIsProblemMarker) {
            int markerSeverity = this.getMarker().getAttribute("severity", -1);
            return markerSeverity == 1;
        }
        return false;
    }

    public boolean isTemporaryProblem() {
        return false;
    }

    public String[] getArguments() {
        if (this.fIsProblemMarker) {
            return Util.getProblemArgumentsFromMarker((String)this.getMarker().getAttribute("arguments", ""));
        }
        return null;
    }

    public int getId() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("id", -1);
        }
        return 0;
    }

    public boolean isProblem() {
        return this.fIsProblemMarker;
    }

    public boolean isRelevant() {
        return !this.fNotRelevant;
    }

    public Image getImage(Display display) {
        return super.getImage(display);
    }

    public Iterator getOverlaidIterator() {
        return null;
    }
}

