/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.jsp.util;

import com.tssap.editors.jsp.JspEditor;
import com.tssap.editors.jsp.util.scanner.JspSpecialCommentScanner;
import com.tssap.editors.jsp.util.scanner.JspSpecialStringScanner;
import com.tssap.editors.jsp.util.scanner.JspSpecialTagScanner;
import java.util.ArrayList;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;

public class JspDocumentPartitioner
extends DefaultPartitioner {
    public static final String CONTENT_TYPES_JSP_CATEGORY = "__content_types_jsp_category";
    private DefaultPositionUpdater jspPositionUpdater = new DefaultPositionUpdater("__content_types_jsp_category");
    private final IToken embedingToken;
    private final IPartitionTokenScanner embedingScanner;
    private final JspSpecialStringScanner stringScanner;
    private final JspSpecialTagScanner tagScanner;
    private final JspSpecialCommentScanner commentScanner;
    private final String[] legalEmbedContentTypes;
    private final String embededContentType;
    private IToken lookahead = null;
    private int lookaheadOffset = 0;
    private int lookaheadLength = 0;

    public JspDocumentPartitioner(IPartitionTokenScanner scanner, String[] legalContentTypes, IToken embedingToken, IPartitionTokenScanner embedScanner, String[] legalEmbedContentTypes, JspSpecialCommentScanner commentScanner, JspSpecialTagScanner tagScanner, JspSpecialStringScanner stringScanner) {
        super(scanner, legalContentTypes);
        this.embedingToken = embedingToken;
        this.embedingScanner = embedScanner;
        this.commentScanner = commentScanner;
        this.stringScanner = stringScanner;
        this.tagScanner = tagScanner;
        this.legalEmbedContentTypes = legalEmbedContentTypes;
        this.embededContentType = this.getTokenContentType(this.embedingToken);
    }

    public void connect(IDocument document) {
        document.addPositionCategory(CONTENT_TYPES_JSP_CATEGORY);
        super.connect(document);
    }

    public void disconnect() {
        super.disconnect();
        Assert.isTrue((boolean)this.fDocument.containsPositionCategory(CONTENT_TYPES_JSP_CATEGORY));
        try {
            this.fDocument.removePositionCategory(CONTENT_TYPES_JSP_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
    }

    protected void initialize() {
        this.fScanner.setRange(this.fDocument, 0, this.fDocument.getLength());
        this.lookahead = null;
        try {
            IToken token = this.fScanner.nextToken();
            while (!token.isEOF()) {
                String contentType = this.getTokenContentType(token);
                if (this.isSupportedContentType(contentType)) {
                    int length;
                    int start;
                    String embededContentType;
                    IToken embededToken;
                    TypedPosition p = new TypedPosition(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength(), contentType);
                    if (this.embedingToken == token) {
                        this.fDocument.addPosition(CONTENT_TYPES_JSP_CATEGORY, (Position)p);
                        this.embedingScanner.setRange(this.fDocument, this.fScanner.getTokenOffset(), this.fScanner.getTokenLength());
                        embededToken = this.embedingScanner.nextToken();
                        while (!embededToken.isEOF()) {
                            embededContentType = this.getTokenContentType(this.skipEmbededDefaultToken(embededToken));
                            start = this.lookahead != null ? this.lookaheadOffset : this.embedingScanner.getTokenOffset();
                            int n = length = this.lookahead != null ? this.lookaheadLength : this.embedingScanner.getTokenLength();
                            if (this.isSupportedEmbededContentType(embededContentType)) {
                                TypedPosition ep = new TypedPosition(start, length, embededContentType);
                                this.fDocument.addPosition("__content_types_category", (Position)ep);
                            }
                            if (this.lookahead != null) {
                                embededToken = this.lookahead;
                                this.lookahead = null;
                                continue;
                            }
                            embededToken = this.embedingScanner.nextToken();
                        }
                    } else if (contentType == "__tag_comment") {
                        this.fDocument.addPosition("__content_types_category", (Position)p);
                        this.commentScanner.setRange(this.fDocument, this.fScanner.getTokenOffset(), this.fScanner.getTokenLength());
                        embededToken = this.commentScanner.nextToken();
                        while (!embededToken.isEOF()) {
                            embededContentType = this.getTokenContentType(this.skipEmbededDefaultToken1(embededToken, (RuleBasedScanner)this.commentScanner));
                            start = this.lookahead != null ? this.lookaheadOffset : this.commentScanner.getTokenOffset();
                            int n = length = this.lookahead != null ? this.lookaheadLength : this.commentScanner.getTokenLength();
                            if (embededContentType == "__jsp_code" && this.lookahead == null) {
                                TypedPosition ep = new TypedPosition(start, length, embededContentType);
                                this.fDocument.addPosition(CONTENT_TYPES_JSP_CATEGORY, (Position)ep);
                            }
                            if (this.lookahead != null) {
                                embededToken = this.lookahead;
                                this.lookahead = null;
                                continue;
                            }
                            embededToken = this.commentScanner.nextToken();
                        }
                    } else if (contentType == "__xml_tag") {
                        this.fDocument.addPosition("__content_types_category", (Position)p);
                        this.tagScanner.setRange(this.fDocument, this.fScanner.getTokenOffset(), this.fScanner.getTokenLength());
                        embededToken = this.tagScanner.nextToken();
                        while (!embededToken.isEOF()) {
                            embededContentType = this.getTokenContentType(this.skipEmbededDefaultToken1(embededToken, (RuleBasedScanner)this.tagScanner));
                            start = this.lookahead != null ? this.lookaheadOffset : this.tagScanner.getTokenOffset();
                            int n = length = this.lookahead != null ? this.lookaheadLength : this.tagScanner.getTokenLength();
                            if (embededContentType == "__jsp_code" && this.lookahead == null) {
                                start = this.stringScanner.getTokenOffset();
                                length = this.stringScanner.getTokenLength();
                                TypedPosition ep = new TypedPosition(start, length, embededContentType);
                                this.fDocument.addPosition(CONTENT_TYPES_JSP_CATEGORY, (Position)ep);
                            } else if (embededContentType == "__tag_string") {
                                int newLen = this.fScanner.getTokenLength() - (this.tagScanner.getTokenOffset() - this.fScanner.getTokenOffset());
                                this.stringScanner.setRange(this.fDocument, this.tagScanner.getTokenOffset(), newLen);
                                IToken embededToken1 = this.stringScanner.nextToken();
                                while (!embededToken1.isEOF()) {
                                    int length1;
                                    String embededContentType1 = this.getTokenContentType(this.skipEmbededDefaultToken1(embededToken1, (RuleBasedScanner)this.stringScanner));
                                    int start1 = this.lookahead != null ? this.lookaheadOffset : this.stringScanner.getTokenOffset();
                                    int n2 = length1 = this.lookahead != null ? this.lookaheadLength : this.stringScanner.getTokenLength();
                                    if (embededContentType1 == "__jsp_code" && this.lookahead == null) {
                                        TypedPosition ep = new TypedPosition(start1, length1, embededContentType1);
                                        this.fDocument.addPosition(CONTENT_TYPES_JSP_CATEGORY, (Position)ep);
                                        int newOffset = start1 + length1;
                                        int newlen = this.fScanner.getTokenLength() - (newOffset - this.fScanner.getTokenOffset());
                                        this.tagScanner.setRange(this.fDocument, newOffset, newlen);
                                    }
                                    if (this.lookahead != null) {
                                        embededToken1 = this.lookahead;
                                        this.lookahead = null;
                                        continue;
                                    }
                                    embededToken1 = this.stringScanner.nextToken();
                                }
                            }
                            if (this.lookahead != null) {
                                embededToken = this.lookahead;
                                this.lookahead = null;
                                continue;
                            }
                            embededToken = this.tagScanner.nextToken();
                        }
                    } else {
                        this.fDocument.addPosition("__content_types_category", (Position)p);
                    }
                }
                token = this.fScanner.nextToken();
            }
        }
        catch (BadLocationException ex) {
            JspEditor.getTracer().error("initialize()", ex.getMessage(), (Throwable)ex);
        }
        catch (BadPositionCategoryException ex) {
            JspEditor.getTracer().error("initialize()", ex.getMessage(), (Throwable)ex);
        }
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        ArrayList<TypedRegion> list = new ArrayList<TypedRegion>();
        try {
            int end;
            int start;
            int gapOffset;
            int endOffset = offset + length;
            Position[] category = this.fDocument.getPositions("__content_types_category");
            TypedPosition previous = null;
            TypedPosition current = null;
            Position gap = null;
            String gapDefaultContentType = null;
            int i = 0;
            while (i < category.length) {
                current = (TypedPosition)category[i];
                gapOffset = previous != null ? previous.getOffset() + previous.getLength() : 0;
                gap = current.getOffset() > gapOffset ? new Position(gapOffset, current.getOffset() - gapOffset) : new Position(gapOffset, 0);
                if (gap.getLength() > 0 && gap.overlapsWith(offset, length)) {
                    start = Math.max(offset, gapOffset);
                    end = Math.min(endOffset, gap.getOffset() + gap.getLength());
                    gapDefaultContentType = this.isJSPPartition(start) ? this.embededContentType : "__dftl_partition_content_type";
                    list.add(new TypedRegion(start, end - start, gapDefaultContentType));
                }
                if (current.overlapsWith(offset, length)) {
                    start = Math.max(offset, current.getOffset());
                    end = Math.min(endOffset, current.getOffset() + current.getLength());
                    while (this.isJSPPartitionInside(start, end)) {
                        Position pos = this.getNextPositionInside(start, end);
                        int joff = pos.getOffset();
                        list.add(new TypedRegion(start, joff - start, current.getType()));
                        int jlen = pos.getLength();
                        list.add(new TypedRegion(joff, jlen, this.embededContentType));
                        boolean islastJsp = this.isLastJsp(start, end);
                        start = joff + jlen;
                        if (islastJsp) {
                            try {
                                int nextString = this.fDocument.search(start, "\"", true, true, false);
                                if (nextString <= 0 || nextString >= end) continue;
                                nextString = nextString - start + 1;
                                list.add(new TypedRegion(start, nextString, "__jsp_string_part"));
                                start += nextString;
                            }
                            catch (BadLocationException ex) {
                                JspEditor.getTracer().error("computePartitioning(int offset, int length)", ex.getMessage(), (Throwable)ex);
                            }
                            continue;
                        }
                        Position pos1 = this.getNextPositionInside(start, end);
                        int joff1 = pos1.getOffset();
                        list.add(new TypedRegion(start, joff1 - start, "__jsp_string_part"));
                        start = start + joff1 - start - 1;
                    }
                    if (end < start) {
                        end = start;
                    }
                    list.add(new TypedRegion(start, end - start, current.getType()));
                }
                previous = current;
                ++i;
            }
            if (previous != null && (gap = new Position(gapOffset = previous.getOffset() + previous.getLength(), this.fDocument.getLength() - gapOffset)).getLength() > 0 && gap.overlapsWith(offset, length)) {
                start = Math.max(offset, gapOffset);
                end = Math.min(endOffset, this.fDocument.getLength());
                gapDefaultContentType = this.isJSPPartition(start) ? this.embededContentType : "__dftl_partition_content_type";
                list.add(new TypedRegion(start, end - start, gapDefaultContentType));
            }
            if (list.isEmpty()) {
                list.add(new TypedRegion(offset, length, "__dftl_partition_content_type"));
            }
        }
        catch (BadPositionCategoryException ex) {
            JspEditor.getTracer().error("computePartitioning(int offset, int length)", ex.getMessage(), (Throwable)ex);
        }
        TypedRegion[] result = new TypedRegion[list.size()];
        list.toArray(result);
        return result;
    }

    protected boolean isSupportedEmbededContentType(String contentType) {
        if (contentType != null) {
            int i = 0;
            while (i < this.legalEmbedContentTypes.length) {
                if (this.legalEmbedContentTypes[i].equals(contentType)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected TypedPosition findClosestPosition(int offset) {
        try {
            int index = this.fDocument.computeIndexInCategory("__content_types_category", offset);
            Position[] category = this.fDocument.getPositions("__content_types_category");
            int index1 = this.fDocument.computeIndexInCategory(CONTENT_TYPES_JSP_CATEGORY, offset);
            Position[] category1 = this.fDocument.getPositions(CONTENT_TYPES_JSP_CATEGORY);
            if (category.length == 0 && category1.length == 0) {
                return null;
            }
            if (index < category.length && offset == category[index].offset) {
                return (TypedPosition)category[index];
            }
            if (category1.length != 0 && index1 < category1.length && offset == category1[index1].offset) {
                return (TypedPosition)category1[index1];
            }
            if (index1 > 0) {
                return (TypedPosition)category1[--index1];
            }
            if (index > 0) {
                --index;
            }
            return (TypedPosition)category[index];
        }
        catch (BadPositionCategoryException ex) {
            JspEditor.getTracer().error("findClosestPosition(int offset)", ex.getMessage(), (Throwable)ex);
        }
        catch (BadLocationException ex) {
            JspEditor.getTracer().error("findClosestPosition(int offset)", ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public boolean documentChanged(DocumentEvent event) {
        return super.documentChanged(event);
    }

    public IRegion documentChanged2(DocumentEvent e) {
        try {
            int length;
            int start;
            IDocument d = e.getDocument();
            Position[] category = d.getPositions("__content_types_category");
            IRegion line = d.getLineInformationOfOffset(e.getOffset());
            int reparseStart = line.getOffset();
            int partitionStart = 0;
            String contentType = null;
            int first = d.computeIndexInCategory("__content_types_category", reparseStart);
            if (first > 0) {
                TypedPosition partition = (TypedPosition)category[first - 1];
                if (partition.includes(reparseStart)) {
                    partitionStart = partition.getOffset();
                    contentType = partition.getType();
                    if (e.getOffset() == partition.getOffset() + partition.getLength()) {
                        reparseStart = partitionStart;
                    }
                    --first;
                } else if (reparseStart == e.getOffset() && reparseStart == partition.getOffset() + partition.getLength()) {
                    partitionStart = partition.getOffset();
                    contentType = partition.getType();
                    reparseStart = partitionStart;
                    --first;
                } else {
                    partitionStart = partition.getOffset() + partition.getLength();
                    contentType = "__dftl_partition_content_type";
                }
            }
            this.fPositionUpdater.update(e);
            int i = first;
            while (i < category.length) {
                Position p = category[i];
                if (p.isDeleted) {
                    this.rememberDeletedOffset(e.getOffset());
                    break;
                }
                ++i;
            }
            category = d.getPositions("__content_types_category");
            this.jspPositionUpdater.update(e);
            Position[] jspCategory = d.getPositions(CONTENT_TYPES_JSP_CATEGORY);
            boolean isFirstJSP = false;
            int jspReparseStart = reparseStart;
            int jspPartitionStart = partitionStart;
            int jspLastScannedPosition = reparseStart;
            String jspContentType = contentType;
            int jspFirst = d.computeIndexInCategory(CONTENT_TYPES_JSP_CATEGORY, reparseStart);
            if (jspFirst > 0) {
                if (jspCategory[jspFirst - 1].includes(reparseStart)) {
                    --jspFirst;
                }
                if (jspFirst < jspCategory.length && jspCategory[jspFirst].includes(reparseStart)) {
                    partitionStart = reparseStart = jspCategory[jspFirst].getOffset();
                    if (contentType == "__dftl_partition_content_type") {
                        jspContentType = this.embededContentType;
                    }
                    contentType = this.embededContentType;
                    isFirstJSP = true;
                }
            }
            boolean inJSP = false;
            this.lookahead = null;
            this.fScanner.setPartialRange(d, reparseStart, d.getLength(), contentType, partitionStart);
            int lastScannedPosition = reparseStart;
            IToken token = this.fScanner.nextToken();
            boolean newScanner = false;
            while (!token.isEOF()) {
                contentType = this.getTokenContentType(token);
                newScanner = false;
                if (token == this.embedingToken || inJSP) {
                    if (!inJSP) {
                        if (isFirstJSP) {
                            isFirstJSP = false;
                            this.embedingScanner.setPartialRange(d, jspReparseStart, this.fScanner.getTokenLength() + this.fScanner.getTokenOffset() - jspReparseStart, jspContentType, jspPartitionStart);
                        } else {
                            this.embedingScanner.setPartialRange(d, this.fScanner.getTokenOffset(), this.fScanner.getTokenLength(), this.embededContentType, this.fScanner.getTokenOffset());
                        }
                        token = this.embedingScanner.nextToken();
                        inJSP = true;
                        int jspStart = this.fScanner.getTokenOffset();
                        int jspLength = this.fScanner.getTokenLength();
                        jspLastScannedPosition = jspStart + jspLength - 1;
                        while (jspFirst < jspCategory.length) {
                            TypedPosition p = (TypedPosition)jspCategory[jspFirst];
                            if (jspLastScannedPosition < p.offset + p.length && (!p.overlapsWith(jspStart, jspLength) || d.containsPosition(CONTENT_TYPES_JSP_CATEGORY, jspStart, jspLength))) break;
                            d.removePosition(CONTENT_TYPES_JSP_CATEGORY, (Position)p);
                            ++jspFirst;
                        }
                        if (!d.containsPosition(CONTENT_TYPES_JSP_CATEGORY, jspStart, jspLength)) {
                            try {
                                d.addPosition(CONTENT_TYPES_JSP_CATEGORY, (Position)new TypedPosition(jspStart, jspLength, this.embededContentType));
                            }
                            catch (BadPositionCategoryException ex) {
                                JspEditor.getTracer().error("documentChanged2(DocumentEvent e)", ex.getMessage(), (Throwable)ex);
                            }
                            catch (BadLocationException ex) {
                                JspEditor.getTracer().error("documentChanged2(DocumentEvent e)", ex.getMessage(), (Throwable)ex);
                            }
                        } else {
                            ++jspFirst;
                        }
                    }
                    if (token.isEOF()) {
                        token = this.fScanner.nextToken();
                        continue;
                    }
                    contentType = this.getTokenContentType(this.skipEmbededDefaultToken(token));
                } else if (contentType == "__tag_comment") {
                    this.commentScanner.setRange(d, this.fScanner.getTokenOffset(), this.fScanner.getTokenLength());
                    IToken embededToken = this.commentScanner.nextToken();
                    while (!embededToken.isEOF()) {
                        int length2;
                        String embededContentType = this.getTokenContentType(this.skipEmbededDefaultToken1(embededToken, (RuleBasedScanner)this.commentScanner));
                        int start2 = this.lookahead != null ? this.lookaheadOffset : this.commentScanner.getTokenOffset();
                        int n = length2 = this.lookahead != null ? this.lookaheadLength : this.commentScanner.getTokenLength();
                        if (embededContentType == "__jsp_code" && this.lookahead == null) {
                            TypedPosition ep = new TypedPosition(start2, length2, embededContentType);
                            d.addPosition(CONTENT_TYPES_JSP_CATEGORY, (Position)ep);
                        }
                        if (this.lookahead != null) {
                            embededToken = this.lookahead;
                            this.lookahead = null;
                            continue;
                        }
                        embededToken = this.commentScanner.nextToken();
                    }
                } else if (contentType == "__xml_tag") {
                    this.tagScanner.setRange(d, this.fScanner.getTokenOffset(), this.fScanner.getTokenLength());
                    IToken embededToken = this.tagScanner.nextToken();
                    while (!embededToken.isEOF()) {
                        int length3;
                        String embededContentType = this.getTokenContentType(this.skipEmbededDefaultToken1(embededToken, (RuleBasedScanner)this.tagScanner));
                        int start3 = this.lookahead != null ? this.lookaheadOffset : this.tagScanner.getTokenOffset();
                        int n = length3 = this.lookahead != null ? this.lookaheadLength : this.tagScanner.getTokenLength();
                        if (embededContentType == "__jsp_code" && this.lookahead == null) {
                            start3 = this.stringScanner.getTokenOffset();
                            length3 = this.stringScanner.getTokenLength();
                            TypedPosition ep = new TypedPosition(start3, length3, embededContentType);
                            d.addPosition(CONTENT_TYPES_JSP_CATEGORY, (Position)ep);
                        } else if (embededContentType == "__tag_string") {
                            int newLen = this.fScanner.getTokenLength() - (this.tagScanner.getTokenOffset() - this.fScanner.getTokenOffset());
                            this.stringScanner.setRange(d, this.tagScanner.getTokenOffset(), newLen);
                            IToken embededToken1 = this.stringScanner.nextToken();
                            while (!embededToken1.isEOF()) {
                                int length1;
                                String embededContentType1 = this.getTokenContentType(this.skipEmbededDefaultToken1(embededToken1, (RuleBasedScanner)this.stringScanner));
                                int start1 = this.lookahead != null ? this.lookaheadOffset : this.stringScanner.getTokenOffset();
                                int n2 = length1 = this.lookahead != null ? this.lookaheadLength : this.stringScanner.getTokenLength();
                                if (embededContentType1 == "__jsp_code" && this.lookahead == null) {
                                    TypedPosition ep = new TypedPosition(start1, length1, embededContentType1);
                                    d.addPosition(CONTENT_TYPES_JSP_CATEGORY, (Position)ep);
                                    int newOffset = start1 + length1;
                                    int newlen = this.fScanner.getTokenLength() - (newOffset - this.fScanner.getTokenOffset());
                                    this.tagScanner.setRange(d, newOffset, newlen);
                                }
                                if (this.lookahead != null) {
                                    embededToken1 = this.lookahead;
                                    this.lookahead = null;
                                    continue;
                                }
                                embededToken1 = this.stringScanner.nextToken();
                            }
                        }
                        if (this.lookahead != null) {
                            embededToken = this.lookahead;
                            this.lookahead = null;
                            continue;
                        }
                        embededToken = this.tagScanner.nextToken();
                    }
                }
                if (!this.isSupportedContentType(contentType)) {
                    token = this.fScanner.nextToken();
                    continue;
                }
                if (newScanner) {
                    int n = inJSP ? (this.lookahead != null ? this.lookaheadOffset : this.commentScanner.getTokenOffset()) : (start = this.fScanner.getTokenOffset());
                    length = inJSP ? (this.lookahead != null ? this.lookaheadLength : this.commentScanner.getTokenLength()) : this.fScanner.getTokenLength();
                    lastScannedPosition = start + length - 1;
                } else {
                    int n = inJSP ? (this.lookahead != null ? this.lookaheadOffset : this.embedingScanner.getTokenOffset()) : (start = this.fScanner.getTokenOffset());
                    length = inJSP ? (this.lookahead != null ? this.lookaheadLength : this.embedingScanner.getTokenLength()) : this.fScanner.getTokenLength();
                    lastScannedPosition = start + length - 1;
                }
                while (first < category.length) {
                    TypedPosition p = (TypedPosition)category[first];
                    if (lastScannedPosition < p.offset + p.length && (!p.overlapsWith(start, length) || d.containsPosition("__content_types_category", start, length) && contentType.equals(p.getType()))) break;
                    this.rememberRegion(p.offset, p.length);
                    d.removePosition("__content_types_category", (Position)p);
                    ++first;
                }
                if (d.containsPosition("__content_types_category", start, length)) {
                    if (lastScannedPosition > e.getOffset()) {
                        this.removeOldSkipedPartitions(d, category, first, start, length, jspCategory, jspLastScannedPosition, jspFirst);
                        return this.createRegion();
                    }
                    ++first;
                } else {
                    try {
                        d.addPosition("__content_types_category", (Position)new TypedPosition(start, length, contentType));
                        this.rememberRegion(start, length);
                    }
                    catch (BadPositionCategoryException ex) {
                        JspEditor.getTracer().error("documentChanged2(DocumentEvent e)", ex.getMessage(), (Throwable)ex);
                    }
                    catch (BadLocationException ex) {
                        JspEditor.getTracer().error("documentChanged2(DocumentEvent e)", ex.getMessage(), (Throwable)ex);
                    }
                }
                if (inJSP) {
                    if (this.lookahead != null) {
                        token = this.lookahead;
                        this.lookahead = null;
                    } else {
                        token = newScanner ? this.commentScanner.nextToken() : this.embedingScanner.nextToken();
                    }
                    if (!token.isEOF()) continue;
                    inJSP = false;
                    token = this.fScanner.nextToken();
                    continue;
                }
                token = this.fScanner.nextToken();
            }
            start = this.fScanner.getTokenOffset();
            length = this.fScanner.getTokenLength();
            this.removeOldSkipedPartitions(d, category, first, start, length, jspCategory, jspLastScannedPosition, jspFirst);
        }
        catch (BadPositionCategoryException ex) {
            JspEditor.getTracer().error("documentChanged2(DocumentEvent e)", ex.getMessage(), (Throwable)ex);
        }
        catch (BadLocationException ex) {
            JspEditor.getTracer().error("documentChanged2(DocumentEvent e)", ex.getMessage(), (Throwable)ex);
        }
        return this.createRegion();
    }

    private void removeOldSkipedPartitions(IDocument d, Position[] category, int first, int start, int length, Position[] jspCategory, int jspLastScannedPosition, int jspFirst) throws BadPositionCategoryException {
        TypedPosition p;
        int lastScannedPosition = start + (length > 0 ? length - 1 : 0);
        jspLastScannedPosition = Math.max(jspLastScannedPosition, lastScannedPosition);
        while (jspFirst < jspCategory.length) {
            p = (TypedPosition)jspCategory[jspFirst];
            if (jspLastScannedPosition < p.offset) break;
            d.removePosition(CONTENT_TYPES_JSP_CATEGORY, (Position)p);
            this.rememberRegion(p.offset, p.length);
            ++jspFirst;
        }
        while (first < category.length) {
            p = (TypedPosition)category[first];
            if (lastScannedPosition < p.offset + p.length) break;
            d.removePosition("__content_types_category", (Position)p);
            this.rememberRegion(p.offset, p.length);
            ++first;
        }
    }

    private void rememberRegion(int offset, int length) {
        if (this.fStartOffset == -1) {
            this.fStartOffset = offset;
        } else if (offset < this.fStartOffset) {
            this.fStartOffset = offset;
        }
        int endOffset = offset + length;
        if (this.fEndOffset == -1) {
            this.fEndOffset = endOffset;
        } else if (endOffset > this.fEndOffset) {
            this.fEndOffset = endOffset;
        }
    }

    private void rememberDeletedOffset(int offset) {
        this.fDeleteOffset = offset;
    }

    private IRegion createRegion() {
        if (this.fDeleteOffset == -1) {
            if (this.fStartOffset == -1 || this.fEndOffset == -1) {
                return null;
            }
            return new Region(this.fStartOffset, this.fEndOffset - this.fStartOffset);
        }
        if (this.fStartOffset == -1 || this.fEndOffset == -1) {
            return new Region(this.fDeleteOffset, 0);
        }
        int offset = Math.min(this.fDeleteOffset, this.fStartOffset);
        int endOffset = Math.max(this.fDeleteOffset, this.fEndOffset);
        return new Region(offset, endOffset - offset);
    }

    public boolean isJSPPartition(int offset) {
        try {
            Position[] jspCategory = this.fDocument.getPositions(CONTENT_TYPES_JSP_CATEGORY);
            if (jspCategory.length > 0) {
                int i = 0;
                while (i < jspCategory.length && jspCategory[i].getOffset() < offset) {
                    ++i;
                }
                if (i > 0) {
                    --i;
                }
                return jspCategory[i].includes(offset);
            }
        }
        catch (BadPositionCategoryException ex) {
            JspEditor.getTracer().error("isJSPPartition(int offset)", ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    public boolean isJSPPartitionInside(int start, int end) {
        try {
            Position[] jspCategory = this.fDocument.getPositions(CONTENT_TYPES_JSP_CATEGORY);
            if (jspCategory.length > 0) {
                int i = 0;
                while (i < jspCategory.length) {
                    if (jspCategory[i].getOffset() > start && jspCategory[i].getOffset() < end) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (BadPositionCategoryException ex) {
            JspEditor.getTracer().error("isJSPPartitionInside(int start, int end)", ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    public Position getNextPositionInside(int start, int end) {
        try {
            Position[] jspCategory = this.fDocument.getPositions(CONTENT_TYPES_JSP_CATEGORY);
            if (jspCategory.length > 0) {
                int i = 0;
                while (i < jspCategory.length) {
                    if (jspCategory[i].getOffset() > start && jspCategory[i].getOffset() < end) {
                        return jspCategory[i];
                    }
                    ++i;
                }
            }
        }
        catch (BadPositionCategoryException ex) {
            JspEditor.getTracer().error("getNextPositionInside(int start, int end)", ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public boolean isLastJsp(int start, int end) {
        try {
            Position[] jspCategory = this.fDocument.getPositions(CONTENT_TYPES_JSP_CATEGORY);
            int count = 0;
            if (jspCategory.length > 0) {
                int i = 0;
                while (i < jspCategory.length) {
                    if (jspCategory[i].getOffset() > start && jspCategory[i].getOffset() < end) {
                        ++count;
                    }
                    ++i;
                }
            }
            return count == 1;
        }
        catch (BadPositionCategoryException ex) {
            JspEditor.getTracer().error("isLastJsp(int start, int end)", ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private IToken skipEmbededDefaultToken(IToken token) {
        if (this.getTokenContentType(token) == null) {
            this.lookahead = token;
            this.lookaheadOffset = this.embedingScanner.getTokenOffset();
            while (this.getTokenContentType(this.lookahead) == null) {
                this.lookahead = this.embedingScanner.nextToken();
                if (this.lookahead.isEOF()) break;
            }
            this.lookaheadLength = this.embedingScanner.getTokenOffset() - this.lookaheadOffset;
            return this.embedingToken;
        }
        return token;
    }

    private IToken skipEmbededDefaultToken1(IToken token, RuleBasedScanner scanner) {
        if (this.getTokenContentType(token) == null) {
            this.lookahead = token;
            this.lookaheadOffset = scanner.getTokenOffset();
            while (this.getTokenContentType(this.lookahead) == null) {
                this.lookahead = scanner.nextToken();
                if (this.lookahead.isEOF()) break;
            }
            this.lookaheadLength = scanner.getTokenOffset() - this.lookaheadOffset;
            return this.lookahead;
        }
        return token;
    }
}

