/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.jsp.ui;

import com.tssap.editors.EditorPlugin;
import com.tssap.editors.jsp.JspEditor;
import com.tssap.editors.jsp.source.IJspPropertyDefaults;
import com.tssap.editors.jsp.source.JspSourceViewerConfiguration;
import com.tssap.editors.jsp.util.JspDocumentProvider;
import com.tssap.editors.util.ColorButton;
import com.tssap.editors.util.PreferencesUtil;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISimplePane;
import com.tssap.util.ui.pane.ITabbedPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JspPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore fPluginPreferenceStore;
    private IPreferenceStore fTmpPreferenceStore;
    private Combo fTokenList;
    private ColorButton fForegroundColorEditor;
    private Button fBoldCheckBox;
    private SourceViewer fPreviewViewer;
    private final String[][] fListModel = new String[][]{{"JSP Brackets", "jsp_bracket"}, {"JSP Comments", "jsp_comment"}};
    private Button fAttribNewline;
    private Button fUsesSpace;
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            JspPreferencePage.this.fTmpPreferenceStore.setValue((String)JspPreferencePage.this.fTextFields.get(text), text.getText());
        }
    };
    private static final String BOLD_EXT = "_bold";
    private static final PreferencesUtil.OverlayKey[] fJavaKeyList = new PreferencesUtil.OverlayKey[]{new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "java_default"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "java_default_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "java_keyword"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "java_keyword_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "java_multi_line_comment"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "java_multi_line_comment_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "java_single_line_comment"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "java_single_line_comment_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "java_string"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "java_string_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "java_doc_default"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "java_doc_default_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "java_doc_keyword"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "java_doc_keyword_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "java_doc_link"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "java_doc_link_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "java_doc_tag"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "java_doc_tag_bold")};
    private static final PreferencesUtil.OverlayKey[] fJspKeyList = new PreferencesUtil.OverlayKey[]{new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "jsp_bracket"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "jsp_bracket_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "jsp_comment"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "jsp_comment_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "jsp_default"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "jsp_default_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "jsp_directive"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "jsp_directive_bold"), new PreferencesUtil.OverlayKey(PreferencesUtil.STRING, "jsp_variable"), new PreferencesUtil.OverlayKey(PreferencesUtil.BOOLEAN, "jsp_variable_bold")};

    public static final PreferencesUtil.OverlayKey[] getKeyList() {
        ArrayList<PreferencesUtil.OverlayKey> list = new ArrayList<PreferencesUtil.OverlayKey>();
        int i = 0;
        while (i < fJspKeyList.length) {
            list.add(fJspKeyList[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < fJavaKeyList.length) {
            list.add(fJavaKeyList[i2]);
            ++i2;
        }
        return list.toArray(new PreferencesUtil.OverlayKey[0]);
    }

    public JspPreferencePage() {
        this.setDescription("JSP Editor settings");
        this.fPluginPreferenceStore = EditorPlugin.getInstance().getPreferenceStore();
        this.fTmpPreferenceStore = EditorPlugin.getInstance().getTmpPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        ITabbedPane pane = PaneFactory.createTabbedPane((Composite)parent);
        IGridLayoutPane colorPane = pane.addGridLayoutPaneAsTab("Color", 1);
        this.createColorPage(colorPane);
        this.initialize();
        return pane.getComposite();
    }

    private void createColorPage(IGridLayoutPane parent) {
        IGridLayoutPane colorPane = parent.addGridLayoutPane("Color settings", 4, parent.createGridLayoutData(4, 1, true, false));
        colorPane.addTextLabel("Foreground");
        colorPane.addTextLabel("Color");
        colorPane.addTextLabel("Bold", colorPane.createGridLayoutData(1, 1, 2, 1));
        this.fTokenList = colorPane.addComboBox();
        this.fForegroundColorEditor = new ColorButton(colorPane, colorPane.createGridLayoutData(1, 1, 1, 1));
        this.fBoldCheckBox = colorPane.addCheckBox("    ");
        colorPane.addPushButton("Restore Defaults").addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = JspPreferencePage.this.fTokenList.getSelectionIndex();
                String key = JspPreferencePage.this.fListModel[i][1];
                JspPreferencePage.this.fTmpPreferenceStore.setToDefault(key);
                JspPreferencePage.this.fTmpPreferenceStore.setToDefault(key + "_" + "bold");
                JspPreferencePage.this.handleListSelection();
            }
        });
        IGridLayoutPane previewPane = parent.addGridLayoutPane("Preview", 1, parent.createGridLayoutData(4, 4, true, true));
        ISimplePane simplePane = previewPane.addSimplePane(previewPane.createGridLayoutData(4, 4, true, true));
        this.createPreviewer(simplePane.getComposite());
        this.fTokenList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JspPreferencePage.this.handleListSelection();
            }
        });
        this.fForegroundColorEditor.getButton().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = JspPreferencePage.this.fTokenList.getSelectionIndex();
                String key = JspPreferencePage.this.fListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)JspPreferencePage.this.fTmpPreferenceStore, (String)key, (RGB)JspPreferencePage.this.fForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = JspPreferencePage.this.fTokenList.getSelectionIndex();
                String key = JspPreferencePage.this.fListModel[i][1];
                JspPreferencePage.this.fTmpPreferenceStore.setValue(key + "_" + "bold", JspPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
    }

    private Control createPreviewer(Composite parent) {
        this.fPreviewViewer = new SourceViewer(parent, null, 768);
        JspSourceViewerConfiguration config = new JspSourceViewerConfiguration(this.fTmpPreferenceStore, null);
        this.fPreviewViewer.configure((SourceViewerConfiguration)config);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("PreviewCode.txt");
        JspDocumentProvider provider = new JspDocumentProvider(this.fTmpPreferenceStore, (ISourceViewer)this.fPreviewViewer);
        IDocument document = null;
        try {
            document = provider.createDocument(content);
        }
        catch (CoreException ex) {
            JspEditor.getTracer().error("createPreviewer(Composite parent)", ex.getMessage(), (Throwable)ex);
        }
        this.fPreviewViewer.setDocument(document);
        final PreviewerPropertyChangeListener listener = new PreviewerPropertyChangeListener();
        this.fTmpPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)listener);
        this.fPreviewViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JspPreferencePage.this.fTmpPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)listener);
            }
        });
        this.initializeViewerColors((ISourceViewer)this.fPreviewViewer);
        return this.fPreviewViewer.getControl();
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String loadPreviewContentFromFile(String filename) {
        String line;
        String separator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer(512);
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
        while ((line = reader.readLine()) != null) {
            void var2_5;
            buffer.append((String)var2_5);
            buffer.append(separator);
        }
        Object var8_6 = null;
        if (reader == null) return buffer.toString();
        try {
            reader.close();
            return buffer.toString();
        }
        catch (IOException ex2) {
            JspEditor.getTracer().error("loadPreviewContentFromFile(String filename)", ex2.getMessage(), (Throwable)ex2);
        }
        return buffer.toString();
        {
            catch (IOException ex) {
                JspEditor.getTracer().error("loadPreviewContentFromFile(String filename)", ex.getMessage(), (Throwable)ex);
                Object var8_7 = null;
                if (reader == null) return buffer.toString();
                try {
                    reader.close();
                    return buffer.toString();
                }
                catch (IOException ex2) {
                    JspEditor.getTracer().error("loadPreviewContentFromFile(String filename)", ex2.getMessage(), (Throwable)ex2);
                }
                return buffer.toString();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ex2) {
                JspEditor.getTracer().error("loadPreviewContentFromFile(String filename)", ex2.getMessage(), (Throwable)ex2);
            }
            throw throwable;
        }
    }

    private void handleListSelection() {
        int i = this.fTokenList.getSelectionIndex();
        String key = this.fListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fTmpPreferenceStore, (String)key);
        this.fForegroundColorEditor.setColorValue(rgb);
        boolean selected = this.fTmpPreferenceStore.getBoolean(key + "_" + "bold");
        this.fBoldCheckBox.setSelection(selected);
    }

    private void initializeViewerColors(ISourceViewer viewer) {
        StyledText styledText = viewer.getTextWidget();
        Color color = this.fTmpPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : new Color((Device)styledText.getDisplay(), PreferenceConverter.getColor((IPreferenceStore)this.fTmpPreferenceStore, (String)"AbstractTextEditor.Color.Background"));
        styledText.setBackground(color);
    }

    public static void initializeDefaults(IPreferenceStore store) {
        String bold_ext = BOLD_EXT;
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"jsp_bracket", (RGB)IJspPropertyDefaults.COLOR_JSP_BRACKETS_FG);
        store.setDefault("jsp_bracket" + bold_ext, false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"jsp_comment", (RGB)IJspPropertyDefaults.COLOR_JSP_COMMENTS_FG);
        store.setDefault("jsp_comment" + bold_ext, false);
        Plugin javaPlugin = Platform.getPlugin((String)"org.eclipse.jdt.ui");
        Preferences javaPrefs = javaPlugin.getPluginPreferences();
        int i = 0;
        while (i < fJavaKeyList.length) {
            String javaKey = fJavaKeyList[i].getKey();
            String javaValue = javaPrefs.getDefaultString(javaKey);
            store.setDefault(javaKey, javaValue);
            javaValue = javaPrefs.getString(javaKey);
            store.setValue(javaKey, javaValue);
            ++i;
        }
        final IPreferenceStore registerStore = store;
        javaPrefs.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                String prop = event.getProperty();
                int i = 0;
                while (i < fJavaKeyList.length) {
                    String javaKey = fJavaKeyList[i].getKey();
                    if (prop.equals(javaKey)) {
                        PreferencesUtil.setProperty(registerStore, javaKey, event.getNewValue());
                    }
                    ++i;
                }
            }
        });
    }

    private void initialize() {
        int i = 0;
        while (i < this.fListModel.length) {
            this.fTokenList.add(this.fListModel[i][0]);
            ++i;
        }
        this.fTokenList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                JspPreferencePage.this.fTokenList.select(0);
                JspPreferencePage.this.handleListSelection();
            }
        });
        Iterator e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            String key = (String)this.fTextFields.get(t);
            String value = this.fTmpPreferenceStore.getString(key);
            t.setText(value);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        PreferencesUtil.setToDefault(this.fTmpPreferenceStore, fJspKeyList);
        PreferencesUtil.setToDefault(this.fTmpPreferenceStore, fJavaKeyList);
        this.handleListSelection();
        super.performDefaults();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public boolean performOk() {
        PreferencesUtil.copyStore(this.fTmpPreferenceStore, this.fPluginPreferenceStore, fJspKeyList, false);
        PreferencesUtil.copyStore(this.fTmpPreferenceStore, this.fPluginPreferenceStore, fJavaKeyList, false);
        return super.performOk();
    }

    public void dispose() {
        super.dispose();
        if (this.fTmpPreferenceStore instanceof PreferenceStore) {
            PreferenceStore preferenceStore = (PreferenceStore)this.fTmpPreferenceStore;
        }
    }

    private class PreviewerPropertyChangeListener
    implements IPropertyChangeListener {
        private PreviewerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String p = event.getProperty();
            if (p.equals("AbstractTextEditor.Color.Background") || p.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
                JspPreferencePage.this.initializeViewerColors((ISourceViewer)JspPreferencePage.this.fPreviewViewer);
            }
            JspPreferencePage.this.fPreviewViewer.invalidateTextPresentation();
        }
    }
}

