/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.jsp.content;

import com.tssap.editors.jsp.JspEditor;
import com.tssap.editors.jsp.content.JspResultCollector;
import com.tssap.editors.jsp.util.IJspParserController;
import com.tssap.editors.tag.util.ITagParserController;
import com.tssap.editors.tag.util.state.Utility;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.ISearchableNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.CompletionRequestorWrapper;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.template.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.TemplateProposal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class JspContentAssistProzessor
implements IContentAssistProcessor {
    private JspEditor jspEditor;
    private TemplateEngine templateEngine;
    private JavaCompletionProposalComparator comparator;
    private CompletionEngine completionEngine;
    private IContextInformationValidator validator;
    private IJavaProject javaProject;
    private JspResultCollector collector;

    public JspContentAssistProzessor(JspEditor editor) {
        this.jspEditor = editor;
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
    }

    protected void restrictProposalsToVisibility(boolean restrict) {
        Hashtable options = JavaCore.getOptions();
        Object value = options.get("org.eclipse.jdt.core.codeComplete.visibilityCheck");
        if (value instanceof String) {
            String newValue;
            String string = newValue = restrict ? "enabled" : "disabled";
            if (!newValue.equals((String)value)) {
                options.put("org.eclipse.jdt.core.codeComplete.visibilityCheck", newValue);
                JavaCore.setOptions((Hashtable)options);
            }
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int pos) {
        IJavaCompletionProposal[] result = new IJavaCompletionProposal[]{};
        IDocument jspDocument = viewer.getDocument();
        String jspText = jspDocument.get();
        StringBuffer jspTextBuffer = new StringBuffer(jspText);
        jspTextBuffer.insert(pos, "<%*>");
        String javaText = this.convertJspToJava(jspTextBuffer.toString());
        int firstPos = javaText.indexOf("<%*>");
        int lastPos = javaText.lastIndexOf("<%*>");
        if (firstPos == -1) {
            JspEditor.getTracer().error(" computeCompletionProposals(ITextViewer viewer, int pos)", "Marker not found in converted java source !!?!");
        } else if (firstPos != lastPos) {
            JspEditor.getTracer().error(" computeCompletionProposals(ITextViewer viewer, int pos)", "Duplicate markers found in converted java source !?!");
        } else {
            int javaPos = firstPos;
            StringBuffer javaTextBuf = new StringBuffer(javaText);
            javaTextBuf.delete(firstPos, firstPos + "<%*>".length());
            ICompilationUnit javaCU = this.createCompilationUnit(javaTextBuf.toString());
            this.getCollector().reset(javaPos, this.getJavaProject(), null);
            this.getCompletionEngine().complete(javaCU, javaPos, 0);
            JavaCompletionProposal[] javaCompletions = this.getCollector().getResults();
            int delta = pos - javaPos;
            int jc = 0;
            while (jc < javaCompletions.length) {
                JavaCompletionProposal jCompletionProposal = javaCompletions[jc];
                int offset = jCompletionProposal.getReplacementOffset();
                jCompletionProposal.setReplacementOffset(offset += delta);
                ++jc;
            }
            this.getTemplateEngine().reset();
            try {
                this.getTemplateEngine().complete(viewer, pos, null);
            }
            catch (JavaModelException ex) {
                JspEditor.getTracer().error(" computeCompletionProposals(ITextViewer viewer, int pos)", ex.getMessage(), (Throwable)ex);
            }
            TemplateProposal[] templateCompletions = this.getTemplateEngine().getResults();
            result = new IJavaCompletionProposal[javaCompletions.length + templateCompletions.length];
            System.arraycopy(templateCompletions, 0, result, 0, templateCompletions.length);
            System.arraycopy(javaCompletions, 0, result, templateCompletions.length, javaCompletions.length);
            Arrays.sort(result, this.getComparator());
        }
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public String getErrorMessage() {
        return "Any error message !";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.getValidator();
    }

    private String convertJspToJava(String jspText) {
        String javaText = "";
        ITagParserController parserController = this.getJspEditor().getParserController();
        if (parserController instanceof IJspParserController) {
            IJspParserController jspParserController = (IJspParserController)parserController;
            LineNumberReader inputReader = new LineNumberReader(new StringReader(jspText));
            jspParserController.initializeController(inputReader);
            Utility.parseFromBasicToFinish(jspParserController);
            try {
                inputReader.close();
            }
            catch (IOException ex) {
                JspEditor.getTracer().error("IOexception in convertJspToJava(String jspText) ??", ex.getMessage(), (Throwable)ex);
            }
            javaText = jspParserController.finalizeAsJavaSource();
        }
        return javaText;
    }

    private ICompilationUnit createCompilationUnit(final String contents) {
        return new ICompilationUnit(){
            private char[] fContents;
            private char[] fMainTypeName;
            private char[] fFileName;
            private char[][] fPackageName;

            public char[] getContents() {
                if (this.fContents == null) {
                    this.fContents = new char[contents.length()];
                    contents.getChars(0, contents.length(), this.fContents, 0);
                }
                return this.fContents;
            }

            public char[][] getPackageName() {
                if (this.fPackageName == null) {
                    // empty if block
                }
                return null;
            }

            public char[] getFileName() {
                if (this.fFileName == null) {
                    String fileName = "_JSPServlet.java";
                    this.fFileName = new char[fileName.length()];
                    fileName.getChars(0, fileName.length(), this.fFileName, 0);
                }
                return this.fFileName;
            }

            public char[] getMainTypeName() {
                if (this.fMainTypeName == null) {
                    String className = "_JSPServlet";
                    this.fMainTypeName = new char[className.length()];
                    className.getChars(0, className.length(), this.fMainTypeName, 0);
                }
                return this.fMainTypeName;
            }
        };
    }

    protected JspEditor getJspEditor() {
        return this.jspEditor;
    }

    protected IContextInformationValidator getValidator() {
        if (this.validator == null) {
            this.validator = new JavaParameterListValidator();
        }
        return this.validator;
    }

    protected TemplateEngine getTemplateEngine() {
        ContextType contextType;
        if (this.templateEngine == null && (contextType = ContextTypeRegistry.getInstance().getContextType("java")) != null) {
            this.templateEngine = new TemplateEngine(contextType);
        }
        return this.templateEngine;
    }

    protected JavaCompletionProposalComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new JavaCompletionProposalComparator();
            this.comparator.setOrderAlphabetically(false);
        }
        return this.comparator;
    }

    protected CompletionEngine getCompletionEngine() {
        if (this.completionEngine == null) {
            try {
                Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.jdt.ui").getPlugin();
                Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.jdt.core").getPlugin();
                IJavaProject javaProject = this.getJavaProject();
                NameLookup nameLookup = ((JavaProject)this.getJavaProject()).getNameLookup();
                ISearchableNameEnvironment environment = ((JavaProject)javaProject).getSearchableNameEnvironment();
                this.completionEngine = new CompletionEngine(environment, (ICompletionRequestor)new CompletionRequestorWrapper((ICompletionRequestor)this.getCollector(), nameLookup), (Map)JavaCore.getOptions(), javaProject);
            }
            catch (JavaModelException ex) {
                JspEditor.getTracer().error("getCompletionEngine()", ex.getMessage(), (Throwable)ex);
            }
            catch (CoreException ex) {
                JspEditor.getTracer().error("getCompletionEngine()", ex.getMessage(), (Throwable)ex);
            }
        }
        return this.completionEngine;
    }

    protected IJavaProject getJavaProject() {
        if (this.javaProject == null) {
            IProject eclipseProject = this.getJspEditor().getFile().getProject();
            JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
            JavaModel javaModel = javaModelManager.getJavaModel();
            this.javaProject = javaModel.getJavaProject(eclipseProject.getName());
        }
        return this.javaProject;
    }

    protected JspResultCollector getCollector() {
        if (this.collector == null) {
            this.collector = new JspResultCollector();
        }
        return this.collector;
    }
}

