/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.insight;

import com.tssap.tools.insight.interfaces.EditorProxyI;
import org.eclipse.jface.text.ITextViewer;

public class ViewerDocumentWrapper
implements EditorProxyI {
    ITextViewer viewer;

    public ViewerDocumentWrapper(ITextViewer viewer) {
        this.viewer = viewer;
    }

    public void deleteNextChar() {
        System.out.println("Warning, method is not available!");
    }

    public void deleteNextString(int length) {
        if (length == 0) {
            return;
        }
        int caretPos = this.getCaretPosition();
        String text = this.viewer.getDocument().get();
        String firstPart = text.substring(0, this.getCaretPosition());
        String endPart = text.substring(this.getCaretPosition() + length, text.length());
        this.viewer.getDocument().set(firstPart + endPart);
        this.viewer.setSelectedRange(caretPos, 0);
    }

    public void deletePrevChar() {
        System.out.println("Warning, method is not available!");
    }

    public void deletePrevString(int length) {
        if (length == 0) {
            return;
        }
        int caretPos = this.getCaretPosition();
        String text = this.viewer.getDocument().get();
        String firstPart = text.substring(0, this.getCaretPosition() - length);
        String endPart = text.substring(this.getCaretPosition(), text.length());
        this.viewer.getDocument().set(firstPart + endPart);
        this.setCaretPosition(caretPos - length);
    }

    public int getCaretPosition() {
        return this.viewer.getSelectedRange().x;
    }

    public Object getEditorObject() {
        return this.viewer;
    }

    public int getFontHeight() {
        return -1;
    }

    public int getFontWidth() {
        return -1;
    }

    public int getLineCount() {
        return this.viewer.getDocument().getNumberOfLines();
    }

    public String getText() {
        return this.viewer.getDocument().get();
    }

    public String getTextLine(int lineNumber) {
        System.out.println("Warning, method is not available!");
        return null;
    }

    public void insertNecessaryCharSpace() {
        try {
            if (this.getCaretPosition() > 0 && !this.getText().substring(this.getCaretPosition() - 1, this.getCaretPosition()).equals(" ")) {
                if (!this.getText().substring(this.getCaretPosition(), this.getCaretPosition() + 1).equals(" ")) {
                    this.insertString(" ", this.getCaretPosition());
                } else {
                    this.setCaretPosition(this.getCaretPosition() + 1);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void insertString(String stringToInsert, int insertionPosition) {
        String text = this.viewer.getDocument().get();
        String firstPart = text.substring(0, insertionPosition);
        String endPart = text.substring(insertionPosition, text.length());
        firstPart = firstPart + stringToInsert;
        this.viewer.getDocument().set(firstPart + endPart);
        this.viewer.setSelectedRange(insertionPosition + stringToInsert.length(), 0);
    }

    public void setCaretPosition(int newCaretPosition) {
        this.viewer.setSelectedRange(newCaretPosition, 0);
    }
}

