/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.editors.insight;

import com.tssap.editors.insight.IsContentAssistant;
import com.tssap.tools.insight.interfaces.SearchContextI;
import com.tssap.tools.insight.xml.schema.SchemaStartString;
import com.tssap.tools.insight.xml.schema.ValueSelectedEvent;
import com.tssap.tools.insight.xml.schema.interfaceimpl.XmlContext;
import com.tssap.util.insight.interfaces.SearchTargetI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class IsCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private int fContextInformationPosition;
    private IsContentAssistant fContAss;
    private ITextViewer fviewer;
    private Image fImage;
    private char[] fTriggerCharacters;
    private String fAdditionalProposalInfo;
    private SearchTargetI fTarget;
    private SearchContextI fContext;
    private SchemaStartString initialStartString;

    public IsCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fImage = image;
        this.fDisplayString = displayString != null ? displayString : replacementString;
        this.fCursorPosition = replacementString.length();
        this.fTriggerCharacters = null;
    }

    public IsCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, String additionalProposalInfo, IsContentAssistant contAss, ITextViewer viewer) {
        this(replacementString, replacementOffset, replacementLength, image, displayString);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = cursorPosition;
        this.fDisplayString = displayString;
        this.fContAss = contAss;
        this.fviewer = viewer;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fTarget = contAss.getSearchTarget();
        this.fContext = contAss.getSearchContext();
        this.initialStartString = ((XmlContext)this.fContext).getStateObject().getStartString();
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.fContAss.getManipulator().valueSelected(new ValueSelectedEvent((Object)this, this.fReplacementString, this.fContext, this.fTarget));
        this.fContAss.uninstall();
        this.fContAss.install(this.fviewer);
        this.fContAss.showPossibleCompletions();
    }

    private void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (!document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', this.fReplacementOffset + this.fReplacementLength);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fviewer.getSelectedRange().x, 0);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Image getImage() {
        return this.fImage;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = replacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = replacementLength;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public boolean isValidFor(IDocument document, int offset) {
        int replacementLength;
        if (offset < this.fReplacementOffset) {
            return false;
        }
        int n = replacementLength = this.fReplacementString == null ? 0 : this.fReplacementString.length();
        if (offset >= this.fReplacementOffset + replacementLength) {
            return false;
        }
        try {
            String start = this.initialStartString.toString() + document.get(this.fReplacementOffset, offset - this.fReplacementOffset);
            boolean isValid = this.fReplacementString.startsWith(start);
            if (!isValid && this.fContAss.getSearchTarget().getTarget().equals("tag") && this.fReplacementString.length() > 0 && this.fReplacementString.substring(1).startsWith(start)) {
                start = "<" + start;
                document.replace(this.fReplacementOffset, 1, start);
                isValid = true;
            }
            ((XmlContext)this.fContext).getStateObject().setStartString(new SchemaStartString(start));
            return isValid;
        }
        catch (BadLocationException x) {
            return false;
        }
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fContextInformationPosition;
    }
}

