/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.tcs.anttask;

import com.sap.cms.tcs.anttask.Component;
import com.sap.cms.tcs.anttask.FileSpec;
import com.sap.cms.tcs.anttask.MFEntry;
import com.sap.sdm.util.init.UtilInitializer;
import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.JarSL;
import com.sap.sdm.util.sduread.DevelopmentComponentVersion;
import com.sap.sdm.util.sduread.IllFormattedSduFileException;
import com.sap.sdm.util.sduread.SdaFile;
import com.sap.sdm.util.sduread.SduFile;
import com.sap.sdm.util.sduread.SduReader;
import com.sap.sl.util.components.api.ComponentElementIF;
import com.sap.sl.util.components.api.ComponentFactoryIF;
import com.sap.sl.util.components.xml.api.ComponentElementXMLizerFactoryIF;
import com.sap.sl.util.components.xml.api.ComponentElementXMLizerIF;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public final class TcsPra
extends MatchingTask
implements ConstantsIF {
    public static String DEF_tcspraversion = "20041214.1400";
    static final String EXTENDFILENAME = "extendfilename";
    static final String APPROVALSTATUS = "approvalstatus";
    private static String ATTTCSPRAVERSION = "TCSpra-Version";
    private static String TMP_PR_CMSKEYCOUNTER = "pr_cmskeycounter";
    private static String TMP_PR_PATCHLEVEL = "pr_patchlevel";
    private static String TMP_PR_APPROVALSTATUS = "pr_approvalstatus";
    private Vector buildarchivefilesets = new Vector();
    private Vector buildarchivefilelist = new Vector();
    private Vector deployarchivefilesets = new Vector();
    private Vector deployarchivefilelist = new Vector();
    private Component component = null;
    private Vector submfentries = new Vector();
    private File prafile = null;
    private File basedir = null;
    private boolean compress = true;
    private boolean extendfilename = false;
    private String servicelevel = null;
    private String patchlevel = null;
    private String release = null;
    private String updateversion = null;
    private String type = "SC";
    private String deltaversion = "F";
    private String owner = "Make";
    private String approvalstatus = null;

    private void addFilesToList(Vector vec, Vector filelist) {
        Object[] scanners = new FileScanner[vec.size()];
        vec.copyInto(scanners);
        int i = 0;
        while (i < scanners.length) {
            File actbasedir = scanners[i].getBasedir();
            String[] files = scanners[i].getIncludedFiles();
            int j = 0;
            while (j < files.length) {
                String name = files[j].replace(File.separatorChar, '/');
                if (!name.endsWith("/")) {
                    filelist.addElement(new FileSpec(actbasedir.getPath(), name));
                }
                ++j;
            }
            ++i;
        }
    }

    private String addFilesToArchive(Vector files, String directory, JarSL jarsl, boolean senderror) throws BuildException {
        SduFile sdufile = null;
        String content = "";
        if (files == null) {
            return content;
        }
        int i = 0;
        while (i < files.size()) {
            String archivefilename;
            Vector errorTexts = new Vector();
            FileSpec fileentry = (FileSpec)files.elementAt(i);
            String sourcefilename = fileentry.base() + "/" + fileentry.fname();
            if (this.extendfilename) {
                archivefilename = fileentry.fname().replace('/', '~').replace('\\', '~');
                if (archivefilename.startsWith("~")) {
                    archivefilename = archivefilename.substring(1);
                }
            } else {
                archivefilename = new File(sourcefilename).getName();
            }
            if (!jarsl.addFile("", sourcefilename, directory + "/" + archivefilename, errorTexts)) {
                if (senderror) {
                    StringBuffer tmpB = new StringBuffer();
                    if (null != errorTexts) {
                        Iterator errIter = ((AbstractList)errorTexts).iterator();
                        while (errIter.hasNext()) {
                            tmpB.append((String)errIter.next());
                        }
                    }
                    throw new BuildException("error in adding file " + sourcefilename + " to archive (" + tmpB.toString() + ")");
                }
            } else {
                content = content + (i > 0 ? ";" : "") + directory + "/" + archivefilename;
                if (directory.equals("DEPLOYARCHIVES")) {
                    try {
                        sdufile = SduReader.getInstance().readFile(sourcefilename);
                    }
                    catch (IllFormattedSduFileException e) {
                        throw new BuildException("Cannot add the SDA " + sourcefilename + " to the manifest (IllFormatedSduFileException): " + e.getMessage());
                    }
                    catch (IOException e) {
                        throw new BuildException("Cannot add the SDA " + sourcefilename + " to the manifest (IOException): " + e.getMessage());
                    }
                    if (!(sdufile instanceof SdaFile)) {
                        throw new BuildException("The file " + sourcefilename + " is not a SDA.");
                    }
                    SdaFile sdafile = (SdaFile)sdufile;
                    DevelopmentComponentVersion dcv = sdafile.getDevelopmentComponentVersion();
                    this.submfentries.add(new MFEntry(directory + "/" + archivefilename + "/", "keyname", dcv.getName()));
                    this.submfentries.add(new MFEntry(directory + "/" + archivefilename + "/", "keyvendor", dcv.getVendor()));
                    this.submfentries.add(new MFEntry(directory + "/" + archivefilename + "/", "keylocation", dcv.getLocation()));
                    this.submfentries.add(new MFEntry(directory + "/" + archivefilename + "/", "keycounter", dcv.getCount().toString()));
                }
            }
            ++i;
        }
        return content;
    }

    boolean preevaluation() {
        if (this.component != null) {
            if (this.component.getCounter() != null && this.component.getCounter().equals("AUTO")) {
                this.component.setCounter(null);
            }
            if (this.component.getVendor() == null) {
                this.component.setVendor(((ProjectComponent)this).project.getProperty("keyvendor"));
            }
            if (this.component.getVendor() == null) {
                this.component.setVendor(((ProjectComponent)this).project.getProperty("vendor"));
            }
            if (this.component.getCounter() == null) {
                this.component.setCounter(((ProjectComponent)this).project.getProperty("keycounter"));
            }
            if (this.component.getCounter() == null) {
                this.component.setCounter(((ProjectComponent)this).project.getProperty("counter"));
            }
            if (this.component.getLocation() == null) {
                this.component.setLocation(((ProjectComponent)this).project.getProperty("keylocation"));
            }
            if (this.component.getLocation() == null) {
                this.component.setLocation(((ProjectComponent)this).project.getProperty("location"));
            }
            if (this.component.getCounter() != null && this.component.getCounter().equals("AUTO")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                Date currTime = new Date();
                this.component.setCounter(df.format(currTime));
            }
            if (this.component.getScname() == null) {
                this.component.setScname(this.component.getName());
            }
            if (this.component.getScvendor() == null) {
                this.component.setScvendor(this.component.getVendor());
            }
        }
        if (((ProjectComponent)this).project.getProperty(EXTENDFILENAME) != null && ((ProjectComponent)this).project.getProperty(EXTENDFILENAME).equalsIgnoreCase("true")) {
            this.extendfilename = true;
        }
        this.servicelevel = ((ProjectComponent)this).project.getProperty("SP-Number");
        if (this.servicelevel != null && this.servicelevel.length() > 1 && this.servicelevel.startsWith("0")) {
            this.servicelevel = this.servicelevel.substring(1);
        }
        this.patchlevel = ((ProjectComponent)this).project.getProperty("SP-Patchlevel");
        this.release = ((ProjectComponent)this).project.getProperty("dcrelease");
        this.approvalstatus = ((ProjectComponent)this).project.getProperty(APPROVALSTATUS);
        this.updateversion = this.component != null && this.component.getCounter() != null ? "NIGHTBUILD." + this.component.getCounter() : "NIGHTBUILD";
        if (this.updateversion.length() > 20) {
            this.updateversion = this.updateversion.substring(0, 19);
        }
        return true;
    }

    private boolean consistencyCheck() {
        boolean failed = false;
        if (this.prafile == null) {
            failed = true;
            this.log("Error consistencyCheck: missing prafile name for tcspra element");
        }
        if (this.component != null && (this.component.getScname() == null || this.component.getScvendor() == null || this.component.getName() == null || this.component.getVendor() == null || this.component.getLocation() == null || this.component.getCounter() == null)) {
            failed = true;
            if (this.component.getName() == null) {
                this.log("Error consistencyCheck: missing name for component element");
            }
            if (this.component.getVendor() == null) {
                this.log("Error consistencyCheck: Property vendor not supplied in ant call");
            }
            if (this.component.getLocation() == null) {
                this.log("Error consistencyCheck: Property location not supplied in ant call");
            }
            if (this.component.getCounter() == null) {
                this.log("Error consistencyCheck: Property counter not supplied in ant call");
            }
            if (this.component.getScname() == null) {
                this.log("Error consistencyCheck: missing scname for component element");
            }
            if (this.component.getScvendor() == null) {
                this.log("Error consistencyCheck: missing scvendor for component element");
            }
        } else if (this.component != null && (this.component.getScname().equals("") || this.component.getScvendor().equals("") || this.component.getName().equals("") || this.component.getVendor().equals("") || this.component.getLocation().equals("") || this.component.getCounter().equals(""))) {
            failed = true;
            if (this.component.getName().equals("")) {
                this.log("Error consistencyCheck: empty name in component element");
            }
            if (this.component.getVendor().equals("")) {
                this.log("Error consistencyCheck: empty vendor");
            }
            if (this.component.getLocation().equals("")) {
                this.log("Error consistencyCheck: empty location");
            }
            if (this.component.getCounter().equals("")) {
                this.log("Error consistencyCheck: empty counter");
            }
            if (this.component.getScname().equals("")) {
                this.log("Error consistencyCheck: empty scname in component element");
            }
            if (this.component.getScvendor().equals("")) {
                this.log("Error consistencyCheck: empty scvendor in component element");
            }
        } else if (this.component != null && (this.component.getScname().length() > 40 || this.component.getScvendor().length() > 20 || this.component.getName().length() > 40 || this.component.getVendor().length() > 20 || this.component.getLocation().length() > 20 || this.component.getCounter().length() > 20)) {
            failed = true;
            if (this.component.getName().length() > 40) {
                this.log("Error consistencyCheck: name is longer than 40 characters in component element");
            }
            if (this.component.getVendor().length() > 20) {
                this.log("Error consistencyCheck: vendor is longer than 20 characters");
            }
            if (this.component.getLocation().length() > 20) {
                this.log("Error consistencyCheck: location is longer than 20 characters");
            }
            if (this.component.getCounter().length() > 20) {
                this.log("Error consistencyCheck: counter is longer than 20 characters");
            }
            if (this.component.getScname().length() > 40) {
                this.log("Error consistencyCheck: scname is longer than 40 characters in component element");
            }
            if (this.component.getScvendor().length() > 20) {
                this.log("Error consistencyCheck: scvendor is longer than 20 characters in component element");
            }
        } else if (this.component != null) {
            if (this.component.getCounter().length() != 14) {
                failed = true;
                this.log("Error consistencyCheck: counter must be of length 14");
            } else {
                try {
                    new Long(this.component.getCounter());
                }
                catch (Throwable e) {
                    failed = true;
                    this.log("Error consistencyCheck: counter is not an integer value");
                }
            }
        }
        int i = 0;
        while (i < this.submfentries.size()) {
            MFEntry mfe = (MFEntry)this.submfentries.elementAt(i);
            if (mfe.getAttribute() == null || mfe.getValue() == null) {
                failed = true;
                if (mfe.getAttribute() == null) {
                    this.log("Error consistencyCheck: missing attribute for mfentry element");
                }
                if (mfe.getValue() == null) {
                    this.log("Error consistencyCheck: missing value for mfentry element");
                }
            }
            ++i;
        }
        if (this.release == null) {
            failed = true;
            this.log("Error consistencyCheck: Property dcrelease not supplied in ant call");
        }
        if (this.servicelevel == null) {
            failed = true;
            this.log("Error consistencyCheck: Property spnumber not supplied in ant call");
        }
        if (!(this.approvalstatus == null || this.approvalstatus.equals("APPROVED") || this.approvalstatus.equals("ASSEMBLED") || this.approvalstatus.equals("EXTERNAL"))) {
            failed = true;
            this.log("Error consistencyCheck: Property approvalstatus has wrong value, only EXTERNAL, ASSEMBLED, APPROVED are possible.");
        }
        return !failed;
    }

    private boolean makeMFEntries(JarSL jarsl) throws BuildException {
        boolean failed = false;
        failed |= !jarsl.writeAttribute("", ATTTCSPRAVERSION, DEF_tcspraversion);
        int i = 0;
        while (i < this.submfentries.size()) {
            MFEntry mfe = (MFEntry)this.submfentries.elementAt(i);
            failed = mfe.getEntry() == null ? (failed |= !jarsl.writeAttribute("", mfe.getAttribute(), mfe.getValue())) : (failed |= !jarsl.writeAttribute(mfe.getEntry(), mfe.getAttribute(), mfe.getValue()));
            ++i;
        }
        if (this.component != null) {
            String sdmcounter;
            String _patchlevel;
            failed |= !jarsl.writeAttribute("", "keyname", this.component.getName());
            failed |= !jarsl.writeAttribute("", "keyvendor", this.component.getVendor());
            failed |= !jarsl.writeAttribute("", "keylocation", this.component.getLocation());
            String _release = this.release;
            if (_release.indexOf(".") == -1) {
                _release = _release + ".0";
            }
            if ((_patchlevel = this.patchlevel) == null) {
                _patchlevel = "0";
            }
            failed |= !jarsl.writeAttribute("", "keycounter", sdmcounter = "1000." + _release + "." + this.servicelevel + "." + _patchlevel + "." + this.component.getCounter());
            failed |= !jarsl.writeAttribute("", TMP_PR_CMSKEYCOUNTER, this.component.getCounter());
            failed |= !jarsl.writeAttribute("", "pr_softwarecomponentname", this.component.getScname());
            failed |= !jarsl.writeAttribute("", "pr_softwarecomponentvendor", this.component.getScvendor());
            failed |= !jarsl.writeAttribute("", "pr_release", this.release);
            failed |= !jarsl.writeAttribute("", "pr_servicelevel", this.servicelevel);
            failed |= !jarsl.writeAttribute("", "pr_updateversion", this.updateversion);
            failed |= !jarsl.writeAttribute("", "pr_type", this.type);
            failed |= !jarsl.writeAttribute("", "pr_deltaversion", this.deltaversion);
            failed |= !jarsl.writeAttribute("", "pr_owner", this.owner);
            if (this.approvalstatus != null) {
                failed |= !jarsl.writeAttribute("", TMP_PR_APPROVALSTATUS, this.approvalstatus);
            }
            if (this.patchlevel != null) {
                failed |= !jarsl.writeAttribute("", TMP_PR_PATCHLEVEL, this.patchlevel);
            }
            ComponentElementIF componentelement = ComponentFactoryIF.getInstance().createComponentElement(this.component.getVendor(), this.component.getName(), this.type, "NO_SUBSYS", this.component.getLocation(), sdmcounter, this.component.getScvendor(), this.component.getScname(), this.release, this.servicelevel, this.patchlevel, this.deltaversion, this.updateversion, null, null, null, null, null, null, null, null, null);
            ComponentElementXMLizerIF cex = ComponentElementXMLizerFactoryIF.getInstance().createComponentXMLizerElement(componentelement);
            jarsl.writeAttribute("", "componentelement", cex.getXML());
        } else {
            this.log("Warning: No component is specified in build.xml.");
        }
        return !failed;
    }

    public static void main(String[] arg) {
        System.out.println("This is TcsPra version " + DEF_tcspraversion);
    }

    public void addBuildArchivesFileset(FileSet set) {
        this.buildarchivefilesets.addElement(set);
    }

    public void addDeployArchivesFileset(FileSet set) {
        this.deployarchivefilesets.addElement(set);
    }

    public MFEntry createMfentry() {
        MFEntry mfentry = new MFEntry();
        this.submfentries.addElement(mfentry);
        return mfentry;
    }

    public void setPrafile(String prafile) {
        this.prafile = ((ProjectComponent)this).project.resolveFile(prafile);
    }

    public void setBasedir(String basedir) {
        this.basedir = ((ProjectComponent)this).project.resolveFile(basedir);
    }

    public Component createComponent() {
        this.component = new Component();
        return this.component;
    }

    void setCompress(String compress) {
        this.compress = compress.trim().toLowerCase().equals("true") || compress.trim().toLowerCase().equals("yes");
    }

    public void setManifest(String manifest) {
    }

    public void execute() throws BuildException {
        Vector errorTexts;
        this.log("Info: TCSpra version " + DEF_tcspraversion);
        Vector<DirectoryScanner> vec = new Vector<DirectoryScanner>();
        int i = 0;
        while (i < this.buildarchivefilesets.size()) {
            vec.addElement(((FileSet)this.buildarchivefilesets.elementAt(i)).getDirectoryScanner(((ProjectComponent)this).project));
            ++i;
        }
        this.addFilesToList(vec, this.buildarchivefilelist);
        vec = new Vector();
        int i2 = 0;
        while (i2 < this.deployarchivefilesets.size()) {
            vec.addElement(((FileSet)this.deployarchivefilesets.elementAt(i2)).getDirectoryScanner(((ProjectComponent)this).project));
            ++i2;
        }
        this.addFilesToList(vec, this.deployarchivefilelist);
        try {
            UtilInitializer.initialize();
        }
        catch (Exception e) {
            throw new BuildException("could not read all necessary SDM property files!");
        }
        this.preevaluation();
        if (!this.consistencyCheck()) {
            throw new BuildException("wrong attribute combination!");
        }
        if (this.deployarchivefilelist == null && this.buildarchivefilelist == null) {
            throw new BuildException("at least one fileset must be given!");
        }
        JarSL jarsl = this.basedir == null ? new JarSL(this.prafile.getPath(), "") : new JarSL(this.prafile.getPath(), this.basedir.getPath());
        this.log("Building: " + this.prafile.getPath() + (this.compress ? " with compression" : " without compression"));
        String buildarchivecontent = this.addFilesToArchive(this.buildarchivefilelist, "BUILDARCHIVES", jarsl, true);
        String deployarchivecontent = this.addFilesToArchive(this.deployarchivefilelist, "DEPLOYARCHIVES", jarsl, true);
        if ((buildarchivecontent == null || buildarchivecontent.equals("")) && (deployarchivecontent == null || deployarchivecontent.equals(""))) {
            this.log("Warning: creating empty JAR file");
        } else {
            this.submfentries.add(new MFEntry("", "pr_buildarchivedir", buildarchivecontent));
            this.submfentries.add(new MFEntry("", "pr_deployarchivedir", deployarchivecontent));
        }
        if (!this.makeMFEntries(jarsl)) {
            throw new BuildException("error in creating the manifest");
        }
        if (!jarsl.create(this.compress, false, this.component != null, errorTexts = new Vector())) {
            StringBuffer tmpB = new StringBuffer();
            if (null != errorTexts) {
                Iterator errIter = ((AbstractList)errorTexts).iterator();
                while (errIter.hasNext()) {
                    tmpB.append((String)errIter.next());
                }
            }
            throw new BuildException("error in creating the archive (" + tmpB.toString() + ")");
        }
    }
}

