/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.validation;

import com.sap.s2x.validation.ASCII7Validator;
import com.sap.s2x.validation.Constraint;
import com.sap.s2x.validation.SchemaParser;
import com.sap.s2x.validation.ValidationException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SchemaValidator {
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.s2x.validation.SchemaValidatorRes");
    private static SchemaValidator instance = null;
    private ASCII7Validator ascii;
    private Map constraints;
    StringBuffer errorMessage;
    String invalidChars = new String();

    private SchemaValidator() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        SchemaParser parser = new SchemaParser();
        this.constraints = parser.getConstraints();
        this.ascii = new ASCII7Validator();
    }

    public static synchronized SchemaValidator getInstance() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (instance == null) {
            instance = new SchemaValidator();
        }
        return instance;
    }

    public String checkValidity(String constraintName, String data) {
        List allowedValues;
        Object[] obj;
        MessageFormat mf;
        this.errorMessage = new StringBuffer();
        Object o = this.constraints.get(constraintName);
        if (o == null) {
            return res.getString("ymsg_NoConstraints");
        }
        Constraint constraint = (Constraint)o;
        if (!this.correctDataType(data, constraint.getDataType())) {
            mf = new MessageFormat(res.getString("ymsg_Convert"));
            obj = new Object[]{data, constraint.getDataType()};
            this.errorMessage.append(mf.format(obj));
            if (constraint.getDataType().equals("usAsciiType")) {
                mf = new MessageFormat(res.getString("ymsg_IllegalChars"));
                obj = new Object[]{this.invalidChars};
                this.errorMessage.append(" " + mf.format(obj));
            }
            this.errorMessage.append("\n");
        }
        if (constraint.hasAllowedValues() && !(allowedValues = constraint.getAllowedValues()).contains(data)) {
            obj = new Object[]{data};
            mf = new MessageFormat(res.getString("ymsg_ValueNotAllowed"));
            this.errorMessage.append(mf.format(obj)).append("\n");
        }
        try {
            int length = data.length();
            if (constraint.hasMinLength() && length < constraint.getMinLength()) {
                mf = new MessageFormat(res.getString("ymsg_ValShorterTMin"));
                obj = new Object[]{data, new Integer(data.length()), new Integer(constraint.getMinLength())};
                this.errorMessage.append(mf.format(obj)).append("\n");
            }
            if (constraint.hasMaxLength() && length > constraint.getMaxLength()) {
                mf = new MessageFormat(res.getString("ymsg_ValLongerTMax"));
                obj = new Object[]{data, new Integer(data.length()), new Integer(constraint.getMaxLength())};
                this.errorMessage.append(mf.format(obj)).append("\n");
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            double doubleValue = new Double(data);
            if (constraint.hasMinExclusive() && doubleValue <= constraint.getMinExclusive()) {
                mf = new MessageFormat(res.getString("ymsg_ValLtMinVal1"));
                obj = new Object[]{data, new Double(constraint.getMinExclusive())};
                this.errorMessage.append(mf.format(obj)).append("\n");
            }
            if (constraint.hasMinInclusive() && doubleValue < constraint.getMinInclusive()) {
                mf = new MessageFormat(res.getString("ymsg_ValLtMinVal2"));
                obj = new Object[]{data, new Double(constraint.getMinInclusive())};
                this.errorMessage.append(mf.format(obj)).append("\n");
            }
            if (constraint.hasMaxExclusive() && doubleValue >= constraint.getMaxExclusive()) {
                mf = new MessageFormat(res.getString("ymsg_ValGtMaxVal1"));
                obj = new Object[]{data, new Double(constraint.getMaxExclusive())};
                this.errorMessage.append(mf.format(obj)).append("\n");
            }
            if (constraint.hasMaxInclusive() && doubleValue > constraint.getMaxInclusive()) {
                mf = new MessageFormat(res.getString("ymsg_ValGtMaxVal2"));
                obj = new Object[]{data, new Double(constraint.getMaxInclusive())};
                this.errorMessage.append(mf.format(obj)).append("\n");
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (constraint.hasPattern()) {
            boolean match = true;
            if (constraint.getIdentifier().equals("develContact")) {
                int pos1 = data.indexOf("@");
                if (pos1 < 0 || pos1 == 0 || pos1 == data.length() - 1) {
                    match = false;
                } else {
                    int pos2 = data.indexOf(".", pos1);
                    if (pos2 < 0 || pos2 == pos1 + 1 || pos2 == data.length() - 1) {
                        match = false;
                    } else if (data.lastIndexOf(".") == data.length() - 1) {
                        match = false;
                    }
                }
                if (!match) {
                    mf = new MessageFormat(res.getString("ymsg_Email"));
                    obj = new Object[]{data};
                    this.errorMessage.append(mf.format(obj)).append("\n");
                }
            }
        }
        return this.errorMessage.toString();
    }

    private boolean correctDataType(String data, String dataType) {
        if (dataType.equals("String") || dataType.equals("java.lang.String")) {
            return true;
        }
        if (dataType.equals("int") || dataType.equals("java.lang.Integer")) {
            try {
                Integer test = new Integer(data);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (dataType.equals("positiveInteger")) {
            try {
                Integer test = new Integer(data);
                return test >= 1;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (dataType.equals("nonNegativeInteger")) {
            try {
                Integer test = new Integer(data);
                return test >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (dataType.equals("long") || dataType.equals("java.lang.Long")) {
            try {
                Long test = new Long(data);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (dataType.equals("float") || dataType.equals("java.lang.Float")) {
            try {
                Float test = new Float(data);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (dataType.equals("double") || dataType.equals("java.lang.Double")) {
            try {
                Double test = new Double(data);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (dataType.equals("java.lang.Boolean")) {
            return data.equalsIgnoreCase("true") || data.equalsIgnoreCase("false") || data.equalsIgnoreCase("yes") || data.equalsIgnoreCase("no");
        }
        if (dataType.equals("usAsciiType")) {
            this.invalidChars = ASCII7Validator.isValidC(data);
            return this.invalidChars.equals("");
        }
        return true;
    }
}

