/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.BOKeyFields;
import com.sap.mdi.Field;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.MetaDataAccessNotBasedOnDictionaryException;
import com.sap.mdi.Structure;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDObject;

public final class BOKeyField {
    int index;
    BOKeyFields parent;
    String name;
    String description;
    String referenceTable;
    String referenceField;
    String dataTypeABAP;
    int internalLength;
    int outputLength;
    boolean supportsMixedCase;
    String conversionExit;
    String[] documentation;

    BOKeyField(String name, String description, String referenceTable, String referenceField, String dataTypeABAP, int internalLength, int outputLength, boolean supportsMixedCase, String conversionExit) {
        this.name = name;
        this.description = description;
        this.referenceTable = referenceTable;
        this.referenceField = referenceField;
        this.dataTypeABAP = dataTypeABAP;
        this.internalLength = internalLength;
        this.outputLength = outputLength;
        this.supportsMixedCase = supportsMixedCase;
        this.conversionExit = conversionExit;
    }

    String getConversionExit() {
        return this.conversionExit;
    }

    String getDataTypeABAP() {
        return this.dataTypeABAP;
    }

    String getDataTypeDD() throws MetaDataAccessException {
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField).getDataTypeDD();
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getDocumentation() throws MetaDataAccessException {
        if (!this.parent.parent.documentationInitialized) {
            this.parent.parent.initDocumentation();
        }
        return this.documentation;
    }

    Field getField() throws MetaDataAccessException {
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField);
    }

    public String getFieldName() {
        return this.referenceField;
    }

    public int getIndex() {
        return this.index;
    }

    int getInternalLength() {
        return this.internalLength;
    }

    int getLength() throws MetaDataAccessException {
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField).getLength();
    }

    public String getName() {
        return this.name;
    }

    int getOutputLength() {
        return this.outputLength;
    }

    Structure getStructure() throws MetaDataAccessException {
        return this.parent.parent.parent.bof.getStructure(this.referenceTable);
    }

    public String getStructureName() {
        return this.referenceTable;
    }

    boolean isConsistent() {
        try {
            Field f = this.getField();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isMixedCaseSupported() {
        return this.supportsMixedCase;
    }

    public DDObject getDDObject() {
        DDFactory df = this.parent.parent.parent.bof.getDDFactory();
        if (this.referenceField == null || this.referenceField.trim().equalsIgnoreCase("")) {
            return df.getDDObjectWithSubtree(this.referenceTable);
        }
        return df.getDDObjectWithSubtree(this.referenceTable, this.referenceField);
    }

    public DDObject getDDField() {
        DDFactory df = this.parent.parent.parent.bof.getDDFactory();
        if (this.referenceField == null || this.referenceField.trim().equalsIgnoreCase("")) {
            return null;
        }
        return df.getDDObjectWithSubtree(this.referenceTable, this.referenceField);
    }
}

