/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.services.metamodel.webdynpro.view;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Action;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.UIElementContextBinding;
import com.sap.ide.metamodel.webdynpro.component.view.UIElementEventBinding;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElement;
import com.sap.ide.services.metamodel.webdynpro.ChangeStatus;
import com.sap.ide.services.metamodel.webdynpro.ChangeStatusEnum;
import com.sap.ide.services.metamodel.webdynpro.IChangeStatus;
import com.sap.ide.services.metamodel.webdynpro.Services;
import java.util.ArrayList;

public class ViewServices
extends Services {
    protected static ViewServices mViewServices = null;

    public static final ViewServices getInstance() {
        if (mViewServices == null) {
            mViewServices = new ViewServices();
        }
        return mViewServices;
    }

    public IChangeStatus checkDeleteEventBinding(Action action) {
        View view = this.getView(action);
        ChangeStatus status = new ChangeStatus();
        status.setIsOK(true);
        status.setObject((DevelopmentObject)view);
        status.setCode(ChangeStatusEnum.NOTHINGTODO);
        if (view != null && this.isActionUsed((ViewElement)view.getRootUIElementContainer(), action)) {
            status.setCode(ChangeStatusEnum.POSSIBLE);
        }
        return status;
    }

    public MainDevelopmentObject[] getAffectedMDOsForDeleteEventBinding(Action action) {
        View view = this.getView(action);
        if (view != null && this.isActionUsed((ViewElement)view.getRootUIElementContainer(), action)) {
            MainDevelopmentObject[] MDOs = new MainDevelopmentObject[]{view};
            return MDOs;
        }
        return null;
    }

    public void deleteEventBinding(Action action) {
        Services.beforeChange();
        View view = this.getView(action);
        UIElementContainer container = view.getRootUIElementContainer();
        ArrayList deleteObjects = new ArrayList();
        this.deleteEventBinding((ViewElement)container, action, deleteObjects);
        this.deleteArray(deleteObjects);
        Services.afterChange();
    }

    private View getView(Action action) {
        Controller controller = (Controller)action.getMDO();
        if (controller.hasView() && controller.getView() instanceof View) {
            return (View)controller.getView();
        }
        return null;
    }

    private boolean isActionUsed(ViewElement element, Action action) {
        UIElementEventBinding[] bindings = element.getEventBindings();
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i].getBoundAction() == action) {
                return true;
            }
            ++i;
        }
        MetamodelIterator it = element.iterator();
        it.next();
        DevelopmentObject object = null;
        while (it.hasNext()) {
            object = it.next();
            if (!(object instanceof ViewElement) || !this.isActionUsed((ViewElement)object, action)) continue;
            return true;
        }
        return false;
    }

    private void deleteEventBinding(ViewElement element, Action action, ArrayList deleteObjects) {
        UIElementEventBinding[] bindings = element.getEventBindings();
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i].getBoundAction() == action) {
                deleteObjects.add(bindings[i]);
            }
            ++i;
        }
        MetamodelIterator it = element.iterator();
        it.next();
        DevelopmentObject object = null;
        while (it.hasNext()) {
            object = it.next();
            if (!(object instanceof ViewElement)) continue;
            this.deleteEventBinding((ViewElement)object, action, deleteObjects);
        }
    }

    public IChangeStatus checkDeleteContextBinding(ContextElement element) {
        View view = this.getView(element);
        ChangeStatus status = new ChangeStatus();
        status.setIsOK(true);
        status.setObject((DevelopmentObject)view);
        status.setCode(ChangeStatusEnum.NOTHINGTODO);
        if (view != null && this.isElementUsed((ViewElement)view.getRootUIElementContainer(), element)) {
            status.setCode(ChangeStatusEnum.POSSIBLE);
        }
        return status;
    }

    public MainDevelopmentObject[] getAffectedMDOsForDeleteContextBinding(ContextElement contextelement) {
        View view = this.getView(contextelement);
        if (view != null && this.isElementUsed((ViewElement)view.getRootUIElementContainer(), contextelement)) {
            MainDevelopmentObject[] MDOs = new MainDevelopmentObject[]{view};
            return MDOs;
        }
        return null;
    }

    public void deleteContextBinding(ContextElement element) {
        Services.beforeChange();
        View view = this.getView(element);
        ArrayList deleteObjects = new ArrayList();
        if (element instanceof ContextNode) {
            this.deleteContextBinding(view, (ContextNode)element, deleteObjects);
        } else {
            this.deleteContextBinding((ViewElement)view.getRootUIElementContainer(), element, deleteObjects);
        }
        this.deleteArray(deleteObjects);
        Services.afterChange();
    }

    private View getView(ContextElement element) {
        Controller controller = (Controller)element.getMDO();
        if (controller.hasView() && controller.getView() instanceof View) {
            return (View)controller.getView();
        }
        return null;
    }

    private boolean isElementUsed(ViewElement element, ContextElement contextelement) {
        int i;
        if (contextelement instanceof ContextNode) {
            AbstractContextNode[] nodes = ((ContextNode)contextelement).getChildNodes();
            i = 0;
            while (i < nodes.length) {
                if (this.isElementUsed(element, (ContextElement)nodes[i])) {
                    return true;
                }
                ++i;
            }
            ContextAttribute[] attributes = ((ContextNode)contextelement).getAttributes();
            int i2 = 0;
            while (i2 < attributes.length) {
                if (this.isElementUsed(element, (ContextElement)attributes[i2])) {
                    return true;
                }
                ++i2;
            }
        }
        UIElementContextBinding[] bindings = element.getContextBindings();
        i = 0;
        while (i < bindings.length) {
            if (bindings[i].getBoundContextElement() == contextelement) {
                return true;
            }
            ++i;
        }
        MetamodelIterator it = element.iterator();
        it.next();
        DevelopmentObject object = null;
        while (it.hasNext()) {
            object = it.next();
            if (!(object instanceof ViewElement) || !this.isElementUsed((ViewElement)object, contextelement)) continue;
            return true;
        }
        return false;
    }

    private void deleteContextBinding(View view, ContextNode element, ArrayList deleteObjects) {
        ContextAttribute[] attributes = element.getAttributes();
        UIElementContainer container = view.getRootUIElementContainer();
        this.deleteContextBinding((ViewElement)container, (ContextElement)element, deleteObjects);
        int i = 0;
        while (i < attributes.length) {
            this.deleteContextBinding((ContextElement)attributes[i]);
            ++i;
        }
        AbstractContextNode[] nodes = element.getChildNodes();
        int i2 = 0;
        while (i2 < nodes.length) {
            this.deleteContextBinding((ContextElement)nodes[i2]);
            ++i2;
        }
    }

    private void deleteContextBinding(ViewElement element, ContextElement contextelement, ArrayList deleteObjects) {
        UIElementContextBinding[] bindings = element.getContextBindings();
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i].getBoundContextElement() == contextelement) {
                deleteObjects.add(bindings[i]);
            }
            ++i;
        }
        MetamodelIterator it = element.iterator();
        it.next();
        DevelopmentObject object = null;
        while (it.hasNext()) {
            object = it.next();
            if (!(object instanceof ViewElement)) continue;
            this.deleteContextBinding((ViewElement)object, contextelement, deleteObjects);
        }
    }

    private void deleteArray(ArrayList deleteObjects) {
        DevelopmentObject object = null;
        int i = 0;
        while (i < deleteObjects.size()) {
            object = (DevelopmentObject)deleteObjects.get(i);
            if (!object.isDeleted()) {
                try {
                    object.delete();
                }
                catch (DeleteException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }
}

