/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.services.metamodel.webdynpro.helper;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.general.metainfo.DeclarationTypeEnum;
import com.sap.ide.metamodel.general.metainfo.MetaClass;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.metamodel.webdynpro.framework.uielib.AbstractViewElementPropertyDef;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionMethodsProvider {
    public static Method getMethod(String name, Object object, Class[] classes) {
        Class<?> lJavaClass = object.getClass();
        Class<?>[] lInterfaces = lJavaClass.getInterfaces();
        Method lMethod = null;
        int k = 0;
        while (k < lInterfaces.length) {
            Method[] lMethods = lInterfaces[k].getMethods();
            int j = 0;
            while (j < lMethods.length) {
                if (lMethods[j].getName().equals(name)) {
                    boolean correct = false;
                    Class<?>[] lParameters = lMethods[j].getParameterTypes();
                    if (lParameters.length == classes.length) {
                        int i = 0;
                        while (i < classes.length && i < lParameters.length) {
                            if (!classes[i].equals(lParameters[i])) {
                                correct = false;
                                break;
                            }
                            correct = true;
                            ++i;
                        }
                        if (lParameters.length == 0) {
                            correct = true;
                        }
                    }
                    if (correct) {
                        lMethod = lMethods[j];
                    }
                }
                ++j;
            }
            ++k;
        }
        return lMethod;
    }

    public static boolean isNameAvailableForElement(String name, UIElementContainer container) {
        if (name.equalsIgnoreCase(container.getName())) {
            return false;
        }
        int i = 0;
        while (i < container.getChildren().length) {
            if (!ReflectionMethodsProvider.isNameAvailableForElement(name, (DevelopmentObject)container.getChild(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNameAvailableForElement(String name, DevelopmentObject element) {
        if (element.getName().equalsIgnoreCase(name)) {
            return false;
        }
        MetaClass lClass = element.getMetaClass();
        while (lClass != null) {
            Aggregation[] lAggregations = lClass.getAggregations();
            int i = 0;
            while (i < lAggregations.length) {
                Aggregation lAggregation = lAggregations[i];
                if (lAggregation.getDeclarationType() != DeclarationTypeEnum.ABSTRACT) {
                    Class<?> lJavaClass = element.getClass();
                    Class<?>[] lInterfaces = lJavaClass.getInterfaces();
                    int k = 0;
                    while (k < lInterfaces.length) {
                        Class[] lArray = new Class[]{};
                        Method lMethod = null;
                        try {
                            lMethod = lInterfaces[k].getMethod("get" + lAggregation.getName(), lArray);
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        Object ret = null;
                        if (lMethod != null) {
                            Object[] lArgs = new Object[]{};
                            DevelopmentObject[] lObjects = null;
                            DevelopmentObject lObject = null;
                            try {
                                ret = lMethod.invoke((Object)element, lArgs);
                            }
                            catch (InvocationTargetException ite) {
                                ite.printStackTrace();
                            }
                            catch (IllegalAccessException iae) {
                                iae.printStackTrace();
                            }
                            if (ret instanceof DevelopmentObject[]) {
                                lObjects = (DevelopmentObject[])ret;
                                int j = 0;
                                while (j < lObjects.length) {
                                    if (lObjects[j].getName().equals(name)) {
                                        return false;
                                    }
                                    if (!ReflectionMethodsProvider.isNameAvailableForElement(name, lObjects[j])) {
                                        return false;
                                    }
                                    ++j;
                                }
                            } else if (ret instanceof DevelopmentObject) {
                                lObject = (DevelopmentObject)ret;
                                if (lObject.getName().equalsIgnoreCase(name)) {
                                    return false;
                                }
                                if (!ReflectionMethodsProvider.isNameAvailableForElement(name, lObject)) {
                                    return false;
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            lClass = lClass.getSuperClass();
        }
        return true;
    }

    public static AbstractViewElementPropertyDef findProperty(DevelopmentObject object, ViewElementDefinition definition, String name) {
        ViewElementDefinition lDefinition = null;
        if (object != null && definition != null) {
            while (lDefinition != null) {
                AbstractViewElementPropertyDef[] lProperties = lDefinition.getProperties();
                int i = 0;
                while (i < lProperties.length) {
                    if (name.equals(lProperties[i].getName())) {
                        return lProperties[i];
                    }
                    ++i;
                }
                lDefinition = (ViewElementDefinition)lDefinition.getSuperClass();
            }
        }
        return null;
    }
}

