/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.common.types;

import com.sap.tc.cbs.common.types.CBSEnumType;

public class RequestType
extends CBSEnumType {
    public static final RequestType IMPORT = new RequestType(1);
    public static final RequestType DC_BUILD = new RequestType(2);
    public static final RequestType ACTIVATE = new RequestType(4);
    public static final RequestType INIT_COMPARTMENT = new RequestType(8);
    public static final RequestType FULL_MAKE = new RequestType(16);
    public static final RequestType INTERNAL_BUILD = new RequestType(32);

    private RequestType(short type) {
        super(type);
    }

    public static boolean isValid(short type) {
        return ACTIVATE.equals(type) || DC_BUILD.equals(type) || FULL_MAKE.equals(type) || IMPORT.equals(type) || INIT_COMPARTMENT.equals(type) || INTERNAL_BUILD.equals(type);
    }

    public static RequestType fromShort(short type) {
        if (RequestType.isValid(type)) {
            if (ACTIVATE.equals(type)) {
                return ACTIVATE;
            }
            if (IMPORT.equals(type)) {
                return IMPORT;
            }
            if (DC_BUILD.equals(type)) {
                return DC_BUILD;
            }
            if (INIT_COMPARTMENT.equals(type)) {
                return INIT_COMPARTMENT;
            }
            if (INTERNAL_BUILD.equals(type)) {
                return INTERNAL_BUILD;
            }
            return FULL_MAKE;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        if (ACTIVATE.equals(this.value)) {
            return "ACTIVATE";
        }
        if (IMPORT.equals(this.value)) {
            return "IMPORT";
        }
        if (DC_BUILD.equals(this.value)) {
            return "DC_BUILD";
        }
        if (INIT_COMPARTMENT.equals(this.value)) {
            return "INIT_COMPARTMENT";
        }
        if (INTERNAL_BUILD.equals(this.value)) {
            return "INTERNAL_BUILD";
        }
        return "FULL_MAKE";
    }
}

