/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.common.types;

import com.sap.tc.cbs.common.types.CBSEnumType;
import com.sap.tc.cbs.common.types.RequestStateCodes;

public class RequestState
extends CBSEnumType {
    private RequestStateCodes[] mAssociatedStateCodes;
    public static final RequestState NEW = new RequestState(0, new RequestStateCodes[]{RequestStateCodes.NEW});
    public static final RequestState PENDING = new RequestState(1, new RequestStateCodes[]{RequestStateCodes.PENDING});
    public static final RequestState SUSPENDED = new RequestState(2, new RequestStateCodes[]{RequestStateCodes.SUSPENDED});
    public static final RequestState WAITING = new RequestState(3, new RequestStateCodes[]{RequestStateCodes.WAITING});
    public static final RequestState ABORTED = new RequestState(4, new RequestStateCodes[]{RequestStateCodes.ABORTED});
    public static final RequestState QUEUED = new RequestState(5, new RequestStateCodes[]{RequestStateCodes.QUEUED});
    public static final RequestState PROCESSING = new RequestState(6, new RequestStateCodes[]{RequestStateCodes.PROCESSING});
    public static final RequestState SUCCEEDED = new RequestState(7, new RequestStateCodes[]{RequestStateCodes.SUCCEEDED});
    public static final RequestState FAILED = new RequestState(8, new RequestStateCodes[]{RequestStateCodes.FAILED});
    public static final RequestState CANCELED = new RequestState(9, new RequestStateCodes[]{RequestStateCodes.CANCELED});
    public static final RequestState INVALID = new RequestState(10, new RequestStateCodes[]{RequestStateCodes.INVALID});
    public static final RequestState INITIAL = new RequestState(11, new RequestStateCodes[]{RequestStateCodes.NEW});
    public static final RequestState FINAL = new RequestState(12, new RequestStateCodes[]{RequestStateCodes.SUCCEEDED, RequestStateCodes.FAILED, RequestStateCodes.CANCELED, RequestStateCodes.INVALID, RequestStateCodes.SUSPENDED});
    public static final RequestState TRANSIENT = new RequestState(13, new RequestStateCodes[]{RequestStateCodes.QUEUED, RequestStateCodes.PENDING, RequestStateCodes.WAITING, RequestStateCodes.ABORTED, RequestStateCodes.PROCESSING});
    public static final RequestState ALL = new RequestState(14, new RequestStateCodes[]{RequestStateCodes.NEW, RequestStateCodes.SUCCEEDED, RequestStateCodes.FAILED, RequestStateCodes.CANCELED, RequestStateCodes.INVALID, RequestStateCodes.SUSPENDED, RequestStateCodes.QUEUED, RequestStateCodes.PENDING, RequestStateCodes.WAITING, RequestStateCodes.ABORTED, RequestStateCodes.PROCESSING});

    protected RequestState(short value, RequestStateCodes[] associatedStateCodes) {
        super(value);
        this.mAssociatedStateCodes = associatedStateCodes;
    }

    public static boolean isValid(short state) {
        return NEW.equals(state) || PENDING.equals(state) || QUEUED.equals(state) || PROCESSING.equals(state) || SUCCEEDED.equals(state) || WAITING.equals(state) || FAILED.equals(state) || CANCELED.equals(state) || INVALID.equals(state) || SUSPENDED.equals(state) || INITIAL.equals(state) || TRANSIENT.equals(state) || FINAL.equals(state) || ALL.equals(state);
    }

    public static RequestState fromShort(short state) {
        if (NEW.equals(state)) {
            return NEW;
        }
        if (PENDING.equals(state)) {
            return PENDING;
        }
        if (QUEUED.equals(state)) {
            return QUEUED;
        }
        if (SUSPENDED.equals(state)) {
            return SUSPENDED;
        }
        if (CANCELED.equals(state)) {
            return CANCELED;
        }
        if (PROCESSING.equals(state)) {
            return PROCESSING;
        }
        if (WAITING.equals(state)) {
            return WAITING;
        }
        if (ABORTED.equals(state)) {
            return ABORTED;
        }
        if (SUCCEEDED.equals(state)) {
            return SUCCEEDED;
        }
        if (FAILED.equals(state)) {
            return FAILED;
        }
        if (INVALID.equals(state)) {
            return INVALID;
        }
        if (INITIAL.equals(state)) {
            return INITIAL;
        }
        if (TRANSIENT.equals(state)) {
            return TRANSIENT;
        }
        if (FINAL.equals(state)) {
            return FINAL;
        }
        if (ALL.equals(state)) {
            return ALL;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return RequestState.toString(this.value);
    }

    public RequestStateCodes[] getAssociatedStateCodes() {
        return this.mAssociatedStateCodes;
    }

    public static String toString(short state) {
        switch (state) {
            case 0: {
                return "NEW";
            }
            case 1: {
                return "PENDING";
            }
            case 2: {
                return "SUSPENDED";
            }
            case 3: {
                return "WAITING";
            }
            case 4: {
                return "INTERRUPTED";
            }
            case 5: {
                return "QUEUED";
            }
            case 6: {
                return "PROCESSING";
            }
            case 7: {
                return "SUCCEEDED";
            }
            case 8: {
                return "FAILED";
            }
            case 9: {
                return "CANCELED";
            }
            case 10: {
                return "INVALID";
            }
            case 11: {
                return "INITIAL";
            }
            case 12: {
                return "FINAL";
            }
            case 13: {
                return "TRANSIENT";
            }
            case 14: {
                return "ALL";
            }
        }
        return "UNKNOWN";
    }
}

