/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.bootstrap.ntv;

import com.sap.engine.bootstrap.BootstrapLogger;
import java.io.File;
import java.io.IOException;

public class ISeriesNativeHandler
implements Runnable {
    private String parm_oslibsdir;
    private String parm_filename;
    private String parm_instancenumber;
    private String savlib;
    private String j2eelib;
    private String objtype;
    private String file_basename;
    private String file_ending_ifs;
    private String file_ending_lib;
    private boolean nativeProcessingNeeded = false;

    private int runOS400Command(String command) {
        Runtime rt = Runtime.getRuntime();
        String commandFull = "system " + command;
        int rc = -1;
        try {
            Process p = rt.exec(commandFull);
            p.waitFor();
            rc = p.exitValue();
        }
        catch (Exception e) {
            BootstrapLogger.logThrowable("Exception occured running command \"" + command + "\"", (Throwable)e);
        }
        BootstrapLogger.log("OS/400 command \"" + command + "\" returned " + rc + ".");
        return rc;
    }

    public ISeriesNativeHandler(String oslibsdir, String filename) {
        BootstrapLogger.log("Called ISeriesNativeHandler");
        File f = new File(oslibsdir);
        String oslibsdirFull = f.getAbsolutePath();
        try {
            oslibsdirFull = f.getCanonicalPath();
        }
        catch (IOException e) {
            BootstrapLogger.log("IOException thrown when resolving canonical path for " + oslibsdir + ".");
        }
        f = new File(filename);
        String filenameFull = f.getAbsolutePath();
        try {
            filenameFull = f.getCanonicalPath();
        }
        catch (IOException e) {
            BootstrapLogger.log("IOException thrown when resolving canonical path for " + filename + ".");
        }
        String instno = "0";
        String inst_prop = System.getProperty("SAPSYSTEM");
        if (inst_prop != null) {
            instno = inst_prop;
        }
        BootstrapLogger.log("Params:oslibsdir=" + oslibsdirFull + ",filename=" + filenameFull + ",instno=" + instno + ")");
        this.init(oslibsdirFull, filenameFull, instno);
    }

    public void init(String oslibsdir, String filename, String instancenumber) {
        this.parm_oslibsdir = oslibsdir;
        this.parm_filename = filename;
        this.parm_instancenumber = instancenumber;
        this.savlib = "JAVAILE";
        this.j2eelib = "SAPJ2EE" + this.parm_instancenumber;
        if (this.parm_filename.toUpperCase().lastIndexOf(".ILEPGM") != -1) {
            this.file_basename = this.parm_filename.substring(this.parm_filename.lastIndexOf("/") + 1, this.parm_filename.toUpperCase().lastIndexOf(".ILEPGM"));
            this.file_ending_ifs = "";
            this.file_ending_lib = ".PGM";
            this.objtype = "*PGM";
            this.nativeProcessingNeeded = true;
        } else if (this.parm_filename.toUpperCase().lastIndexOf(".ILESRVPGM") != -1) {
            this.file_basename = this.parm_filename.substring(this.parm_filename.lastIndexOf("/") + 1, this.parm_filename.toUpperCase().lastIndexOf(".ILESRVPGM"));
            this.file_ending_ifs = ".SRVPGM";
            this.file_ending_lib = ".SRVPGM";
            this.objtype = "*SRVPGM";
            this.nativeProcessingNeeded = true;
        } else {
            this.file_basename = "";
            this.file_ending_ifs = "";
            this.file_ending_lib = "";
            this.objtype = "";
            this.nativeProcessingNeeded = false;
        }
        if (this.nativeProcessingNeeded) {
            BootstrapLogger.log("Native processing needed for " + this.parm_filename + ".");
        } else {
            BootstrapLogger.log("No native processing needed for" + this.parm_filename + ".");
        }
    }

    public void run() {
        if (!this.nativeProcessingNeeded) {
            return;
        }
        this.runOS400Command("CRTLIB " + this.j2eelib);
        this.runOS400Command("RMVLNK OBJLNK('" + this.parm_oslibsdir + "/" + this.file_basename + this.file_ending_ifs + "')");
        this.runOS400Command("RMVLNK OBJLNK('/QSYS.LIB/" + this.j2eelib + ".LIB/" + this.file_basename + this.file_ending_lib + "')");
        this.runOS400Command("RMVLNK OBJLNK('/QSYS.LIB/" + this.j2eelib + ".LIB/" + this.file_basename + ".FILE')");
        if (this.runOS400Command("CPYFRMSTMF FROMSTMF('" + this.parm_filename + "') TOMBR('/QSYS.LIB/" + this.j2eelib + ".LIB/" + this.file_basename + ".FILE') MBROPT(*REPLACE)") != 0) {
            BootstrapLogger.log("Error: Could not copy Streamfile to Savefile. Native extraction of " + this.parm_filename + " failed!");
            return;
        }
        if (this.runOS400Command("RSTOBJ OBJ(" + this.file_basename + ") SAVLIB(" + this.savlib + ") DEV(*SAVF) OBJTYPE(" + this.objtype + ") SAVF(" + this.j2eelib + "/" + this.file_basename + ") MBROPT(*ALL) RSTLIB(" + this.j2eelib + ")") != 0) {
            BootstrapLogger.log("Error: Could not restore ILE object. Native extraction of " + this.parm_filename + " failed!");
            return;
        }
        this.runOS400Command("FIXR3OWNS " + this.j2eelib);
        this.runOS400Command("RMVLNK OBJLNK('/QSYS.LIB/" + this.j2eelib + ".LIB/" + this.file_basename + ".FILE')");
        if (this.runOS400Command("ADDLNK OBJ('/QSYS.LIB/" + this.j2eelib + ".LIB/" + this.file_basename + this.file_ending_lib + "') NEWLNK('" + this.parm_oslibsdir + "/" + this.file_basename + this.file_ending_ifs + "')") != 0) {
            BootstrapLogger.log("Error: Could not link ILE object. Native extraction of " + this.parm_filename + " failed!");
            return;
        }
    }
}

