/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.bootstrap;

import com.sap.engine.bootstrap.BootstrapLogger;
import com.sap.engine.bootstrap.NodeData;
import com.sap.engine.bootstrap.SynchronizationException;
import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.InvalidValueException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.NoWriteAccessException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.lib.io.version.Version;
import com.sap.engine.lib.io.version.VersionFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class Synchronizer {
    public static final byte ACTION_DO_NOTHING = -1;
    public static final byte ACTION_DOWNLOAD = 0;
    public static final byte ACTION_UPLOAD = 1;
    public static final byte NO_RESYNCH = 0;
    public static final byte FORCE_RESYNCH = 1;
    public static final byte DETECT_RESYNCH = 2;
    private final String propertyRunningMode = "runMode";
    private final String propertyRunningAction = "runAction";
    private final String propertySafeModePerformer = "performerID";
    Configuration rootCfg = null;
    ConfigurationHandler handler = null;
    ConfigurationHandlerFactory factory = null;

    protected Synchronizer(Properties p, String DBrootPath, boolean readOnly) throws ConfigurationException {
        ConfigurationManagerBootstrapImpl factory = new ConfigurationManagerBootstrapImpl(p);
        this.handler = factory.getConfigurationHandler();
        this.rootCfg = readOnly ? this.handler.openConfiguration(DBrootPath, 0) : this.handler.openConfiguration(DBrootPath, 1);
    }

    public Synchronizer(Properties p, String DBrootPath) throws ConfigurationException {
        ConfigurationManagerBootstrapImpl factory = new ConfigurationManagerBootstrapImpl(p);
        this.handler = factory.getConfigurationHandler();
        this.rootCfg = this.handler.openConfiguration(DBrootPath, 0);
    }

    public String getElementType(String cid) throws SynchronizationException {
        String type = null;
        type = cid.endsWith("00") ? "dispatcher" : "server";
        if (this.getConfiguration(this.rootCfg, type + File.separatorChar + cid) != null) {
            return type;
        }
        throw new SynchronizationException("No such Dialog Instance (" + cid + ") in the database! Check database consistency or local Bootstrap properties!");
    }

    public Version getBinariesVersion(String binariesVersionEntryName, String nativesVersionEntryName, String indexEntryName, String bootstrapEntryName) throws SynchronizationException {
        try {
            VersionFile ver = new VersionFile();
            Integer i = null;
            i = (Integer)this.rootCfg.getConfigEntry(binariesVersionEntryName);
            ver.setVersion("bin", i.intValue());
            try {
                i = (Integer)this.rootCfg.getConfigEntry(nativesVersionEntryName);
                ver.setVersion("os_libs", i.intValue());
            }
            catch (NameNotFoundException e) {
                ver.setVersion("os_libs", -1);
            }
            InputStream indexStream = this.rootCfg.getFile(indexEntryName);
            ver.setIndex(HashUtils.getIndex((InputStream)indexStream));
            indexStream = this.rootCfg.getFile(bootstrapEntryName);
            ver.setIndex(HashUtils.getIndex((InputStream)indexStream));
            return ver;
        }
        catch (NameNotFoundException nnfe) {
            throw new SynchronizationException("Probably an outdated or empty database. Unable to det the index and version information!", (Exception)((Object)nnfe));
        }
        catch (IOException ioe) {
            throw new SynchronizationException("Unable to read database binaries index! Check database consistency!", ioe);
        }
        catch (ConfigurationException e) {
            throw new SynchronizationException("Unable to read database binaries version! Check database consistency!", (Exception)((Object)e));
        }
    }

    public void synchronizeFile(String cfgPath, String filename, String localPath) throws Exception {
        Configuration cfg = this.getConfiguration(this.rootCfg, cfgPath);
        this.getFile(cfg, filename, localPath);
    }

    public void synchronizeFile(String cfgPath, String localPath, boolean createFolders) throws Exception {
        InputStream in;
        block8: {
            int cfgIndex = cfgPath.lastIndexOf(47);
            if (cfgIndex == -1 && (cfgIndex = cfgPath.lastIndexOf(92)) == -1) {
                cfgIndex = 0;
            }
            Configuration cfg = this.getConfiguration(this.rootCfg, cfgPath.substring(0, cfgIndex));
            BootstrapLogger.log("Synchronizing file [" + localPath + "].");
            in = null;
            FileOutputStream fileout = null;
            try {
                in = cfg.getFile(cfgPath.substring(cfgIndex + 1));
                if (createFolders) {
                    int fileIndex = localPath.lastIndexOf(47);
                    if (fileIndex == -1 && (fileIndex = localPath.lastIndexOf(92)) == -1) {
                        fileIndex = 0;
                    }
                    new File(localPath.substring(0, fileIndex)).mkdirs();
                }
                fileout = new FileOutputStream(localPath);
                this.getFile(in, fileout);
                Object var10_9 = null;
                if (fileout == null) break block8;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (fileout != null) {
                    fileout.close();
                }
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
            fileout.close();
        }
        if (in != null) {
            in.close();
        }
        BootstrapLogger.log("...Done!");
    }

    private void getFile(Configuration cfg, String filename, String localPath) throws IOException, ConfigurationException {
        InputStream in;
        block5: {
            in = null;
            FileOutputStream fileout = null;
            try {
                in = cfg.getFile(filename);
                fileout = new FileOutputStream(localPath + File.separatorChar + filename);
                BootstrapLogger.log("Synchronizing file [" + localPath + File.separatorChar + filename + "].");
                this.getFile(in, fileout);
                Object var7_6 = null;
                if (fileout == null) break block5;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (fileout != null) {
                    fileout.close();
                }
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
            fileout.close();
        }
        if (in != null) {
            in.close();
        }
        BootstrapLogger.log("...Done!");
    }

    private void getFile(InputStream in, FileOutputStream fileout) throws IOException {
        byte[] buf = new byte[1024];
        int received = 0;
        while ((received = in.read(buf)) != -1) {
            fileout.write(buf, 0, received);
        }
    }

    public void synchronizeBinaries(String cfgPath, File localFolder, boolean recursive) throws IOException, ConfigurationException {
        Configuration c = this.getConfiguration(this.rootCfg, cfgPath);
        this.getBinaries(c, localFolder.getCanonicalPath(), recursive);
    }

    public void synchronizeProperties(String global, String local, File localFolder) throws IOException, ConfigurationException, SynchronizationException {
        Configuration globalCfg = this.getConfiguration(this.rootCfg, global);
        Configuration localCfg = null;
        if (local != null) {
            localCfg = this.getConfiguration(this.rootCfg, local);
        }
        this.loadProperties(globalCfg, localCfg, localFolder.getCanonicalPath());
    }

    public void loadSinglePropertiesFile(String cfgPath, String localFilePath, NodeData node, boolean sort) throws ConfigurationException, IOException {
        FileOutputStream fos;
        block13: {
            Configuration cfg = this.getConfiguration(this.rootCfg, cfgPath);
            PropertySheet ps = cfg.getPropertySheetInterface();
            Properties p = ps.getProperties();
            p.setProperty("instance.runMode", node.runningMode);
            p.setProperty("instance.enabled", "yes");
            p.setProperty("instance.runAction", node.runningAction);
            Set keySet = ((Hashtable)p).keySet();
            BootstrapLogger.log("Instance [" + node.instanceID + "] will run in [" + node.runningMode + "] mode, performing action [" + node.runningAction + "]");
            if ("safe".equalsIgnoreCase(node.runningMode)) {
                if (!node.instanceID.equalsIgnoreCase(node.performerID)) {
                    p.setProperty("instance.enabled", "no");
                    BootstrapLogger.log("Safe mode lock is imposed by instance [" + node.performerID + "] - local instance will be disabled.");
                } else {
                    p.setProperty("instance.enabled", "yes");
                    Iterator iter = keySet.iterator();
                    String performerS = node.performerID + "50";
                    String performerD = node.performerID + "00";
                    BootstrapLogger.log("Safe mode lock is imposed by instance [" + node.performerID + "] - only server [" + performerS + "] and dispatcher [" + performerD + "] will be started locally.");
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        if (key.startsWith("instance.") || key.startsWith("bootstrap.") || key.indexOf(performerS) != -1 || key.indexOf(performerD) != -1) continue;
                        iter.remove();
                    }
                    p.setProperty(performerS + ".JavaParameters", p.getProperty(performerS + ".JavaParameters") + " -Dstartup.mode=SAFE -Dstartup.action=" + node.runningAction);
                    p.setProperty(performerD + ".JavaParameters", p.getProperty(performerD + ".JavaParameters") + " -Dstartup.mode=SAFE -Dstartup.action=" + node.runningAction);
                }
            }
            Object[] keys = new String[keySet.size()];
            keySet.toArray(keys);
            Arrays.sort(keys);
            Object worker = null;
            String workerValue = null;
            File originalFile = new File(localFilePath);
            File backupFile = new File(localFilePath + "." + System.currentTimeMillis());
            boolean renameResult = true;
            if (originalFile.exists()) {
                renameResult = originalFile.renameTo(backupFile);
            }
            if (renameResult) {
                fos = new FileOutputStream(localFilePath);
                try {
                    try {
                        int i = 0;
                        while (i < keys.length) {
                            worker = keys[i];
                            workerValue = p.getProperty((String)worker);
                            fos.write(((String)worker).getBytes());
                            fos.write("=".getBytes());
                            fos.write(workerValue.getBytes());
                            fos.write("\n".getBytes());
                            ++i;
                        }
                        fos.close();
                        backupFile.delete();
                    }
                    catch (IOException e) {
                        fos.close();
                        originalFile.delete();
                        boolean restore = backupFile.renameTo(originalFile);
                        if (restore) {
                            BootstrapLogger.log("File: " + localFilePath + " restored from backup due to IOException: " + e.getMessage());
                            backupFile.delete();
                        } else {
                            BootstrapLogger.log("File: " + localFilePath + " restore FAILED! Please find the content in [" + backupFile.getAbsolutePath() + "].");
                        }
                        throw e;
                    }
                    Object var19_18 = null;
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var19_19 = null;
                    fos.close();
                    throw throwable;
                }
            }
            throw new IOException("Unable to backup instance.properties before synchronization - please check permitions and local free disk space.");
        }
        fos.close();
    }

    public void synchronizePropertyFile(Configuration cfg, OutputStream localFile) throws ConfigurationException, IOException {
        PropertySheet ps = cfg.getPropertySheetInterface();
        Properties p = ps.getProperties();
        p.store(localFile, null);
    }

    public Properties updateProperties(Configuration cfg, Properties props) throws ConfigurationException {
        if (props == null) {
            props = new Properties();
        }
        Properties p = cfg.getPropertySheetInterface().getProperties();
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            ((Hashtable)props).put(name, p.getProperty(name));
        }
        return props;
    }

    public Properties updateProperties(String cfgName, Properties props) throws ConfigurationException {
        Configuration cfg = null;
        cfg = this.getConfiguration(this.rootCfg, cfgName);
        Properties p = this.updateProperties(cfg, props);
        return p;
    }

    private void getBinaries(Configuration config, String localPath, boolean recursive) throws IOException, ConfigurationException {
        Map subConfigs = config.getAllSubConfigurations();
        if (recursive && subConfigs != null && !subConfigs.isEmpty()) {
            Set keySet = subConfigs.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                String nextSubName = (String)iter.next();
                Configuration subConfig = (Configuration)subConfigs.get(nextSubName);
                String subDir = localPath + File.separatorChar + nextSubName;
                new File(subDir).mkdirs();
                this.getBinaries(subConfig, subDir, recursive);
            }
        }
        this.getFiles(config, localPath);
    }

    private void loadProperties(Configuration globalCfg, Configuration localCfg, String folder) throws IOException, ConfigurationException {
        Map globalSubConfigs = globalCfg.getAllSubConfigurations();
        if (!globalSubConfigs.isEmpty()) {
            Set keySet = globalSubConfigs.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                String nextSubName = (String)iter.next();
                Configuration globalSubConfig = (Configuration)globalSubConfigs.get(nextSubName);
                Properties p = this.updateProperties(globalSubConfig, null);
                try {
                    Configuration localSubConfig = localCfg.getSubConfiguration(nextSubName);
                    p = this.updateProperties(localSubConfig, p);
                }
                catch (ConfigurationException e) {
                    BootstrapLogger.log(300, "No local properties available for [" + nextSubName + "].");
                }
                String propFile = folder + File.separatorChar + nextSubName + ".properties";
                File f = new File(propFile);
                if (f.exists()) {
                    f.delete();
                }
                p.store(new FileOutputStream(propFile), null);
            }
        }
        this.getFiles(globalCfg, folder);
        this.getFiles(localCfg, folder);
    }

    private void getFiles(Configuration cfg, String localPath) throws IOException, ConfigurationException {
        Map fileEntries;
        if (cfg != null && !(fileEntries = cfg.getAllFileEntries()).isEmpty()) {
            Set keySet = fileEntries.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                this.getFile(cfg, (String)iter.next(), localPath);
            }
        }
    }

    private Configuration getConfiguration(Configuration root, String relativePath) {
        StringTokenizer st = new StringTokenizer(relativePath, "/\\");
        Configuration worker = root;
        while (st.hasMoreTokens()) {
            try {
                worker = worker.getSubConfiguration(st.nextToken());
            }
            catch (Exception e) {
                BootstrapLogger.logThrowable(e);
                return null;
            }
        }
        return worker;
    }

    public InputStream getStreamToFile(String cfgPath, String fileName) throws ConfigurationException, NameNotFoundException {
        Configuration c = this.getConfiguration(this.rootCfg, cfgPath);
        return c.getFile(fileName);
    }

    public void getRunningModeInfo(NodeData node) throws SynchronizationException {
        block8: {
            try {
                Object value = this.rootCfg.getConfigEntry("runMode");
                if (value != null) {
                    node.runningMode = (String)value;
                    if ("SAFE".equalsIgnoreCase(node.runningMode)) {
                        try {
                            value = this.rootCfg.getConfigEntry("performerID");
                            node.performerID = value != null ? (String)value : "";
                        }
                        catch (ConfigurationException e) {
                            node.runningMode = "NORMAL";
                            node.runningAction = "NONE";
                            node.performerID = "";
                            throw new SynchronizationException("Missing Performer property when running in SAFE mode", (Exception)((Object)e));
                        }
                    }
                    try {
                        value = this.rootCfg.getConfigEntry("runAction");
                        node.runningAction = value != null ? (String)value : "NONE";
                        break block8;
                    }
                    catch (ConfigurationException e) {
                        node.runningMode = "NORMAL";
                        node.runningAction = "NONE";
                        node.performerID = "";
                        throw new SynchronizationException("Missing RunningAction property when running in SAFE mode", (Exception)((Object)e));
                    }
                }
                node.runningMode = "NORMAL";
                return;
            }
            catch (ConfigurationException e) {
                node.runningMode = "NORMAL";
                node.runningAction = "NONE";
                node.performerID = "";
                BootstrapLogger.log("Missing RunningMode property - runningin NORMAL mode.");
            }
        }
    }

    public void setRunningModeData(String mode, String action, String performer) throws ConfigurationException, InvalidValueException, NoWriteAccessException {
        this.rootCfg.modifyConfigEntry("runMode", (Object)mode, true);
        this.rootCfg.modifyConfigEntry("runAction", (Object)action, true);
        this.rootCfg.modifyConfigEntry("performerID", (Object)performer, true);
    }
}

