/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.bootstrap;

import com.sap.engine.bootstrap.Synchronizer;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class StartupModeSetter {
    public static void main(String[] args) {
        if (args.length == 2) {
            String mode = null;
            String action = null;
            if ("safe".equalsIgnoreCase(args[0])) {
                mode = "safe";
            } else if ("normal".equalsIgnoreCase(args[0])) {
                mode = "normal";
            } else {
                System.out.println("Unknown startup mode - only (safe/normal) are supported!");
                System.exit(66);
            }
            if ("upgrade".equalsIgnoreCase(args[1])) {
                action = "UPGRADE";
            } else if ("none".equalsIgnoreCase(args[1])) {
                action = "NONE";
            } else if ("convert".equalsIgnoreCase(args[1])) {
                action = "CONVERT";
            } else if ("migrate".equalsIgnoreCase(args[1])) {
                action = "MIGRATE";
            } else {
                System.out.println("Unknown startup action - only (none/upgrade/convert/migrate) are supported!");
                System.exit(66);
            }
            try {
                System.out.print("Setting runtime mode [" + mode + "] action [" + action + "] : ");
                StartupModeSetter.setMode(mode, action);
            }
            catch (ConfigurationException ce) {
                System.out.println("FAILED!");
                System.out.println("Error modifying the database!");
                ce.printStackTrace();
                System.exit(65);
            }
            catch (IOException e) {
                System.out.println("Error reading file file (./bootstrap/bootstrap.properties).");
                System.out.println("The process has to be run in cluster folder and not in [" + new File(".").getAbsolutePath() + "]");
                e.printStackTrace();
                System.exit(64);
            }
            System.out.println("Fine!");
            System.exit(0);
        } else {
            System.out.println("USAGE: StartupModeSeffer <mode> <action>");
        }
    }

    private static void setMode(String mode, String action) throws ConfigurationException, IOException {
        Properties p = new Properties();
        p.load(new FileInputStream("./bootstrap/bootstrap.properties"));
        String performer = p.getProperty("instance.prefix");
        performer = "ID" + Integer.parseInt(performer.substring(2, performer.length()));
        System.out.print(" for instance [" + performer + "] : ");
        Synchronizer synch = new Synchronizer(p, "cluster_data", false);
        try {
            synch.setRunningModeData(mode, action, performer);
            System.out.println("DONE!");
            synch.handler.commit();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            synch.handler.closeAllConfigurations();
            throw throwable;
        }
        synch.handler.closeAllConfigurations();
    }
}

