/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.bootstrap;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.Severity;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

public class BootstrapLogger {
    private static final String LOGGING_LOCATION_NAME = "com.sap.engine.bootstrap";
    public static final Location location = Location.getLocation((String)"com.sap.engine.bootstrap");
    public static final int LOCATION_SEVERITY = 300;
    private static final String LOCATION_SEVERITY_STR = Severity.toString((int)300);
    private static final int MAX_LOG_SIZE = 0x200000;
    private static final int LOG_FILE_CHUNKS_COUNT = 2;
    private static final String LOGS_LOCATION = ".." + File.separatorChar + ".." + File.separatorChar + "work" + File.separatorChar;
    private static boolean initialized = false;

    public static void init(String id) {
        if (id == null) {
            id = Long.toString(System.currentTimeMillis());
        }
        Properties properties = new Properties();
        properties.setProperty("log[consoleLog]", "com.sap.engine.bootstrap.BootstrapConsoleLog");
        properties.setProperty("log[consoleLog].formatter", "formatter[ConsoleFormatter]");
        properties.setProperty("formatter[ConsoleFormatter]", "TraceFormatter");
        properties.setProperty("formatter[ConsoleFormatter].pattern", "%m");
        properties.setProperty("log[defaultTrace]", "FileLog");
        properties.setProperty("log[defaultTrace].pattern", LOGS_LOCATION + "log_bootstrap_" + id + ".log");
        properties.setProperty("log[defaultTrace].limit", Integer.toString(0x200000));
        properties.setProperty("log[defaultTrace].cnt", Integer.toString(2));
        properties.setProperty("log[defaultTrace].formatter", "formatter[BootstrapFormatter]");
        properties.setProperty("formatter[BootstrapFormatter]", "TraceFormatter");
        properties.setProperty("formatter[BootstrapFormatter].pattern", "[%24d] %m");
        properties.setProperty("com.sap.engine.bootstrap.logs", "log[defaultTrace],log[consoleLog]");
        properties.setProperty("com.sap.engine.bootstrap.severity", LOCATION_SEVERITY_STR);
        PropertiesConfigurator pc = new PropertiesConfigurator(properties);
        pc.configure();
        initialized = true;
    }

    public static void log(int severity, String message) {
        if (initialized) {
            location.logT(severity, message);
        } else {
            System.out.println(message);
        }
    }

    public static void log(String mesage) {
        BootstrapLogger.log(300, mesage);
    }

    public static void logThrowable(int severity, String message, Throwable t) {
        BootstrapLogger.log(severity, BootstrapLogger.convertThrowable(message, t));
    }

    public static void logThrowable(String message, Throwable t) {
        BootstrapLogger.logThrowable(300, message, t);
    }

    public static void logThrowable(int severity, Throwable t) {
        BootstrapLogger.logThrowable(severity, "Exception occured:", t);
    }

    public static void logThrowable(Throwable t) {
        BootstrapLogger.logThrowable(300, t);
    }

    private static String convertThrowable(String message, Throwable t) {
        String returnStr = new String(message + "\n");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        t.printStackTrace(ps);
        try {
            ps.flush();
            baos.flush();
        }
        catch (IOException e) {
            returnStr = returnStr + e.getMessage();
        }
        returnStr = returnStr + baos.toString();
        try {
            ps.close();
            baos.close();
        }
        catch (IOException e) {
            returnStr = returnStr + e.getMessage();
        }
        return returnStr;
    }
}

