/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.bootstrap;

import com.sap.engine.bootstrap.BootstrapLogger;
import com.sap.engine.bootstrap.DescriptorEntry;
import com.sap.engine.bootstrap.DescriptorParser;
import com.sap.engine.bootstrap.NodeData;
import com.sap.engine.bootstrap.SynchronizationException;
import com.sap.engine.bootstrap.Synchronizer;
import com.sap.engine.bootstrap.ntv.HandlerExecutor;
import com.sap.engine.bootstrap.ntv.ISeriesNativeHandler;
import com.sap.engine.bootstrap.ntv.LinuxNativeHandler;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.io.hash.FolderCompareResult;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.lib.io.hash.Index;
import com.sap.engine.lib.io.version.Version;
import com.sap.engine.lib.io.version.VersionFile;
import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;

public class Bootstrap {
    private static final byte MODE_BETA2 = 0;
    private static final byte MODE_NATIVE_FILES = 1;
    private static final byte MODE_INSTANCE = 2;
    private static final byte MODE_SINGLE_NODE = 3;
    private final char separator = File.separatorChar;
    private String clusterElementID = null;
    private byte elementResynch = 1;
    private static final byte OK = 0;
    private static final byte FAILED = 1;
    protected static final String DBrootPath = "cluster_data";
    private final String SDMRootPath = ".." + this.separator + ".." + this.separator + "SDM" + this.separator + "program";
    private final String localCfgTempDirName = "cfg";
    private final String cfgElementInfoName = "element-info";
    private final String dbBinVersionEntryName = "binVersion";
    private final String dbNativeVersionEntryName = "os_libVersion";
    private final String localVersionFileName = "version.bin";
    private final String propertyLocalHome = "local.home";
    private final String nativeDescriptorName = "native.descriptor";
    private final String[] downloadStatus = new String[]{"Ok!", "Failed!", "Not found!", "Ignored!"};
    private final String indexSuffix = "Index";
    private final String propertyClusterIDName = "element.clusterID";
    private final String propertyForceResynchName = "element.resynch";
    protected static final String propertyInstancePrefixName = "instance.prefix";
    private final String propertyOfflineCfgManagerLogFolder = "offlineconfig.log.location";
    private final String dbPropertyOSName = "os.name";
    private final String dbPropertyOSUnicode = "os.unicode";
    private final String dbPropertyOSBitLength = "os.bit.length";
    private final String dbPropertyLocalFolder = "directory";
    private Synchronizer synch = null;
    private Version dbVersionFile = null;
    public static final String BINARIES_VERSION_KEY = "bin";
    public static final String NATIVE_VERSION_KEY = "os_libs";
    public static final String BOOTSTRAP_VERSION_KEY = "bootstrap";
    private final String nativeFilesMode = "755";
    private final int nativeChmodTimeout = 10000;
    private final String bootstrap_properties_file_name = "boostrap.properties";
    private final String bootstrap_log_folder = "./bootstrap";
    private byte mode = (byte)-1;
    private static final String START_DELIMITER_LINE = "--------------------------------------------------";

    public Bootstrap(String parameter, byte mode) throws SynchronizationException {
        this.printMode(parameter, mode);
        BootstrapLogger.log(START_DELIMITER_LINE);
        Properties p = this.readPropertiesFile("boostrap.properties");
        p.setProperty("offlineconfig.log.location", "./bootstrap");
        this.mode = mode;
        String worker = p.getProperty("element.resynch");
        this.elementResynch = worker != null ? (worker.equalsIgnoreCase("force") ? 1 : (worker.equalsIgnoreCase("skip") ? 0 : 2)) : (byte)2;
        switch (mode) {
            case 0: {
                worker = p.getProperty("element.clusterID");
                if (worker != null) {
                    this.clusterElementID = "ID" + worker;
                    this.initDatabaseConnection(p, this.clusterElementID);
                    break;
                }
                throw new SynchronizationException("Property [element.clusterID] not set in the properties file. ");
            }
            case 1: {
                worker = p.getProperty(propertyInstancePrefixName);
                if (worker != null) {
                    this.clusterElementID = worker;
                    this.initDatabaseConnection(p, this.clusterElementID + "00");
                    break;
                }
                throw new SynchronizationException("Property [instance.prefix] not set in the properties file.");
            }
            case 2: {
                worker = p.getProperty(propertyInstancePrefixName);
                if (worker != null) {
                    this.clusterElementID = "ID" + Integer.parseInt(parameter.substring(2));
                    this.initDatabaseConnection(p, this.clusterElementID + "00");
                    break;
                }
                throw new SynchronizationException("Property [instance.prefix] not set in the properties file.");
            }
            case 3: {
                this.clusterElementID = "ID" + Integer.parseInt(parameter.substring(2));
                this.initDatabaseConnection(p, this.clusterElementID);
            }
        }
    }

    private void synchInstanceGlobals(String instanceID) throws SynchronizationException {
        NodeData node;
        block26: {
            try {
                node = this.getElementData(instanceID + "00", true);
                node.setAdditionalData(".", this.loadLocalVersionFile("."));
            }
            catch (Exception e) {
                throw new SynchronizationException("Error getting data for instance [" + instanceID + "]!", e);
            }
            if (this.mode == 2) {
                try {
                    this.synch.loadSinglePropertiesFile("instance.properties." + instanceID, node.elementLocalHome + this.separator + "instance.properties", node, true);
                }
                catch (Exception e) {
                    throw new SynchronizationException("Unable to synchronize instance.properties for instance [" + instanceID + "]!", e);
                }
                try {
                    this.synch.synchronizeFile("", ".hotspot_compiler", node.elementLocalHome);
                }
                catch (Exception e) {
                    BootstrapLogger.logThrowable("No [.hotspot_compiler] file found in the database or error writing " + node.elementLocalHome + "/.hotspot_compiler file!", (Throwable)e);
                }
                try {
                    if (new File(this.SDMRootPath).exists()) {
                        this.synch.synchronizeFile("", ".hotspot_compiler", this.SDMRootPath);
                    }
                }
                catch (Exception e) {
                    BootstrapLogger.logThrowable("No [.hotspot_compiler] file found in the database or error writing " + this.SDMRootPath + "/.hotspot_compiler file!", (Throwable)e);
                }
            }
            try {
                if (node.localVersionFile.getVersion(NATIVE_VERSION_KEY) >= this.dbVersionFile.getVersion(NATIVE_VERSION_KEY)) break block26;
                BootstrapLogger.log(" * Synchronizing native files... ");
                String localOSLibsHome = node.elementLocalHome + this.separator + ".." + this.separator + NATIVE_VERSION_KEY;
                this.getOSDependentFiles(node.elementOSname, node.elementOSbitlength, node.elementOSunicode, localOSLibsHome);
                try {
                    node.localVersionFile.setVersion(NATIVE_VERSION_KEY, this.dbVersionFile.getVersion(NATIVE_VERSION_KEY));
                    node.localVersionFile.writeData();
                }
                catch (IOException e) {
                    throw new SynchronizationException("Error writing local instance version.bin file... Check permitions!", e);
                }
                BootstrapLogger.log(" Done!");
            }
            catch (Exception e) {
                throw new SynchronizationException("Unable to synchronize native files for instance [" + instanceID + "]!", e);
            }
        }
        if (this.elementResynch == 1 || node.localVersionFile.getVersion(BINARIES_VERSION_KEY) < this.dbVersionFile.getVersion(BINARIES_VERSION_KEY)) {
            FolderCompareResult bootstrapFCR = this.getBinariesResynchOperations(new File(BOOTSTRAP_VERSION_KEY), BOOTSTRAP_VERSION_KEY, node.localVersionFile);
            ArrayEnumeration downloadEnum = bootstrapFCR.getFilesForDownload();
            ArrayEnumeration deleteEnum = bootstrapFCR.getDeletedEntries();
            if (downloadEnum.size() > 0 || deleteEnum.size() > 2) {
                BootstrapLogger.log(" * Synchronizing bootstrap files... ");
                FileUtils fUtils = new FileUtils();
                File tmpFolder = new File("bootstrap_update" + System.currentTimeMillis());
                String tmpFolderAsString = tmpFolder.getAbsolutePath();
                SynchronizationException sex = new SynchronizationException("Error updating the bootstrap files...");
                try {
                    if (tmpFolder.exists() && !FileUtils.deleteDirectory((File)tmpFolder)) {
                        BootstrapLogger.log("Error deleting temp [" + tmpFolderAsString + "] folder from a previous session. Check priviledges!");
                    }
                    this.createIndexFolders(bootstrapFCR.getNewFolders(), BOOTSTRAP_VERSION_KEY);
                    if (!tmpFolder.mkdir()) {
                        throw new IOException("Unable to create folder [" + tmpFolderAsString + "] for the update files. Check priviledges!");
                    }
                    int synchCount = this.synchIndexChangedFiles(downloadEnum, BOOTSTRAP_VERSION_KEY, tmpFolderAsString, true);
                    BootstrapLogger.log(" " + synchCount + " temp files succesfully downloaded...");
                    if (downloadEnum.size() == synchCount) {
                        try {
                            node.localVersionFile.setVersion(BINARIES_VERSION_KEY, this.dbVersionFile.getVersion(BINARIES_VERSION_KEY));
                            node.localVersionFile.setIndex(this.dbVersionFile.getIndex(BOOTSTRAP_VERSION_KEY));
                            node.localVersionFile.writeData();
                        }
                        catch (IOException e) {
                            throw new SynchronizationException("Error writing local instance version.bin file... Check permitions!", e);
                        }
                    }
                    this.invokeClassloaderRelease();
                    int updateCount = this.moveFolderContentAndRemoveIt(tmpFolder, new File(BOOTSTRAP_VERSION_KEY), fUtils);
                    int deleteCount = this.deleteBootstrapEntries(deleteEnum, BOOTSTRAP_VERSION_KEY);
                    BootstrapLogger.log(" " + updateCount + " files succesfully updated...");
                    BootstrapLogger.log(" " + (deleteCount - 2) + " files succesfully deleted...");
                    if (synchCount != updateCount || deleteCount != deleteEnum.size()) {
                        node.localVersionFile.delete();
                        BootstrapLogger.log(" Update Failed! Please, move all the content of folder [" + tmpFolderAsString + "] to " + "cluster" + this.separator + "bootstrap folder manually! ");
                    } else {
                        BootstrapLogger.log(" Done!");
                    }
                }
                catch (Exception e) {
                    node.localVersionFile.delete();
                    BootstrapLogger.logThrowable(e);
                    sex.attachException(e);
                    throw sex;
                }
                catch (NoClassDefFoundError nocdfe) {
                    BootstrapLogger.log("Error loading class. Please report this!");
                    BootstrapLogger.logThrowable(nocdfe);
                }
            }
        }
    }

    private void invokeClassloaderRelease() {
        try {
            Class<?> fileClassLoaderClass = Class.forName("com.sap.engine.offline.FileClassLoader");
            ClassLoader currentLoader = this.getClass().getClassLoader();
            if (fileClassLoaderClass.isInstance(currentLoader)) {
                Method releaseFiles = fileClassLoaderClass.getMethod("releaseFiles", new Class[0]);
                releaseFiles.invoke((Object)currentLoader, (Object[])new Class[0]);
                BootstrapLogger.log(" Released all the files, helf by the File Class Loader.");
            } else {
                BootstrapLogger.log("ERROR: Current class loader is not of type FileClassLoader - Unable to release the opened files.");
            }
        }
        catch (ClassNotFoundException e) {
            BootstrapLogger.logThrowable("ERROR: Unable to load class FileClassLoader - Unable to release the opened files.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            BootstrapLogger.logThrowable("ERROR: Access is denied - Unable to release the class loader opened files.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            BootstrapLogger.logThrowable("ERROR: Mishmatched version - current class loader is not of type FileClassLoader - Unable to release the opened files.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            BootstrapLogger.logThrowable("ERROR: Mishmatched version - current class loader is older version - Unable to release the opened files.", (Throwable)e);
        }
    }

    private int moveFolderContentAndRemoveIt(File source, File dest, FileUtils fUtils) throws IOException {
        int count = 0;
        File[] files = source.listFiles();
        boolean failed = false;
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File tempFile = new File(dest, files[i].getName());
                if (files[i].isFile()) {
                    BootstrapLogger.log("Copying [" + tempFile + "] ...");
                    try {
                        FileUtils.copyFile((File)files[i], (File)tempFile);
                        BootstrapLogger.log(" Done!");
                        ++count;
                        files[i].delete();
                    }
                    catch (IOException e) {
                        failed = true;
                        BootstrapLogger.log(" Failed! (" + e.getMessage() + ") copying file (" + tempFile.getName() + ")");
                    }
                } else {
                    tempFile.mkdirs();
                    count += this.moveFolderContentAndRemoveIt(files[i], tempFile, fUtils);
                }
                ++i;
            }
        }
        if (!failed) {
            FileUtils.deleteDirectory((File)source);
        }
        return count;
    }

    private NodeData getElementData(String elementID, boolean skipAdditionalData) throws SynchronizationException {
        Properties elementProperties;
        NodeData node;
        block10: {
            node = new NodeData();
            node.instanceID = elementID.substring(0, elementID.length() - 2);
            this.synch.getRunningModeInfo(node);
            node.elementType = this.synch.getElementType(elementID);
            elementProperties = new Properties();
            try {
                elementProperties = this.synch.updateProperties(node.elementType + this.separator + elementID + this.separator + "element-info", elementProperties);
                if (elementProperties.getProperty("os.name") != null && elementProperties.getProperty("os.bit.length") != null && elementProperties.getProperty("os.unicode") != null) break block10;
                try {
                    elementProperties = this.synch.updateProperties(node.elementType + this.separator + "cfg" + this.separator + "element-info" + "." + elementID.substring(0, elementID.length() - 2), elementProperties);
                }
                catch (ConfigurationException e) {
                    throw new SynchronizationException("Incomplete element local element info for ID [" + elementID + "], but unable to read global info for the instance due to: ", (Exception)((Object)e));
                }
            }
            catch (ConfigurationException e) {
                throw new SynchronizationException("Unable to initialize [" + elementID + "] element properties from the Database.", (Exception)((Object)e));
            }
        }
        node.elementOSname = elementProperties.getProperty("os.name");
        String JVMReport = System.getProperty("sun.arch.data.model");
        node.elementOSbitlength = elementProperties.getProperty("os.bit.length");
        if (JVMReport != null && node.elementOSbitlength != null && !JVMReport.equals(node.elementOSbitlength)) {
            throw new SynchronizationException("os.bit.length property not set correctly [" + node.elementOSbitlength + "] ! Check database consistency! JVM reported [" + JVMReport + "]");
        }
        node.elementOSunicode = elementProperties.getProperty("os.unicode");
        if (node.elementOSname == null || node.elementOSbitlength == null || node.elementOSunicode == null) {
            throw new SynchronizationException("os.name or os.bit.length or os.unicode properties not set in the database! Check database consistency!");
        }
        node.elementOSunicode = node.elementOSunicode.equalsIgnoreCase("yes") ? "uc" : "nuc";
        if (!skipAdditionalData) {
            String localTemporaryHome = "." + this.separator + elementProperties.getProperty("directory");
            if (localTemporaryHome == null || this.mode == 0) {
                localTemporaryHome = ".";
            }
            if (!this.checkFolder(localTemporaryHome)) {
                new File(localTemporaryHome).mkdirs();
                if (!this.checkFolder(localTemporaryHome)) {
                    throw new SynchronizationException("local.home (" + localTemporaryHome + ") not set correctly, or the pointed folder is not writable. Check permitions!");
                }
            }
            node.setAdditionalData(localTemporaryHome, this.loadLocalVersionFile(localTemporaryHome));
        }
        return node;
    }

    private Properties readPropertiesFile(String propsFile) throws SynchronizationException {
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(this.getPropsFileInstance(propsFile)));
        }
        catch (IOException e) {
            throw new SynchronizationException("Properties file not found, or can't be read. Check permitions!", e);
        }
        return p;
    }

    private Version loadLocalVersionFile(String localHome) {
        VersionFile localVersionFile = new VersionFile(localHome + this.separator + "version.bin");
        if (this.elementResynch == 1) {
            localVersionFile.delete();
        }
        return localVersionFile;
    }

    private FolderCompareResult getBinariesResynchOperations(File f, String key, Version localVersionFile) throws SynchronizationException {
        Index dbIndex;
        if (!f.exists()) {
            f.mkdirs();
        }
        FolderCompareResult result = null;
        Index localIndex = null;
        if (this.elementResynch == 2) {
            localIndex = localVersionFile.getIndex(key);
        }
        if (this.elementResynch == 1 || this.elementResynch == 2 && localIndex == null) {
            try {
                localIndex = HashUtils.getIndex((File)f);
            }
            catch (IOException e1) {
                throw new SynchronizationException("Error reading local folder [" + f.getAbsolutePath() + "]! Check permitions!", e1);
            }
        }
        if ((dbIndex = this.dbVersionFile.getIndex(key)) == null) {
            throw new SynchronizationException("No Index found for [" + key + "] in the database! Check database consistency or offline deploy version.");
        }
        result = localIndex.compare(dbIndex, true);
        if (result.isChanged()) {
            localVersionFile.setIndex(dbIndex);
        }
        if (localVersionFile.getVersion(key) != this.dbVersionFile.getVersion(key)) {
            localVersionFile.setVersion(key, this.dbVersionFile.getVersion(key));
        }
        return result;
    }

    private void initDatabaseConnection(Properties p, String elementID) throws SynchronizationException {
        try {
            this.synch = new Synchronizer(p, DBrootPath);
            this.dbVersionFile = this.synch.getBinariesVersion("binVersion", "os_libVersion", this.synch.getElementType(elementID) + "Index", "bootstrapIndex");
        }
        catch (Exception e) {
            throw new SynchronizationException("Database initialization failed! Check database properties!", e);
        }
    }

    private File getPropsFileInstance(String name) throws IOException {
        File f = new File(name);
        if (f.exists()) {
            return f;
        }
        f = new File("." + this.separator + "bootstrap.properties");
        if (f.exists()) {
            return f;
        }
        f = new File("." + this.separator + BOOTSTRAP_VERSION_KEY + this.separator + "bootstrap.properties");
        if (f.exists()) {
            return f;
        }
        throw new IOException("Unable to find bootstrap property file.");
    }

    private boolean checkFolder(String absolutePath) {
        File f = null;
        if (absolutePath != null) {
            f = new File(absolutePath);
        }
        return f != null && f.exists() && f.isDirectory() && f.canWrite() && f.canRead();
    }

    private void printMode(String parameter, byte mode) {
        BootstrapLogger.log("Bootstrap MODE: ");
        switch (mode) {
            case 0: {
                BootstrapLogger.log("<BETA2> ");
                break;
            }
            case 2: {
                BootstrapLogger.log("<INSTANCE GLOBALS> ");
                break;
            }
            case 1: {
                BootstrapLogger.log("<NATIVE FILES> ");
                break;
            }
            case 3: {
                BootstrapLogger.log("<SINGLE INSTANCE> ");
            }
        }
        BootstrapLogger.log(" determined by parameter [" + parameter + "].");
    }

    private void printElementInfo(NodeData node) {
        BootstrapLogger.log("+----------------[ DB info ]----------------");
        BootstrapLogger.log("| Cluster ID in DB        : " + this.clusterElementID);
        BootstrapLogger.log("| Type                    : " + node.elementType);
        BootstrapLogger.log("| Installation Local Home : " + node.elementLocalHome);
        BootstrapLogger.log("| OS                      : " + node.elementOSname);
        BootstrapLogger.log("| Unicode support         : " + node.elementOSunicode);
        BootstrapLogger.log("| Bit-length              : " + node.elementOSbitlength);
        BootstrapLogger.log("| Binaries Synch Status   : " + this.elementResynch);
        BootstrapLogger.log("| Database bin version    : " + this.dbVersionFile.getVersion(BINARIES_VERSION_KEY));
        BootstrapLogger.log("| Local bin version       : " + node.localVersionFile.getVersion(BINARIES_VERSION_KEY));
        BootstrapLogger.log("+--------------------------------------------");
    }

    public void synchronize(NodeData node) throws SynchronizationException {
        long t2;
        long t1;
        block22: {
            String localBinPath = node.elementLocalHome + this.separator + BINARIES_VERSION_KEY;
            String localKernelCfgPath = node.elementLocalHome + this.separator + "cfg" + this.separator + "kernel";
            this.printElementInfo(node);
            FolderCompareResult binFCR = null;
            if (this.elementResynch != 0) {
                binFCR = this.getBinariesResynchOperations(new File(localBinPath), BINARIES_VERSION_KEY, node.localVersionFile);
            }
            try {
                BootstrapLogger.log(" * Synchronizing configuration... ");
                t1 = System.currentTimeMillis();
                this.getProperties(node.elementType + this.separator + "cfg" + this.separator + "kernel", node.elementType + this.separator + this.clusterElementID + this.separator + "kernel", localKernelCfgPath, true);
                t2 = System.currentTimeMillis();
                BootstrapLogger.log(this.downloadStatus[0] + " (" + (t2 - t1) + " ms)");
            }
            catch (Exception e) {
                BootstrapLogger.log(this.downloadStatus[1]);
                throw new SynchronizationException("Problem occured, during synchronization process. Check Database Consistency and local file priviledges.", e);
            }
            try {
                BootstrapLogger.log(" * Synchronizing binaries... ");
                int downloadCount = 0;
                int deleteCount = 0;
                t1 = System.currentTimeMillis();
                if (binFCR.isChanged()) {
                    ArrayEnumeration downloadEnum = binFCR.getFilesForDownload();
                    this.createIndexFolders(binFCR.getNewFolders(), localBinPath);
                    downloadCount = this.synchIndexChangedFiles(downloadEnum, node.elementType + this.separator + BINARIES_VERSION_KEY, localBinPath, false);
                    ArrayEnumeration deleteEnum = binFCR.getDeletedEntries();
                    deleteCount = this.deleteIndexEntries(deleteEnum, localBinPath);
                    if (downloadEnum.size() == downloadCount && deleteEnum.size() == deleteCount) {
                        node.localVersionFile.setIndex(this.dbVersionFile.getIndex(BINARIES_VERSION_KEY));
                    }
                }
                t2 = System.currentTimeMillis();
                BootstrapLogger.log(this.downloadStatus[0] + " synched: " + downloadCount + " file(s); deleted: " + deleteCount + " file(s) (" + (t2 - t1) + " ms)");
                if (!node.localVersionFile.isChanged()) break block22;
                try {
                    node.localVersionFile.writeData();
                }
                catch (IOException e) {
                    throw new SynchronizationException("Error writing local version file. Check priviledges!", e);
                }
            }
            catch (Exception e) {
                BootstrapLogger.log(this.downloadStatus[1]);
                throw new SynchronizationException("Unable to synchronize binaries from the Database! Check consistency!", e);
            }
        }
        try {
            BootstrapLogger.log(" * Synchronizing additional files... ");
            boolean mente = false;
            t1 = System.currentTimeMillis();
            try {
                this.synch.synchronizeFile("", "version.txt", node.elementLocalHome);
            }
            catch (Exception e) {
                BootstrapLogger.logThrowable(e);
                mente = true;
            }
            try {
                this.synch.synchronizeFile("", ".hotspot_compiler", node.elementLocalHome);
            }
            catch (Exception e) {
                mente = true;
            }
            if (node.elementType.equalsIgnoreCase("server")) {
                try {
                    this.getBinaries(node.elementType + this.separator + "META-INF", node.elementLocalHome + this.separator + "META-INF", false, true);
                }
                catch (Exception e) {
                    mente = true;
                }
            }
            this.getBinaries(node.elementType, node.elementLocalHome, false, false);
            t2 = System.currentTimeMillis();
            if (!mente) {
                BootstrapLogger.log(this.downloadStatus[0] + " (" + (t2 - t1) + " ms)");
            } else {
                BootstrapLogger.log(this.downloadStatus[1]);
            }
        }
        catch (Exception e) {
            BootstrapLogger.logThrowable(e);
            BootstrapLogger.log(this.downloadStatus[1]);
        }
        try {
            BootstrapLogger.log(" * Synchronizing DTD files... ");
            t1 = System.currentTimeMillis();
            this.getBinaries(node.elementType + this.separator + "dtd", node.elementLocalHome + this.separator + "dtd", true, true);
            t2 = System.currentTimeMillis();
            BootstrapLogger.log(this.downloadStatus[0] + " (" + (t2 - t1) + " ms)");
        }
        catch (Exception e) {
            BootstrapLogger.logThrowable(this.downloadStatus[1], (Throwable)e);
        }
        BootstrapLogger.log("Done!");
    }

    /*
     * WARNING - void declaration
     */
    private int getOSDependentFiles(String elementOSname, String elementOSbitlength, String elementOSunicode, String localOSLibsHome) throws Exception {
        Exception toThrow;
        int counter;
        block29: {
            DescriptorEntry obj;
            DescriptorParser parser = new DescriptorParser(this.synch.getStreamToFile(NATIVE_VERSION_KEY, "native.descriptor"), 6);
            ArrayList<File> natives = new ArrayList<File>();
            counter = 0;
            toThrow = null;
            new File(localOSLibsHome).mkdirs();
            while ((obj = parser.getNextEntry()) != null) {
                Object var16_19;
                void var6_9;
                try {
                    if (elementOSname.equalsIgnoreCase(var6_9.getNextValue()) && elementOSbitlength.equalsIgnoreCase(var6_9.getNextValue()) && elementOSunicode.equalsIgnoreCase(var6_9.getNextValue())) {
                        int usages = Integer.parseInt(var6_9.getNextValue());
                        String path = var6_9.getNextValue();
                        String filename = var6_9.getNextValue();
                        if (usages > 0) {
                            try {
                                this.synch.synchronizeFile(path, filename, localOSLibsHome);
                                ++counter;
                                natives.add(new File(localOSLibsHome + File.separatorChar + filename));
                            }
                            catch (NameNotFoundException nnfe) {
                                BootstrapLogger.log("Native file is missing [" + filename + "].");
                            }
                            catch (Exception e) {
                                toThrow = e;
                            }
                        } else if (new File(localOSLibsHome + this.separator + filename).delete()) {
                            BootstrapLogger.log("Deleted native file [" + filename + "].");
                        } else {
                            BootstrapLogger.log("Error deleting native file [" + filename + "].");
                        }
                    }
                    var16_19 = null;
                    parser.releaseEntry((DescriptorEntry)var6_9);
                }
                catch (Throwable throwable) {
                    var16_19 = null;
                    parser.releaseEntry((DescriptorEntry)var6_9);
                    throw throwable;
                }
            }
            if (counter > 0) {
                if (elementOSname.startsWith("as400_")) {
                    File f = null;
                    CountDown cd = new CountDown(counter);
                    int i = 0;
                    while (i < counter) {
                        f = (File)natives.get(i);
                        if (f.exists()) {
                            HandlerExecutor chmod = new HandlerExecutor((Runnable)new ISeriesNativeHandler(localOSLibsHome, f.getAbsolutePath()), cd);
                            chmod.start();
                        } else {
                            cd.release();
                        }
                        ++i;
                    }
                    try {
                        if (!cd.attempt(10000L)) {
                            BootstrapLogger.log("Warning: Some external processes did not finish after 10000 msecs...");
                            break block29;
                        }
                        BootstrapLogger.log("All external processes finished successfully...");
                    }
                    catch (InterruptedException e) {
                        BootstrapLogger.log("Warning: Waiting for external processes interrupted...");
                    }
                } else if (!elementOSname.toUpperCase().startsWith("NT")) {
                    File f = null;
                    CountDown cd = new CountDown(counter);
                    int i = 0;
                    while (i < counter) {
                        f = (File)natives.get(i);
                        if (f.exists()) {
                            HandlerExecutor chmod = new HandlerExecutor((Runnable)new LinuxNativeHandler(f, "755"), cd);
                            chmod.start();
                        } else {
                            cd.release();
                        }
                        ++i;
                    }
                    try {
                        if (!cd.attempt(10000L)) {
                            BootstrapLogger.log("Warning: Some CHMOD processes did not finish after 10000 msecs...");
                        } else {
                            BootstrapLogger.log("All CHMOD commands finished successfully...");
                        }
                    }
                    catch (InterruptedException e) {
                        BootstrapLogger.log("Warning: Waiting for the CHMOD processes interrupted...");
                    }
                }
            }
        }
        if (toThrow == null) {
            return counter;
        }
        throw toThrow;
    }

    private void getProperties(String dbCfg1, String dbCfg2, String path, boolean delete) throws Exception {
        File localFile = new File(path);
        if (delete && localFile.exists() && !FileUtils.deleteDirectory((File)localFile)) {
            BootstrapLogger.log("Warning: Folder [" + path + "] can't be deleted! Check sharing violation.");
        }
        if (!this.checkFolder(path)) {
            localFile.mkdirs();
            if (!this.checkFolder(path)) {
                throw new IOException("Error crating folder [" + path + "]. Check permitions!");
            }
        }
        this.synch.synchronizeProperties(dbCfg1, dbCfg2, localFile);
    }

    private int synchIndexChangedFiles(ArrayEnumeration arrayEnumeration, String dbCfg, String localPath, boolean createFolders) {
        int count = 0;
        while (arrayEnumeration.hasNext()) {
            String entry = (String)arrayEnumeration.next();
            try {
                this.synch.synchronizeFile(dbCfg + entry, localPath + entry, createFolders);
                ++count;
            }
            catch (IOException ioe) {
                BootstrapLogger.logThrowable("ERROR: Writing file [" + localPath + entry + "]!", (Throwable)ioe);
                new File(localPath + entry).delete();
            }
            catch (Exception e) {
                BootstrapLogger.logThrowable("Warning: File [" + entry + "] not found in [" + dbCfg + entry + "], but present in the DB Index!", (Throwable)e);
            }
        }
        return count;
    }

    private void createIndexFolders(ArrayEnumeration arrayEnumeration, String localPath) throws IOException {
        while (arrayEnumeration.hasNext()) {
            String filename = (String)arrayEnumeration.next();
            File f = new File(localPath + filename);
            if (f.mkdirs()) continue;
            if (!f.exists()) {
                throw new IOException("Error creating folder [" + localPath + filename + "]. Check permitions!");
            }
            BootstrapLogger.log("Warning: Folder [" + localPath + filename + "] already exists, but not present in the local Index.");
        }
    }

    private int deleteIndexEntries(ArrayEnumeration arrayEnumeration, String localPath) {
        int count = 0;
        while (arrayEnumeration.hasNext()) {
            String filename = (String)arrayEnumeration.next();
            BootstrapLogger.log("Deleting file [" + localPath + filename + "] ... ");
            File victim = new File(localPath + filename);
            if (victim.exists() && !victim.delete()) {
                BootstrapLogger.log("Failed! (ACCESS DENIED!)");
                continue;
            }
            ++count;
            BootstrapLogger.log("Done!");
        }
        return count;
    }

    private int deleteBootstrapEntries(ArrayEnumeration arrayEnumeration, String localPath) {
        int count = 0;
        while (arrayEnumeration.hasNext()) {
            String filename = (String)arrayEnumeration.next();
            BootstrapLogger.log("Deleting file [" + localPath + filename + "] ... ");
            if (filename.endsWith("bootstrap.properties") || filename.endsWith(".log")) {
                ++count;
                BootstrapLogger.log("Skipped!");
                continue;
            }
            File victim = new File(localPath + filename);
            if (victim.exists() && !victim.delete()) {
                BootstrapLogger.log("Failed! (ACCESS DENIED!)");
                continue;
            }
            ++count;
            BootstrapLogger.log("Done!");
        }
        return count;
    }

    private void getBinaries(String dbCfg, String path, boolean recursive, boolean deleteLocal) throws Exception {
        File localFile = new File(path);
        if (deleteLocal && localFile.exists() && !FileUtils.deleteDirectory((File)localFile)) {
            BootstrapLogger.log("Warning: Folder [" + path + "] can't be deleted! Check sharing violation.");
        }
        if (!this.checkFolder(path)) {
            localFile.mkdirs();
        }
        this.synch.synchronizeBinaries(dbCfg, localFile, recursive);
    }

    public static void log(String message) {
        BootstrapLogger.log("[Bootstrap module]> " + message);
    }

    public static void halt(String message) {
        BootstrapLogger.log("[Bootstrap module]> " + message);
        System.exit(66);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Bootstrap.halt("Bootstrap must be called through the Startup Framework with the appropriate parameters!!!");
        } else {
            try {
                BootstrapLogger.init(args[0]);
                BootstrapLogger.log(START_DELIMITER_LINE);
                byte bootstrapMode = Bootstrap.getNodeFromParameter(args[0]);
                long l1 = System.currentTimeMillis();
                Bootstrap module = new Bootstrap(args[0], bootstrapMode);
                module.makeUpdate(bootstrapMode);
                long l2 = System.currentTimeMillis();
                BootstrapLogger.log("Synch time: " + (l2 - l1) + " ms");
            }
            catch (Throwable e) {
                BootstrapLogger.logThrowable(e);
                Bootstrap.halt("Problem occured while performing synchronization.");
            }
            System.exit(0);
        }
    }

    private void makeUpdate(byte bootstrapMode) throws SynchronizationException {
        if (this.elementResynch == 0) {
            BootstrapLogger.log("* Synchronization aborted (check [element.resynch] property in the bootstrap.properties file");
        } else if (bootstrapMode == 2 || bootstrapMode == 1) {
            this.synchInstanceGlobals(this.clusterElementID);
        } else {
            NodeData node = this.getElementData(this.clusterElementID, false);
            this.synchronize(node);
        }
    }

    private static byte getNodeFromParameter(String param) {
        if (param.length() == 9) {
            return 2;
        }
        if (param.length() == 11) {
            return 3;
        }
        if (param.compareToIgnoreCase("NATIVE") == 0) {
            return 1;
        }
        return 0;
    }
}

