/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.unitteststudio.view;

import com.sap.netweaver.ep.core.preferences.IServerConfig;
import com.sap.netweaver.ide.helpers.connection.ConnectionParameters;
import com.sap.netweaver.ide.uts.model.ITSData;
import com.sap.netweaver.ide.uts.model.ITSDataViewer;
import com.sap.netweaver.ide.uts.model.TestSuite;
import com.sap.portal.unitteststudio.controller.Controller;
import com.sap.portal.unitteststudio.controller.Session;
import com.sap.portal.unitteststudio.helpers.UIHelpers;
import com.sap.portal.unitteststudio.view.AuthenticationDialog;
import com.sap.portal.unitteststudio.view.ProcessObserver;
import com.sap.portal.unitteststudio.view.TRViewPart;
import com.sap.portal.unitteststudio.view.TSCreationProcess;
import com.sap.portal.unitteststudio.view.TSExecutionProcess;
import java.io.File;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class TSViewPart
extends ViewPart
implements ITSDataViewer {
    private static final String NOTHING_TO_SHOW_LABEL = "Nothing to show ... please load a test suite.  ";
    private static final String DESELECTALL_BUTTON = "Deselect all";
    private static final String SELECT_ALL_BUTTON = "Select all";
    private static final String RUN_BUTTON = "Run";
    private static final String SAVEAS_BUTTON = "Save as";
    private static final String LOAD_BUTTON = "Load";
    private static final String NEW_BUTTON = "New";
    private static final String APPLICATIONS_LABEL = "Testable applications: ";
    private static final String SERVER_CONFIG_GROUP_LABEL = "Server Config";
    private static final String SERVER_LABEL = "Server: ";
    private static final String HOST_LABEL = "Host: ";
    private static final String PORT_LABEL = "Port: ";
    private static final String TESTSUITE_LABEL = "TestSuite: ";
    private static final String CURRENT_NONE = "<none>";
    private Composite mm_parent = null;
    private TableViewer mm_tableViewer = null;
    private Text mm_testSuiteName = null;
    private ProgressBar mm_progressBar;

    public void createPartControl(Composite parent) {
        String path = Controller.getRuntimeEnvironment().getIconResourcePath();
        this.mm_parent = parent;
        parent.setLayoutData((Object)new GridData(1792));
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        parent.setForeground(Display.getCurrent().getSystemColor(1));
        this.createHeader();
        this.createTable();
        this.createActionBar();
        this.refresh();
    }

    public void createHeader() {
        Composite composite = new Composite(this.mm_parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 33);
        label.setText(TESTSUITE_LABEL);
        label.setLayoutData((Object)new GridData(32));
        this.mm_testSuiteName = new Text(composite, 2060);
        this.mm_testSuiteName.setText(CURRENT_NONE);
        this.mm_testSuiteName.setLayoutData((Object)new GridData(768));
        this.createToolBar();
        Label separator = new Label(this.mm_parent, 258);
        separator.setLayoutData((Object)new GridData(256));
    }

    public void createProgressBar(Composite parent) {
        this.mm_progressBar = new ProgressBar(parent, 2);
        this.mm_progressBar.setLayoutData((Object)new GridData(128));
        this.mm_progressBar.setVisible(false);
    }

    public void createTable() {
        Label label = new Label(this.mm_parent, 33);
        label.setText(APPLICATIONS_LABEL);
        label.setLayoutData((Object)new GridData(32));
        GridData data = new GridData(1808);
        this.mm_tableViewer = new TableViewer(this.mm_parent, 2848);
        Table table = this.mm_tableViewer.getTable();
        table.setLayoutData((Object)data);
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem itemChanged;
                Object o;
                if (event.detail == 32 && (o = (itemChanged = (TableItem)event.item).getData()) != null && o instanceof ITSData) {
                    boolean selected = itemChanged.getChecked();
                    ((ITSData)o).setSelected(selected);
                }
            }
        });
    }

    void createToolBar() {
        Composite toolbar = new Composite(this.mm_parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        GridData data = new GridData(776);
        toolbar.setLayoutData((Object)data);
        toolbar.setLayout((Layout)layout);
        this.createNewButton(toolbar);
        this.createLoadButton(toolbar);
        this.createSaveAsButton(toolbar);
        this.createRunButton(toolbar);
    }

    void createActionBar() {
        Composite toolbar = new Composite(this.mm_parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 8;
        GridData data = new GridData(776);
        toolbar.setLayoutData((Object)data);
        toolbar.setLayout((Layout)layout);
        this.createSelectAllButton(toolbar);
        this.createDeselectAllButton(toolbar);
        this.createProgressBar(toolbar);
    }

    void createNewButton(Composite toolbar) {
        Button loadButton = new Button(toolbar, 8);
        loadButton.setText(NEW_BUTTON);
        GridData data = new GridData(256);
        data.horizontalSpan = 1;
        loadButton.setLayoutData((Object)data);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TSViewPart.this.createTestsuite();
            }
        });
    }

    void createLoadButton(Composite toolbar) {
        Button loadButton = new Button(toolbar, 8);
        loadButton.setText(LOAD_BUTTON);
        GridData data = new GridData(256);
        data.horizontalSpan = 1;
        loadButton.setLayoutData((Object)data);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = Controller.getRuntimeEnvironment().getTestSuiteResourcePath();
                File result = UIHelpers.handleBrowse(TSViewPart.this.mm_parent, 4100, path, null, Controller.TESTSUITE_BROWSE_EXTENSIONS);
                if (result != null) {
                    TestSuite testSuite = TestSuite.loadTestSuite((File)result);
                    Controller.getInstance().getSession().setTestSuite(result, testSuite);
                    TSViewPart.this.refresh();
                }
            }
        });
    }

    void createSaveAsButton(Composite toolbar) {
        Button loadButton = new Button(toolbar, 8);
        loadButton.setText(SAVEAS_BUTTON);
        GridData data = new GridData(256);
        data.horizontalSpan = 1;
        loadButton.setLayoutData((Object)data);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Session session = Controller.getInstance().getSession();
                TestSuite testSuite = session.getTestSuite();
                File testSuiteFile = session.getTestSuiteFile();
                if (testSuite != null) {
                    File result;
                    if (testSuiteFile != null) {
                        result = UIHelpers.handleBrowse(TSViewPart.this.mm_parent, 8196, testSuiteFile, Controller.TESTSUITE_BROWSE_EXTENSIONS);
                    } else {
                        String path = Controller.getRuntimeEnvironment().getTestSuiteResourcePath();
                        result = UIHelpers.handleBrowse(TSViewPart.this.mm_parent, 8196, path, null, Controller.TESTSUITE_BROWSE_EXTENSIONS);
                    }
                    if (result != null) {
                        testSuite.saveAs(result);
                        session.setTestSuite(result, testSuite);
                        TSViewPart.this.refresh();
                    }
                }
            }
        });
    }

    void createRunButton(Composite toolbar) {
        Button loadButton = new Button(toolbar, 8);
        loadButton.setText(RUN_BUTTON);
        GridData data = new GridData(256);
        data.horizontalSpan = 1;
        loadButton.setLayoutData((Object)data);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TSViewPart.this.executeTestsuite();
            }
        });
    }

    void createSelectAllButton(Composite toolbar) {
        Button loadButton = new Button(toolbar, 8);
        loadButton.setText(SELECT_ALL_BUTTON);
        GridData data = new GridData(256);
        data.horizontalSpan = 1;
        loadButton.setLayoutData((Object)data);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Session session = Controller.getInstance().getSession();
                TestSuite testsuite = session.getTestSuite();
                if (testsuite != null) {
                    testsuite.selectAllApplications();
                }
                if (session.getTestSuiteFile() != null) {
                    testsuite.saveAs(session.getTestSuiteFile());
                }
                TSViewPart.this.refresh();
            }
        });
    }

    void createDeselectAllButton(Composite toolbar) {
        Button loadButton = new Button(toolbar, 8);
        loadButton.setText(DESELECTALL_BUTTON);
        GridData data = new GridData(256);
        data.horizontalSpan = 1;
        loadButton.setLayoutData((Object)data);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Session session = Controller.getInstance().getSession();
                TestSuite testsuite = session.getTestSuite();
                if (testsuite != null) {
                    testsuite.deselectAllApplications();
                }
                if (session.getTestSuiteFile() != null) {
                    testsuite.saveAs(session.getTestSuiteFile());
                }
                TSViewPart.this.refresh();
            }
        });
    }

    public void refresh() {
        Session session = Controller.getInstance().getSession();
        if (session.getTestSuiteFile() != null) {
            this.mm_testSuiteName.setText(session.getTestSuiteFile().getName());
        }
        Table table = this.mm_tableViewer.getTable();
        table.removeAll();
        TestSuite testSuite = session.getTestSuite();
        if (testSuite == null) {
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{NOTHING_TO_SHOW_LABEL});
            item.setForeground(Display.getDefault().getSystemColor(9));
        } else {
            this.showResult(table, testSuite);
        }
        GridData data = new GridData(1808);
        this.mm_tableViewer.getTable().setLayoutData((Object)data);
        int i = 0;
        while (i < this.mm_tableViewer.getTable().getColumnCount()) {
            this.mm_tableViewer.getTable().getColumn(i).pack();
            ++i;
        }
    }

    public void showResult(Table table, TestSuite testSuite) {
        testSuite.dumpResultsTo((ITSDataViewer)this);
        if (table.getItemCount() == 0) {
            UIHelpers.messageBoxError((Composite)this.mm_parent.getShell(), "TestSuite creation", "Sorry but this server does not contain any 'testable' portal applications.\nPlease upload some PAR files and try again.");
        }
    }

    public void setFocus() {
    }

    public boolean addLine(ITSData data) {
        Table table = this.mm_tableViewer.getTable();
        TableItem item = new TableItem(table, 0);
        item.setText(data.convDataToStringArray());
        item.setData((Object)data);
        item.setChecked(data.isSelected());
        return true;
    }

    public void createTestsuite() {
        IServerConfig serverConfig = AuthenticationDialog.open();
        if (serverConfig != null) {
            this.testSuiteCreation_BEGIN();
            ConnectionParameters cp = new ConnectionParameters(serverConfig.getHost(), serverConfig.getPort(), serverConfig.getLogin(), serverConfig.getPassword());
            TSCreationProcess process = new TSCreationProcess(new CreationProcessObserver(), cp);
            process.start();
        }
    }

    void testSuiteCreation_BEGIN() {
        this.mm_progressBar.setVisible(true);
    }

    void testSuiteCreation_END() {
        this.mm_progressBar.setVisible(false);
        this.refresh();
    }

    public void executeTestsuite() {
        IServerConfig serverConfig = AuthenticationDialog.open();
        if (serverConfig != null) {
            this.testSuiteExecution_BEGIN();
            ConnectionParameters cp = new ConnectionParameters(serverConfig.getHost(), serverConfig.getPort(), serverConfig.getLogin(), serverConfig.getPassword());
            TSExecutionProcess process = new TSExecutionProcess(new ExecutionProcessObserver(), cp);
            process.start();
        }
    }

    void testSuiteExecution_BEGIN() {
        this.mm_progressBar.setVisible(true);
    }

    void testSuiteExecution_END() {
        this.mm_progressBar.setVisible(false);
        TRViewPart trviewpart = (TRViewPart)((Object)Controller.getRuntimeEnvironment().getViewPart("com.sap.portal.unitteststudio.view.TRViewPart"));
        trviewpart.refresh();
    }

    class ExecutionProcessObserver
    extends ProcessObserver {
        ExecutionProcessObserver() {
        }

        public void run() {
            this.handleProcessResult(TSViewPart.this.mm_parent, "TestSuite execution");
            TSViewPart.this.testSuiteExecution_END();
        }
    }

    class CreationProcessObserver
    extends ProcessObserver {
        private Exception mm_exception;

        CreationProcessObserver() {
        }

        public void run() {
            this.handleProcessResult(TSViewPart.this.mm_parent, "TestSuite creation");
            TSViewPart.this.testSuiteCreation_END();
        }
    }
}

