/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.unitteststudio.view;

import com.sap.netweaver.ide.helpers.connection.Connection;
import com.sap.netweaver.ide.helpers.connection.ConnectionParameters;
import com.sap.netweaver.ide.uts.model.TestResult;
import com.sap.netweaver.ide.uts.model.TestSuite;
import com.sap.portal.unitteststudio.controller.Controller;
import com.sap.portal.unitteststudio.controller.Session;
import com.sap.portal.unitteststudio.view.IProcessObserver;
import java.io.File;
import java.util.Date;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;

public class TSExecutionProcess
extends Thread {
    private IProcessObserver mm_observer;
    ConnectionParameters mm_connectionParameters;

    public TSExecutionProcess(IProcessObserver observer, ConnectionParameters connectionParameters) {
        this.mm_observer = observer;
        this.mm_connectionParameters = connectionParameters;
    }

    public void run() {
        try {
            this.doIt();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Display display = Display.getDefault();
            display.asyncExec((Runnable)this.mm_observer);
            throw throwable;
        }
        Display display = Display.getDefault();
        display.asyncExec((Runnable)this.mm_observer);
    }

    private void doIt() {
        Session session = Controller.getInstance().getSession();
        TestSuite testSuite = session.getTestSuite();
        if (testSuite != null) {
            if (session.getTestSuiteFile() != null) {
                testSuite.saveAs(session.getTestSuiteFile());
            }
            session.setConnectionParameters(this.mm_connectionParameters);
            Document document = null;
            try {
                document = Connection.connectAndExecuteTestSuite((ConnectionParameters)session.getConnectionParameters(), (TestSuite)testSuite);
            }
            catch (Exception e) {
                this.mm_observer.setException(e);
            }
            if (document != null) {
                TestResult result = TestResult.loadTestResult((Document)document);
                File dest = new File(Controller.getRuntimeEnvironment().getResultResourcePath());
                dest = new File(dest, "result_" + Controller.TIMESTAMP_FORMAT.format(new Date()) + Controller.TESTRESULT_EXTENSION);
                result.saveAs(dest);
                session.setTestResult(dest, result);
            } else {
                session.setTestResult(null, null);
            }
        }
    }
}

