/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.unitteststudio.view;

import com.sap.netweaver.ide.uts.model.ITRData;
import com.sap.netweaver.ide.uts.model.ITRDataViewer;
import com.sap.netweaver.ide.uts.model.ITRMethodData;
import com.sap.netweaver.ide.uts.model.TestResult;
import com.sap.portal.unitteststudio.controller.Controller;
import com.sap.portal.unitteststudio.controller.Session;
import com.sap.portal.unitteststudio.helpers.UIHelpers;
import com.sap.portal.unitteststudio.view.HTMLConvertor;
import com.sap.portal.unitteststudio.view.StackViewPart;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;

public class TRViewPart
extends ViewPart
implements ITRDataViewer {
    private static final String COMPONENT_TYPE = "COMPONENT";
    private static final String NOTHING_TO_SHOW_LABEL = "No test result ... please load and run a test suite.  ";
    private static final String SHOW_STACKTRACE_MENUITEM = "Show Stacktrace";
    private static final String OPEN_JAVA_CLASS_ITEM = "Open Java Class";
    private static final String FILTER_DEFAULT_ITEM = "Filter: default";
    private static final String FILTER_SHOW_ALL_ITEM = "Filter: Show All";
    private static final String GENERATE_HTML_BUUTON = "Generate HTML Report";
    private static final String SAVEAS_BUTTON = "Save as";
    private static final String LOAD_BUTTON = "Load Result";
    private static final String SUMMARY_GROUP_LABEL = "Summary";
    private static final String TESTRESULT_GROUP_LABEL = "Test Result";
    private static final String CURRENT_NONE = "<none>";
    Image mm_imageFailed;
    Image mm_imageSucceded;
    Image mm_imageRedline;
    private Composite mm_parent = null;
    private TableViewer mm_tableViewer = null;
    private Text mm_testResultName = null;
    private Label mm_nbComponents;
    private Label mm_nbComponentWithErrors;
    private Label mm_nbTestCases;
    private Label mm_nbSuccesses;
    private Label mm_nbFailures;
    private Label mm_nbExceptions;
    private int mm_filterMode = 0;

    public void createPartControl(Composite parent) {
        String path = Controller.getRuntimeEnvironment().getIconResourcePath();
        this.mm_imageFailed = new Image((Device)Display.getCurrent(), path + File.separator + "failure.gif");
        this.mm_imageSucceded = new Image((Device)Display.getCurrent(), path + File.separator + "success.gif");
        this.mm_imageRedline = new Image((Device)Display.getCurrent(), path + File.separator + "redline.gif");
        this.mm_parent = parent;
        parent.setLayoutData((Object)new GridData(1792));
        parent.setLayout((Layout)new GridLayout());
        parent.setForeground(Display.getCurrent().getSystemColor(1));
        this.createHeader(this.mm_parent);
        Label separator = new Label(this.mm_parent, 258);
        separator.setLayoutData((Object)new GridData(256));
        this.createTable();
        this.refresh();
    }

    public void createHeader(Composite parent) {
        SashForm header = new SashForm(parent, 256);
        GridLayout layout = new GridLayout();
        header.setLayout((Layout)layout);
        header.setLayoutData((Object)new GridData(768));
        this.fillLeftPart((Composite)header);
        this.fillRightPart((Composite)header);
    }

    public void fillLeftPart(Composite parent) {
        Group group = UIHelpers.newGroup(parent, TESTRESULT_GROUP_LABEL);
        this.mm_testResultName = new Text((Composite)group, 2060);
        this.mm_testResultName.setText(CURRENT_NONE);
        this.mm_testResultName.setLayoutData((Object)new GridData(768));
        this.createToolBar((Composite)group);
    }

    public void fillRightPart(Composite parent) {
        parent = UIHelpers.newGroup(parent, SUMMARY_GROUP_LABEL);
        this.mm_nbComponents = new Label(parent, 33);
        this.mm_nbComponents.setText("Portal components selected: 0");
        this.mm_nbComponents.setLayoutData((Object)new GridData(256));
        this.mm_nbComponentWithErrors = new Label(parent, 33);
        this.mm_nbComponentWithErrors.setText("Portal components with errors: 0");
        this.mm_nbComponentWithErrors.setLayoutData((Object)new GridData(256));
        this.mm_nbTestCases = new Label(parent, 33);
        this.mm_nbTestCases.setText("Number of test-cases: 0");
        this.mm_nbTestCases.setLayoutData((Object)new GridData(256));
        this.mm_nbSuccesses = new Label(parent, 33);
        this.mm_nbSuccesses.setText("#Success: 0");
        this.mm_nbSuccesses.setLayoutData((Object)new GridData(256));
        this.mm_nbFailures = new Label(parent, 33);
        this.mm_nbFailures.setText("#Failure: 0");
        this.mm_nbFailures.setLayoutData((Object)new GridData(256));
        this.mm_nbExceptions = new Label(parent, 33);
        this.mm_nbExceptions.setLayoutData((Object)new GridData(256));
        this.mm_nbExceptions.setText("#Exception: 0");
    }

    public void createTable() {
        GridData data = new GridData(1808);
        this.mm_tableViewer = new TableViewer(this.mm_parent, 67840);
        Table table = this.mm_tableViewer.getTable();
        table.setLayoutData((Object)data);
        this.addColumns(table);
        this.setMenuListener(table);
    }

    public void addColumns(Table table) {
        int c = 15;
        TableColumn col = new TableColumn(table, 16384);
        col.setText("Tests");
        col.setWidth(18 * c);
        col = new TableColumn(table, 0x1000000);
        col.setText("#Success");
        col.setWidth(5 * c);
        col = new TableColumn(table, 0x1000000);
        col.setText("#Failure");
        col.setWidth(5 * c);
        col = new TableColumn(table, 0x1000000);
        col.setText("#Exception");
        col.setWidth(5 * c);
        col = new TableColumn(table, 16384);
        col.setText("Methods");
        col.setWidth(12 * c);
        col = new TableColumn(table, 16384);
        col.setText("Log");
        col.setWidth(20 * c);
        col = new TableColumn(table, 16407);
        col.setText("Id");
        col.setWidth(6 * c);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    void createToolBar(Composite parent) {
        Composite toolbar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 8;
        GridData data = new GridData(776);
        toolbar.setLayoutData((Object)data);
        toolbar.setLayout((Layout)layout);
        this.createLoadButton(toolbar);
        this.createSaveAsButton(toolbar);
        this.createGenerateHtmlReportButton(toolbar);
    }

    void createLoadButton(Composite toolbar) {
        Button loadButton = new Button(toolbar, 8);
        loadButton.setText(LOAD_BUTTON);
        GridData data = new GridData(256);
        data.horizontalSpan = 1;
        loadButton.setLayoutData((Object)data);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File result = UIHelpers.handleBrowse(TRViewPart.this.mm_parent, 4100, Controller.getRuntimeEnvironment().getResultResourcePath(), null, Controller.TESTRESULT_BROWSE_EXTENSIONS);
                if (result != null) {
                    TestResult testResult = TestResult.loadTestResult((File)result);
                    Controller.getInstance().getSession().setTestResult(result, testResult);
                    TRViewPart.this.refresh();
                }
            }
        });
    }

    void createSaveAsButton(Composite toolbar) {
        Button loadButton = new Button(toolbar, 8);
        loadButton.setText(SAVEAS_BUTTON);
        GridData data = new GridData(256);
        data.horizontalSpan = 1;
        loadButton.setLayoutData((Object)data);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Session session = Controller.getInstance().getSession();
                TestResult testResult = session.getTestResult();
                File testResultFile = session.getTestResultFile();
                if (testResult != null) {
                    File result;
                    if (testResultFile != null) {
                        result = UIHelpers.handleBrowse(TRViewPart.this.mm_parent, 8196, testResultFile, Controller.TESTRESULT_BROWSE_EXTENSIONS);
                    } else {
                        String path = Controller.getRuntimeEnvironment().getReferenceResourcePath();
                        result = UIHelpers.handleBrowse(TRViewPart.this.mm_parent, 8196, path, null, Controller.TESTRESULT_BROWSE_EXTENSIONS);
                    }
                    if (result != null) {
                        testResult.saveAs(result);
                        session.setTestResult(result, testResult);
                        TRViewPart.this.refresh();
                    }
                }
            }
        });
    }

    void createGenerateHtmlReportButton(Composite toolbar) {
        Button loadButton = new Button(toolbar, 8);
        loadButton.setText(GENERATE_HTML_BUUTON);
        GridData data = new GridData(256);
        data.horizontalSpan = 1;
        loadButton.setLayoutData((Object)data);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Session session = Controller.getInstance().getSession();
                TestResult testResult = session.getTestResult();
                File testResultFile = session.getTestResultFile();
                if (testResult != null) {
                    File result;
                    if (testResultFile != null) {
                        String path = testResultFile.getAbsolutePath();
                        if (path.endsWith(".xml")) {
                            path = path.substring(0, path.length() - 4) + ".html";
                        }
                        if (path.endsWith(".testresult")) {
                            path = path.substring(0, path.length() - 11) + ".html";
                        }
                        result = UIHelpers.handleBrowse(TRViewPart.this.mm_parent, 8196, new File(path), "*.html");
                    } else {
                        String path = Controller.getRuntimeEnvironment().getReferenceResourcePath();
                        result = UIHelpers.handleBrowse(TRViewPart.this.mm_parent, 8196, path, "result*.html", "*.html");
                    }
                    if (result != null) {
                        HTMLConvertor convertor = new HTMLConvertor();
                        testResult.dumpResultsTo((ITRDataViewer)convertor);
                        String content = convertor.getContent();
                        try {
                            FileWriter reportWriter = new FileWriter(result);
                            reportWriter.write(content);
                            reportWriter.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    protected void setMenuListener(Table table) {
        IMenuListener menuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object o;
                Action action;
                if (TRViewPart.this.mm_filterMode == 0) {
                    action = new Action(this, TRViewPart.FILTER_SHOW_ALL_ITEM){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            TRViewPart.access$102(4.access$200(this.this$1), 1);
                            4.access$200(this.this$1).refresh();
                        }
                    };
                    manager.add((IAction)action);
                } else {
                    action = new Action(this, TRViewPart.FILTER_DEFAULT_ITEM){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            TRViewPart.access$102(4.access$200(this.this$1), 0);
                            4.access$200(this.this$1).refresh();
                        }
                    };
                    manager.add((IAction)action);
                }
                Table table = TRViewPart.this.mm_tableViewer.getTable();
                int index = table.getSelectionIndex();
                TableItem item = null;
                if (index > 0) {
                    try {
                        item = table.getItem(index);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (item != null && (o = item.getData()) instanceof ITRMethodData) {
                    Separator separator = new Separator();
                    manager.add((IContributionItem)separator);
                    ITRMethodData data = (ITRMethodData)o;
                    Action action2 = new Action(this, data, TRViewPart.OPEN_JAVA_CLASS_ITEM){
                        private final /* synthetic */ ITRMethodData val$data;
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$data = val$data;
                        }

                        public void run() {
                            String methodName = this.val$data.getMethodName();
                            if (methodName.indexOf(".") != -1) {
                                TRViewPart.access$400(4.access$200(this.this$1), methodName);
                            }
                        }
                    };
                    manager.add((IAction)action2);
                    separator = new Separator();
                    manager.add((IContributionItem)separator);
                    String stacktrace = data.getException();
                    action2 = new Action(this, data, TRViewPart.SHOW_STACKTRACE_MENUITEM){
                        private final /* synthetic */ ITRMethodData val$data;
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$data = val$data;
                        }

                        public void run() {
                            TRViewPart.access$500(4.access$200(this.this$1), this.val$data, true);
                        }
                    };
                    if (stacktrace == null) {
                        action2.setEnabled(false);
                    }
                    manager.add((IAction)action2);
                }
            }

            static /* synthetic */ TRViewPart access$200(4 x0) {
                return x0.TRViewPart.this;
            }
        };
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(menuListener);
        Menu menu = menuManager.createContextMenu((Control)table);
        this.mm_tableViewer.getTable().setMenu(menu);
    }

    public void refreshCounters(TestResult result) {
        TestResult.Counters counters = result.getCounters();
        if (counters != null) {
            this.mm_nbComponents.setText("Portal components selected: " + counters.getNbComponents());
            this.mm_nbComponentWithErrors.setText("Portal components with errors: " + counters.getNbComponentWithErrors());
            this.mm_nbTestCases.setText("Number of test-cases: " + counters.getNbTestCases());
            this.mm_nbSuccesses.setText("#Success: " + counters.getSuccesses());
            this.mm_nbFailures.setText("#Failure: " + counters.getFailures());
            this.mm_nbExceptions.setText("#Exception: " + counters.getExceptions());
        }
    }

    public void refresh() {
        Session session = Controller.getInstance().getSession();
        if (session.getTestResultFile() == null) {
            this.mm_testResultName.setText(CURRENT_NONE);
        } else {
            this.mm_testResultName.setText(session.getTestResultFile().getName());
        }
        Table table = this.mm_tableViewer.getTable();
        table.removeAll();
        TestResult result = Controller.getInstance().getSession().getTestResult();
        if (result == null) {
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{NOTHING_TO_SHOW_LABEL});
            item.setForeground(Display.getDefault().getSystemColor(9));
        } else {
            this.refreshCounters(result);
            this.showResult(table, result);
        }
        GridData data = new GridData(1808);
        this.mm_tableViewer.getTable().setLayoutData((Object)data);
    }

    public void showResult(Table table, TestResult result) {
        result.dumpResultsTo((ITRDataViewer)this);
    }

    public void setFocus() {
    }

    private boolean isFilteredOut(ITRData data) {
        if (this.mm_filterMode == 1) {
            return false;
        }
        if (COMPONENT_TYPE.equals(data.getType())) {
            return false;
        }
        return data.isSuccess();
    }

    public boolean addLine(ITRData data) {
        if (this.isFilteredOut(data)) {
            return false;
        }
        Table table = this.mm_tableViewer.getTable();
        TableItem item = new TableItem(table, 0);
        item.setText(data.convDataToStringArray());
        item.setData((Object)data);
        int imagePos = 4;
        if (COMPONENT_TYPE.equals(data.getType())) {
            imagePos = 0;
        } else if ("ASSERT".equals(data.getType()) || "VERIFY".equals(data.getType())) {
            imagePos = 5;
        }
        Image image = data.isSuccess() ? this.mm_imageSucceded : (data instanceof ITRMethodData && ((ITRMethodData)data).getException() != null ? this.mm_imageRedline : this.mm_imageFailed);
        item.setImage(imagePos, image);
        return true;
    }

    private void gotoTestCase(String testName) {
        int pos = testName.lastIndexOf(".");
        if (pos != -1) {
            StackViewPart.goToTestMethod(testName.substring(0, pos), testName.substring(pos + 1));
        }
    }

    private void showStacktrace(ITRMethodData data, boolean verbose) {
        try {
            String stacktrace = data.getException();
            String testName = data.getMethodName();
            IViewPart viewPart = (IViewPart)Controller.getRuntimeEnvironment().getViewPart("com.sap.portal.unitteststudio.view.StackViewPart");
            ((StackViewPart)viewPart).showStacktrace(stacktrace, testName, verbose);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ int access$102(TRViewPart x0, int x1) {
        x0.mm_filterMode = x1;
        return x0.mm_filterMode;
    }

    static /* synthetic */ void access$400(TRViewPart x0, String x1) {
        x0.gotoTestCase(x1);
    }

    static /* synthetic */ void access$500(TRViewPart x0, ITRMethodData x1, boolean x2) {
        x0.showStacktrace(x1, x2);
    }
}

