/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.unitteststudio.view;

import com.sap.portal.unitteststudio.controller.Controller;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class StackViewPart
extends ViewPart {
    private Image mm_imageException;
    private Image mm_imageTraceline;
    private Composite mm_parent = null;
    private TableViewer mm_tableViewer = null;
    private String mm_currentStacktrace = null;
    private String mm_currentTestName = null;
    private boolean mm_verbose = false;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;

    public StackViewPart() {
        this.setTitle("Test Results details");
    }

    public void createPartControl(Composite parent) {
        String path = Controller.getRuntimeEnvironment().getIconResourcePath();
        this.mm_imageException = new Image((Device)Display.getCurrent(), path + File.separator + "exception.gif");
        this.mm_imageTraceline = new Image((Device)Display.getCurrent(), path + File.separator + "traceline.gif");
        this.mm_parent = parent;
        parent.setLayoutData((Object)new GridData(1792));
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        parent.setForeground(Display.getCurrent().getSystemColor(1));
        GridData data = new GridData(1808);
        this.mm_tableViewer = new TableViewer(this.mm_parent, 67840);
        this.mm_tableViewer.getTable().setLayoutData((Object)data);
        this.mm_tableViewer.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (StackViewPart.this.mm_tableViewer.getTable().getSelection().length != 0) {
                    StackViewPart.this.goToFile(StackViewPart.this.mm_tableViewer.getTable().getSelection()[0].getText());
                }
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        this.setMenuListener();
    }

    public void setFocus() {
    }

    public void showStacktrace(String stacktrace, String testName, boolean verbose) {
        this.mm_currentStacktrace = stacktrace;
        this.mm_currentTestName = testName;
        this.mm_verbose = verbose;
        this.mm_tableViewer.getTable().removeAll();
        if (this.mm_currentStacktrace != null) {
            this.showFailure();
        } else {
            TableItem item = new TableItem(this.mm_tableViewer.getTable(), 0);
            item.setText("Unit Test Studio - stacktrace not available");
        }
        TableColumn[] cols = this.mm_tableViewer.getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
    }

    protected void setMenuListener() {
        final Table table = this.mm_tableViewer.getTable();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        IMenuListener menuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(this, "Back to UTS Results"){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        2.access$100(this.this$1).goToTRView();
                    }
                };
                manager.add((IAction)action);
                manager.add((IContributionItem)new Separator());
                if (table.getSelectionCount() > 0) {
                    String line = StackViewPart.this.mm_tableViewer.getTable().getSelection()[0].getText();
                    action = new Action(this, line, "Open Java Class"){
                        private final /* synthetic */ String val$line;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$line = val$line;
                        }

                        public void run() {
                            2.access$100(this.this$1).goToFile(this.val$line);
                        }
                    };
                    if (line.indexOf("at ") == -1) {
                        action.setEnabled(false);
                    }
                    manager.add((IAction)action);
                    manager.add((IContributionItem)new Separator());
                    if (StackViewPart.this.mm_verbose) {
                        action = new Action(this, "Show Root Cause Only"){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                StackViewPart.access$202(2.access$100(this.this$1), false);
                                2.access$100(this.this$1).showFailure();
                            }
                        };
                        manager.add((IAction)action);
                    } else {
                        action = new Action(this, "Show Full Stacktrace"){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                StackViewPart.access$202(2.access$100(this.this$1), true);
                                2.access$100(this.this$1).showFailure();
                            }
                        };
                        manager.add((IAction)action);
                    }
                }
            }

            static /* synthetic */ StackViewPart access$100(2 x0) {
                return x0.StackViewPart.this;
            }
        };
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    protected void goToTRView() {
        Controller.getRuntimeEnvironment().getViewPart("com.sap.portal.unitteststudio.view.TRViewPart");
    }

    protected void goToFile(String traceLine) {
        try {
            String testName = traceLine;
            int pos = testName.indexOf("at ");
            if (pos != -1) {
                testName = testName.substring(pos);
                testName = testName.substring(3, testName.indexOf(40)).trim();
                testName = testName.substring(0, testName.lastIndexOf(46));
                String lineNumber = traceLine;
                lineNumber = lineNumber.substring(lineNumber.indexOf(58) + 1, lineNumber.indexOf(")"));
                StackViewPart.goToTest(testName, Integer.valueOf(lineNumber));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void goToTest(String testName, int lineNumber) {
        IType type = null;
        List projects = StackViewPart.getJavaProject();
        int i = 0;
        while (i < projects.size()) {
            IProject project = (IProject)projects.get(i);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            type = StackViewPart.getType(javaProject, testName);
            if (type != null) break;
            ++i;
        }
        if (type != null) {
            ITextEditor textEditor = StackViewPart.openInEditor(type);
            if (textEditor == null) {
                return;
            }
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            try {
                textEditor.selectAndReveal(document.getLineOffset(lineNumber - 1), document.getLineLength(lineNumber - 1));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            StackViewPart.sorry(testName);
        }
    }

    public static void goToTestMethod(String testName, String methodName) {
        IType type = null;
        List projects = StackViewPart.getJavaProject();
        int i = 0;
        while (i < projects.size()) {
            IProject project = (IProject)projects.get(i);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            type = StackViewPart.getType(javaProject, testName);
            if (type != null) break;
            ++i;
        }
        if (type != null) {
            try {
                IMethod[] methods = type.getMethods();
                IMethod method = null;
                int i2 = 0;
                while (i2 < methods.length) {
                    method = methods[i2];
                    if (method.getElementName().equals(methodName)) break;
                    ++i2;
                }
                if (method != null) {
                    ITextEditor textEditor = StackViewPart.openInEditor((IJavaElement)type);
                    if (textEditor == null) {
                        return;
                    }
                    ISourceRange range = method.getNameRange();
                    textEditor.selectAndReveal(range.getOffset(), range.getLength());
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        } else {
            StackViewPart.sorry(testName);
        }
    }

    private static void sorry(String testName) {
        Shell shell = Display.getCurrent().getActiveShell();
        String[] tab = new String[]{"OK"};
        MessageDialog diag = new MessageDialog(shell, "Java class not found", null, "Sorry but UnitTestStudio could not locate the class: " + testName + "." + "\r\n\r\nPlease make sure the corresponding project is open.", 0, tab, 0);
        diag.open();
    }

    public static IType getType(IJavaProject project, String str) {
        if (project == null || str == null) {
            return null;
        }
        String pathStr = str.replace('.', '/') + ".java";
        IJavaElement element = null;
        try {
            element = project.findElement((IPath)new Path(pathStr));
        }
        catch (JavaModelException e) {
            // empty catch block
        }
        IType resType = null;
        if (element instanceof ICompilationUnit) {
            String simpleName = Signature.getSimpleName((String)str);
            resType = ((ICompilationUnit)element).getType(simpleName);
        } else if (element instanceof IClassFile) {
            try {
                resType = ((IClassFile)element).getType();
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        return resType;
    }

    protected void showFailure() {
        Table table = this.mm_tableViewer.getTable();
        table.removeAll();
        String trace = this.mm_currentStacktrace;
        boolean verbose = this.mm_verbose;
        if (!verbose) {
            int pos = trace.lastIndexOf("Caused by:");
            if (pos != -1) {
                trace = trace.substring(pos);
            }
            if ((pos = trace.indexOf("at com.sapportals.portal.prt.test.TestLauncher.processTestMethods")) != -1) {
                trace = trace.substring(0, pos);
            }
        }
        int start = 0;
        int end = trace.indexOf(10, start);
        TableItem tableItem = new TableItem(table, 0);
        String itemLabel = trace.substring(start, end).replace('\t', ' ').replace('\r', ' ').replace('\n', ' ');
        tableItem.setText(itemLabel);
        tableItem.setImage(this.mm_imageException);
        start = end + 1;
        end = trace.indexOf(10, start);
        while (end != -1) {
            tableItem = new TableItem(table, 0);
            itemLabel = trace.substring(start, end).replace('\t', ' ').replace('\r', ' ').replace('\n', ' ');
            tableItem.setText(itemLabel);
            if (itemLabel.indexOf(this.mm_currentTestName) != -1) {
                tableItem.setForeground(Display.getCurrent().getSystemColor(9));
            }
            if (!itemLabel.trim().equals("")) {
                if (itemLabel.trim().startsWith("at ")) {
                    tableItem.setImage(this.mm_imageTraceline);
                } else {
                    tableItem.setImage(this.mm_imageException);
                }
            }
            start = end + 1;
            end = trace.indexOf(10, start);
        }
    }

    protected static ITextEditor openInEditor(IJavaElement javaElement) {
        if (javaElement == null || !javaElement.exists()) {
            Display.getCurrent().beep();
            return null;
        }
        IEditorPart editor = null;
        try {
            editor = EditorUtility.openInEditor((Object)javaElement, (boolean)false);
        }
        catch (CoreException e) {
            return null;
        }
        if (!(editor instanceof ITextEditor)) {
            Display.getCurrent().beep();
            return null;
        }
        return (ITextEditor)editor;
    }

    public static List getJavaProject() {
        ArrayList<IProject> retVal = new ArrayList<IProject>();
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource[] children = root.members();
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                IProject iProject = child instanceof IProject ? (IProject)child : (IProject)child.getAdapter(class$org$eclipse$core$resources$IProject == null ? StackViewPart.class$("org.eclipse.core.resources.IProject") : class$org$eclipse$core$resources$IProject);
                if (iProject != null && iProject.isOpen()) {
                    retVal.add(iProject);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    static /* synthetic */ boolean access$202(StackViewPart x0, boolean x1) {
        x0.mm_verbose = x1;
        return x0.mm_verbose;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

