/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.unitteststudio.view;

import com.sap.netweaver.ide.helpers.connection.ConnectionException;
import com.sap.netweaver.ide.helpers.xml.ProtocolException;
import com.sap.portal.unitteststudio.helpers.UIHelpers;
import com.sap.portal.unitteststudio.view.IProcessObserver;
import org.eclipse.swt.widgets.Composite;

public abstract class ProcessObserver
implements IProcessObserver {
    private Exception mm_exception;

    public Exception getException() {
        return this.mm_exception;
    }

    public void setException(Exception exception) {
        this.mm_exception = exception;
    }

    public void handleProcessResult(Composite parent, String title) {
        Exception e = this.getException();
        if (e != null) {
            e.printStackTrace();
            if (!this.handleException(parent, e, title)) {
                UIHelpers.messageBoxError(parent, title, "Operation failed: " + e.getMessage());
            }
        }
    }

    public boolean handleException(Composite parent, Exception e, String title) {
        if (e != null) {
            ConnectionException ce;
            if (e instanceof ProtocolException) {
                UIHelpers.messageBoxError(parent, title, "Protocol exception: The server is running but the response is not XML-based.\r\n\r\nIt sounds like the authentication failed. Please check your login/password parameters.");
                return true;
            }
            if (e instanceof ConnectionException && (ce = (ConnectionException)e).getResponseCode() == 503) {
                UIHelpers.messageBoxError(parent, title, "Connexion failed: The server is not responding.\r\n\r\nPlease first check the connection parameters :\r\n" + ce.getConnectionParameters() + "\r\n\r\nPlease also make sure the HTTP Proxy setting are correct.");
                return true;
            }
        }
        return false;
    }

    public abstract void run();
}

