/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.unitteststudio.view;

import com.sap.portal.unitteststudio.controller.IRuntimeEnvironment;
import com.sap.portal.unitteststudio.view.StackViewPart;
import com.sap.portal.unitteststudio.view.TRViewPart;
import com.sap.portal.unitteststudio.view.TSViewPart;
import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class FakeRuntimeEnvironment
implements IRuntimeEnvironment {
    private Display mm_display = new Display();
    private TRViewPart mm_testResultView;
    private TSViewPart mm_testSuiteView;
    private StackViewPart mm_stackResultView;

    public FakeRuntimeEnvironment() {
        new File(this.getReferenceResourcePath()).mkdirs();
        new File(this.getResultResourcePath()).mkdirs();
        this.init();
    }

    private void init() {
        new File(this.getTestSuiteResourcePath()).mkdir();
        new File(this.getResultResourcePath()).mkdir();
        new File(this.getReferenceResourcePath()).mkdir();
    }

    public String getRootPath() {
        return "C:\\_\\UTS";
    }

    public String getIconResourcePath() {
        return this.getRootPath() + File.separator + "icons";
    }

    public String getResultResourcePath() {
        return this.getRootPath() + File.separator + "result";
    }

    public String getTestSuiteResourcePath() {
        return this.getRootPath() + File.separator + "testsuite";
    }

    public String getReferenceResourcePath() {
        return this.getRootPath() + File.separator + "reference";
    }

    public Object getViewPart(String viewPartName) {
        if ("com.sap.portal.unitteststudio.view.TRViewPart".equals(viewPartName)) {
            return this.getTRViewPart();
        }
        if ("com.sap.portal.unitteststudio.view.StackViewPart".equals(viewPartName)) {
            return this.getStackViewPart();
        }
        if ("com.sap.portal.unitteststudio.view.TSViewPart".equals(viewPartName)) {
            return this.getTSViewPart();
        }
        return null;
    }

    private IViewPart getTRViewPart() {
        if (this.mm_testResultView == null) {
            Shell shell = new Shell(this.mm_display);
            shell.setSize(1000, 400);
            this.mm_testResultView = new TRViewPart();
            this.mm_testResultView.createPartControl((Composite)shell);
            shell.open();
            while (!shell.isDisposed()) {
                if (this.mm_display.readAndDispatch()) continue;
                this.mm_display.sleep();
            }
            this.mm_display.dispose();
        }
        return this.mm_testResultView;
    }

    private IViewPart getStackViewPart() {
        if (this.mm_stackResultView == null) {
            Shell shell = new Shell(this.mm_display);
            shell.setSize(1000, 400);
            this.mm_stackResultView = new StackViewPart();
            this.mm_stackResultView.createPartControl((Composite)shell);
            shell.open();
            while (!shell.isDisposed()) {
                if (this.mm_display.readAndDispatch()) continue;
                this.mm_display.sleep();
            }
            this.mm_display.dispose();
        }
        return this.mm_stackResultView;
    }

    private IViewPart getTSViewPart() {
        if (this.mm_testSuiteView == null) {
            Shell shell = new Shell(this.mm_display);
            shell.setSize(300, 400);
            this.mm_testSuiteView = new TSViewPart();
            this.mm_testSuiteView.createPartControl((Composite)shell);
            shell.open();
            while (!shell.isDisposed()) {
                if (this.mm_display.readAndDispatch()) continue;
                this.mm_display.sleep();
            }
            this.mm_display.dispose();
        }
        return this.mm_testResultView;
    }
}

