/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.unitteststudio.plugin;

import com.sap.portal.unitteststudio.controller.Controller;
import com.sap.portal.unitteststudio.controller.IRuntimeEnvironment;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UTSPlugin
extends AbstractUIPlugin
implements IStartup,
IRuntimeEnvironment {
    private static UTSPlugin mm_instance;
    private static File mm_root;

    public UTSPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        mm_instance = this;
        mm_root = new File(descriptor.find((IPath)new Path("")).getFile());
        this.init();
        Controller.setRuntimeEnvironment((IRuntimeEnvironment)this);
    }

    private void init() {
        new File(this.getTestSuiteResourcePath()).mkdir();
        new File(this.getResultResourcePath()).mkdir();
        new File(this.getReferenceResourcePath()).mkdir();
    }

    public static UTSPlugin getInstance() {
        return mm_instance;
    }

    public void earlyStartup() {
    }

    public String getRootPath() {
        return mm_root.getAbsolutePath();
    }

    public String getIconResourcePath() {
        return this.getRootPath() + File.separator + "icons";
    }

    public String getResultResourcePath() {
        return this.getRootPath() + File.separator + "result";
    }

    public String getTestSuiteResourcePath() {
        return this.getRootPath() + File.separator + "testsuite";
    }

    public String getReferenceResourcePath() {
        return this.getRootPath() + File.separator + "reference";
    }

    public Object getViewPart(String viewPartName) {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewPartName);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }
}

