/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultView;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ReplaceDialog
extends Dialog {
    private static final int REPLACE_NEXT = 1024;
    private static final int REPLACE = 1025;
    private static final int NEXT = 1026;
    private String fSearchPattern;
    private IWorkbenchWindow fWindow;
    private boolean fAutobuild;
    private boolean fFatalError;
    private Text fTextField;
    private Button fSaveButton;
    private Button fReplaceNextButton;
    private Button fReplaceButton;
    private Button fNextButton;
    private boolean fSaved;
    private ITextEditor fEditor;
    private boolean fCloseEditor;
    private IDocument fDocument;
    private AbstractMarkerAnnotationModel fAnnotationModel;
    private List fElements;
    private int fElementIndex;
    private SearchResultViewEntry fCurrentEntry;
    private List fCurrentMarkers;
    private int fMarkerIndex;
    private IMarker fCurrentMatch;

    protected ReplaceDialog(Shell parentShell, List elements, IWorkbenchWindow window, String searchPattern) {
        super(parentShell);
        Assert.isNotNull((Object)elements);
        Assert.isNotNull((Object)searchPattern);
        this.fElements = new ArrayList(elements);
        Assert.isNotNull((Object)window);
        this.fWindow = window;
        this.fSearchPattern = searchPattern;
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.setText(this.getDialogTitle());
        this.updateButtons();
    }

    public int open() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.fAutobuild = workspace.isAutoBuilding();
        if (this.fAutobuild) {
            IWorkspaceDescription description = workspace.getDescription();
            description.setAutoBuilding(false);
            try {
                workspace.setDescription(description);
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), SearchMessages.getString("ReplaceDialog.error.auto_building"));
                this.fFatalError = true;
            }
        }
        try {
            this.fCurrentMatch = this.getNextMatch(false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), SearchMessages.getString("ReplaceDialog.error.no_matches"));
            this.fFatalError = true;
        }
        catch (MarkerNotPresentableException e) {
            this.handleMarkerNotPresentableException(e);
            this.fFatalError = true;
        }
        return super.open();
    }

    public boolean close() {
        boolean result = super.close();
        this.restoreAutoBuildState();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 2;
        this.initializeDialogUnits((Control)result);
        Label label = new Label(result, 0);
        label.setText(SearchMessages.getString("ReplaceDialog.replace_label"));
        CLabel clabel = new CLabel(result, 0);
        clabel.setText(this.fSearchPattern);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        clabel.setLayoutData((Object)gd);
        label = new Label(result, 0);
        label.setText(SearchMessages.getString("ReplaceDialog.with_label"));
        this.fTextField = new Text(result, 2048);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fTextField.setLayoutData((Object)gd);
        this.fTextField.setFocus();
        this.fSaveButton = new Button(result, 32);
        this.fSaveButton.setText(SearchMessages.getString("ReplaceDialog.save_changes"));
        this.fSaveButton.setSelection(true);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fSaveButton.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fReplaceNextButton = this.createButton(parent, 1024, SearchMessages.getString("ReplaceDialog.replace_next"), false);
        this.fReplaceButton = this.createButton(parent, 1025, SearchMessages.getString("ReplaceDialog.replace"), false);
        this.fNextButton = this.createButton(parent, 1026, SearchMessages.getString("ReplaceDialog.next"), false);
        this.createButton(parent, 1, SearchMessages.getString("ReplaceDialog.close"), false);
    }

    protected Point getInitialLocation(Point initialSize) {
        SearchResultView view = (SearchResultView)SearchPlugin.getSearchResultView();
        if (view == null) {
            return super.getInitialLocation(initialSize);
        }
        Point result = new Point(0, 0);
        Control control = view.getViewer().getControl();
        Point size = control.getSize();
        Point location = control.toDisplay(control.getLocation());
        result.x = Math.max(0, location.x + size.x - initialSize.x);
        result.y = Math.max(0, location.y + size.y - initialSize.y);
        return result;
    }

    protected void buttonPressed(int buttonId) {
        try {
            boolean save = this.fSaveButton.getSelection();
            String text = this.fTextField.getText();
            switch (buttonId) {
                case 1024: {
                    this.replace(this.fCurrentMatch, text, save);
                    this.fCurrentMatch = this.getNextMatch(save);
                    break;
                }
                case 1025: {
                    this.replace(this.fCurrentMatch, text, save);
                    this.fCurrentMatch = null;
                    break;
                }
                case 1026: {
                    this.fCurrentMatch = this.getNextMatch(save);
                    break;
                }
                case 1: {
                    this.saveEditor(save);
                }
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), SearchMessages.getString("ReplaceDialog.error.unexpected_exception"));
            this.fFatalError = true;
        }
        catch (BadLocationException badLocationException) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)SearchMessages.getString("ReplaceDialog.error.different_content"));
            this.fFatalError = true;
        }
        catch (MarkerNotPresentableException e) {
            this.handleMarkerNotPresentableException(e);
            this.fFatalError = true;
        }
        this.updateButtons();
        super.buttonPressed(buttonId);
    }

    private void replace(IMarker source, String text, boolean save) throws CoreException, BadLocationException {
        Position position = this.fAnnotationModel.getMarkerPosition(source);
        this.fDocument.replace(position.getOffset(), position.getLength(), text);
        SearchPlugin.getWorkspace().deleteMarkers(new IMarker[]{source});
    }

    private boolean hasNextMatch() {
        if (this.fCurrentMarkers != null) {
            return true;
        }
        return this.fElementIndex < this.fElements.size();
    }

    private IMarker getNextMatch(boolean save) throws CoreException, MarkerNotPresentableException {
        if (this.fCurrentMarkers == null) {
            if (this.fElementIndex >= this.fElements.size()) {
                return null;
            }
            this.saveEditor(save);
            this.fCurrentEntry = (SearchResultViewEntry)this.fElements.get(this.fElementIndex++);
            this.fCurrentMarkers = new ArrayList(this.fCurrentEntry.getMarkers());
            this.fMarkerIndex = 0;
        }
        IMarker result = (IMarker)this.fCurrentMarkers.get(this.fMarkerIndex);
        if (this.fEditor == null) {
            IWorkbenchPage activePage = this.fWindow.getActivePage();
            int openEditors = activePage.getEditorReferences().length;
            this.fEditor = this.openFile(result, activePage);
            this.fEditor.gotoMarker(result);
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            IEditorInput input = this.fEditor.getEditorInput();
            this.fDocument = provider.getDocument((Object)input);
            this.fAnnotationModel = (AbstractMarkerAnnotationModel)provider.getAnnotationModel((Object)input);
            this.fCloseEditor = openEditors < activePage.getEditorReferences().length;
        } else {
            this.fEditor.gotoMarker(result);
        }
        if (this.fMarkerIndex == this.fCurrentMarkers.size() - 1) {
            this.fCurrentMarkers = null;
        } else {
            ++this.fMarkerIndex;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ITextEditor openFile(IMarker marker, IWorkbenchPage activePage) throws MarkerNotPresentableException, PartInitException {
        ITextEditor iTextEditor;
        IFile markerFile;
        IFile iFile = markerFile = marker.getResource() instanceof IFile ? (IFile)marker.getResource() : null;
        if (markerFile == null) {
            throw new MarkerNotPresentableException(null);
        }
        String currentEditorId = null;
        IEditorRegistry editorRegistry = SearchPlugin.getDefault().getWorkbench().getEditorRegistry();
        IEditorDescriptor desc = editorRegistry.getDefaultEditor(markerFile);
        if (desc != null) {
            currentEditorId = desc.getId();
        }
        try {
            IEditorPart result = activePage.openEditor(markerFile, "org.eclipse.ui.DefaultTextEditor", false);
            if (!(result instanceof ITextEditor)) {
                throw new MarkerNotPresentableException(markerFile);
            }
            iTextEditor = (ITextEditor)result;
            Object var8_9 = null;
            if (currentEditorId == null) return iTextEditor;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (currentEditorId == null) throw throwable;
            editorRegistry.setDefaultEditor(markerFile, currentEditorId);
            throw throwable;
        }
        editorRegistry.setDefaultEditor(markerFile, currentEditorId);
        return iTextEditor;
    }

    private void saveEditor(boolean save) throws CoreException {
        if (this.fEditor == null) {
            return;
        }
        boolean bl = save = save && this.fEditor.isDirty();
        if (save) {
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            IEditorInput input = this.fEditor.getEditorInput();
            try {
                provider.aboutToChange((Object)input);
                provider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)input, this.fDocument, true);
                this.fSaved = true;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                provider.changed((Object)input);
                throw throwable;
            }
            Object var4_6 = null;
            provider.changed((Object)input);
        }
        if (this.fCloseEditor && !this.fEditor.isDirty()) {
            this.fEditor.close(false);
        }
        this.fEditor = null;
        this.fDocument = null;
        this.fAnnotationModel = null;
        this.fCloseEditor = false;
    }

    private void updateButtons() {
        boolean hasNext = this.hasNextMatch();
        this.fReplaceNextButton.setEnabled(!this.fFatalError && this.fCurrentMatch != null);
        this.fReplaceButton.setEnabled(!this.fFatalError && this.fCurrentMatch != null);
        this.fNextButton.setEnabled(!this.fFatalError && hasNext);
    }

    private void restoreAutoBuildState() {
        if (!this.fAutobuild) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        description.setAutoBuilding(true);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), SearchMessages.getString("ReplaceDialog.error.reenable_auto_build_failed"));
            return;
        }
        ISearchResultView view = SearchPlugin.getSearchResultView();
        if (this.fSaved && view != null) {
            new GlobalBuildAction(view.getSite().getWorkbenchWindow(), 10).run();
        }
    }

    private String getDialogTitle() {
        return SearchMessages.getString("ReplaceDialog.dialog.title");
    }

    private void handleMarkerNotPresentableException(MarkerNotPresentableException e) {
        IFile file = e.getFile();
        String message = file == null ? SearchMessages.getString("ReplaceDialog.error.no_file_for_marker") : SearchMessages.getFormattedString("ReplaceDialog.error.unable_to_open_text_editor", file.getName());
        MessageDialog.openError((Shell)this.getParentShell(), (String)this.getDialogTitle(), (String)message);
    }

    private static class MarkerNotPresentableException
    extends Exception {
        private IFile fFile;

        MarkerNotPresentableException(IFile file) {
            this.fFile = file;
        }

        public IFile getFile() {
            return this.fFile;
        }
    }
}

