/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

class GotoMarkerAction
extends Action {
    private IEditorPart fEditor;

    GotoMarkerAction() {
    }

    public void run() {
        ISearchResultView view = SearchUI.getSearchResultView();
        ISelection selection = view.getSelection();
        Object element = null;
        if (selection instanceof IStructuredSelection) {
            element = ((IStructuredSelection)selection).getFirstElement();
        }
        if (element instanceof ISearchResultViewEntry) {
            ISearchResultViewEntry entry = (ISearchResultViewEntry)element;
            this.show(entry.getSelectedMarker());
        }
    }

    private void show(IMarker marker) {
        if (SearchUI.reuseEditor()) {
            this.showWithReuse(marker);
        } else {
            this.showWithoutReuse(marker);
        }
    }

    private void showWithReuse(IMarker marker) {
        IWorkbenchPage page = SearchPlugin.getActivePage();
        IResource resource = marker.getResource();
        if (page == null || !(resource instanceof IFile)) {
            return;
        }
        FileEditorInput input = new FileEditorInput((IFile)resource);
        String editorId = null;
        IEditorDescriptor desc = SearchPlugin.getDefault().getWorkbench().getEditorRegistry().getDefaultEditor((IFile)resource);
        editorId = desc == null ? SearchPlugin.getDefault().getWorkbench().getEditorRegistry().getDefaultEditor().getId() : desc.getId();
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
        } else {
            boolean showsSameInputType;
            boolean isOpen = false;
            if (this.fEditor != null) {
                IEditorReference[] parts = page.getEditorReferences();
                int i = 0;
                while (!isOpen && i < parts.length) {
                    boolean bl = isOpen = this.fEditor == parts[i++].getEditor(false);
                }
            }
            boolean canBeReused = isOpen && !this.fEditor.isDirty() && !this.isPinned(this.fEditor);
            boolean bl = showsSameInputType = this.fEditor != null && this.fEditor.getSite().getId().equals(editorId);
            if (canBeReused && !showsSameInputType) {
                page.closeEditor(this.fEditor, false);
                this.fEditor = null;
            }
            if (canBeReused && showsSameInputType) {
                ((IReusableEditor)this.fEditor).setInput((IEditorInput)input);
                page.bringToTop((IWorkbenchPart)this.fEditor);
                editor = this.fEditor;
            } else {
                try {
                    editor = page.openEditor((IEditorInput)input, editorId, false);
                    this.fEditor = editor instanceof IReusableEditor ? editor : null;
                }
                catch (PartInitException ex) {
                    ExceptionHandler.handle((CoreException)((Object)ex), SearchMessages.getString("Search.Error.openEditor.title"), SearchMessages.getString("Search.Error.openEditor.message"));
                    return;
                }
            }
        }
        if (editor != null) {
            editor.gotoMarker(marker);
        }
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editor.equals(editorRefs[i].getEditor(false))) {
                return editorRefs[i].isPinned();
            }
            ++i;
        }
        return false;
    }

    private void showWithoutReuse(IMarker marker) {
        IWorkbenchPage page = SearchPlugin.getActivePage();
        if (page == null) {
            return;
        }
        try {
            page.openEditor(marker, false);
        }
        catch (PartInitException ex) {
            ExceptionHandler.handle((CoreException)((Object)ex), SearchMessages.getString("Search.Error.openEditor.title"), SearchMessages.getString("Search.Error.openEditor.message"));
            return;
        }
    }
}

