/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultContentProvider;
import org.eclipse.search.internal.ui.ShowSearchAction;
import org.eclipse.search.internal.ui.util.ListDialog;
import org.eclipse.swt.graphics.Image;

class ShowSearchesAction
extends Action {
    public ShowSearchesAction() {
        super(SearchMessages.getString("ShowOtherSearchesAction.label"));
        this.setToolTipText(SearchMessages.getString("ShowOtherSearchesAction.tooltip"));
    }

    public void run() {
        this.run(false);
    }

    public void run(boolean showAll) {
        List<Object> result;
        String message;
        String title;
        Iterator iter = SearchManager.getDefault().getPreviousSearches().iterator();
        int cutOffSize = showAll ? 0 : 10;
        int size = SearchManager.getDefault().getPreviousSearches().size() - cutOffSize;
        Search selectedSearch = SearchManager.getDefault().getCurrentSearch();
        ShowSearchAction selectedAction = null;
        ArrayList<ShowSearchAction> input = new ArrayList<ShowSearchAction>(size);
        int i = 0;
        while (iter.hasNext()) {
            Search search = (Search)iter.next();
            if (i++ < cutOffSize) continue;
            ShowSearchAction action = new ShowSearchAction(search);
            input.add(action);
            if (selectedSearch != search) continue;
            selectedAction = action;
        }
        if (showAll) {
            title = SearchMessages.getString("PreviousSearchesDialog.title");
            message = SearchMessages.getString("PreviousSearchesDialog.message");
        } else {
            title = SearchMessages.getString("OtherSearchesDialog.title");
            message = SearchMessages.getString("OtherSearchesDialog.message");
        }
        ListDialog dlg = new ListDialog(SearchPlugin.getActiveWorkbenchShell(), input, title, message, new SearchResultContentProvider(), (ILabelProvider)new SearchesLabelProvider());
        if (selectedAction != null) {
            Object[] selected = new Object[]{selectedAction};
            dlg.setInitialSelections(selected);
        }
        if (dlg.open() == 0 && (result = Arrays.asList(dlg.getResult())) != null && result.size() == 1) {
            ((ShowSearchAction)((Object)result.get(0))).run();
        }
    }

    private static final class SearchesLabelProvider
    extends LabelProvider {
        private ArrayList fImages = new ArrayList();

        SearchesLabelProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof ShowSearchAction)) {
                return "";
            }
            return ((ShowSearchAction)((Object)element)).getText();
        }

        public Image getImage(Object element) {
            if (!(element instanceof ShowSearchAction)) {
                return null;
            }
            ImageDescriptor imageDescriptor = ((ShowSearchAction)((Object)element)).getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image image = imageDescriptor.createImage();
            this.fImages.add(image);
            return image;
        }

        public void dispose() {
            Iterator iter = ((AbstractList)this.fImages).iterator();
            while (iter.hasNext()) {
                ((Image)iter.next()).dispose();
            }
            this.fImages = null;
        }
    }
}

