/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.search.internal.ui.CopyToClipboardAction;
import org.eclipse.search.internal.ui.GotoMarkerAction;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.search.internal.ui.RemoveAllResultsAction;
import org.eclipse.search.internal.ui.RemoveMatchAction;
import org.eclipse.search.internal.ui.RemovePotentialMatchesAction;
import org.eclipse.search.internal.ui.RemoveResultAction;
import org.eclipse.search.internal.ui.ResourceToItemsMapper;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchAgainAction;
import org.eclipse.search.internal.ui.SearchDropDownAction;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.internal.ui.SearchResultContentProvider;
import org.eclipse.search.internal.ui.SearchResultLabelProvider;
import org.eclipse.search.internal.ui.SearchResultView;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.ShowNextResultAction;
import org.eclipse.search.internal.ui.ShowPreviousResultAction;
import org.eclipse.search.internal.ui.SortDropDownAction;
import org.eclipse.search.internal.ui.util.FileLabelProvider;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IContextMenuContributor;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class SearchResultViewer
extends TableViewer {
    private SearchResultView fOuterPart;
    private ShowNextResultAction fShowNextResultAction;
    private ShowPreviousResultAction fShowPreviousResultAction;
    private GotoMarkerAction fGotoMarkerActionProxy;
    private SearchAgainAction fSearchAgainAction;
    private RemoveResultAction fRemoveSelectedMatchesAction;
    private RemoveAllResultsAction fRemoveAllResultsAction;
    private SortDropDownAction fSortDropDownAction;
    private SearchDropDownAction fSearchDropDownAction;
    private CopyToClipboardAction fCopyToClipboardAction;
    private int fMarkerToShow;
    private boolean fHandleSelectionChangedEvents = true;
    private ISelection fLastSelection;
    private boolean fCurrentMatchRemoved = false;
    private Color fPotentialMatchFgColor;
    private ActionGroup fActionGroup;
    private IContextMenuContributor fContextMenuContributor;
    private IAction fGotoMarkerAction;
    private ResourceToItemsMapper fResourceToItemsMapper = new ResourceToItemsMapper((ContentViewer)this);
    static /* synthetic */ Class class$0;

    public SearchResultViewer(SearchResultView outerPart, Composite parent) {
        super(new Table(parent, 66306));
        this.fOuterPart = outerPart;
        Assert.isNotNull((Object)this.fOuterPart);
        if (SearchPreferencePage.arePotentialMatchesEmphasized()) {
            this.fPotentialMatchFgColor = new Color((Device)SearchPlugin.getActiveWorkbenchShell().getDisplay(), SearchPreferencePage.getPotentialMatchForegroundColor());
        }
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)new SearchResultContentProvider());
        SearchResultLabelProvider labelProvider = new SearchResultLabelProvider((ILabelProvider)new FileLabelProvider(1));
        this.setLabelProvider((IBaseLabelProvider)labelProvider);
        Search currentSearch = SearchManager.getDefault().getCurrentSearch();
        boolean hasSearch = currentSearch != null;
        boolean hasSearchOperation = hasSearch && currentSearch.getOperation() != null;
        this.fShowNextResultAction = new ShowNextResultAction(this);
        this.fShowNextResultAction.setEnabled(false);
        this.fShowPreviousResultAction = new ShowPreviousResultAction(this);
        this.fShowPreviousResultAction.setEnabled(false);
        this.fGotoMarkerActionProxy = new GotoMarkerAction(this);
        this.fGotoMarkerActionProxy.setEnabled(false);
        this.fRemoveSelectedMatchesAction = new RemoveResultAction((ISelectionProvider)this, false);
        this.fRemoveSelectedMatchesAction.setEnabled(false);
        this.fRemoveAllResultsAction = new RemoveAllResultsAction();
        this.fRemoveAllResultsAction.setEnabled(false);
        this.fSearchAgainAction = new SearchAgainAction();
        this.fSearchAgainAction.setEnabled(hasSearchOperation);
        this.fSortDropDownAction = new SortDropDownAction(this);
        this.fSortDropDownAction.setEnabled(this.getItemCount() > 0);
        this.fSearchDropDownAction = new SearchDropDownAction(this);
        this.fSearchDropDownAction.setEnabled(hasSearch);
        this.fCopyToClipboardAction = new CopyToClipboardAction(this);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SearchResultViewer.this.fLastSelection == null || !SearchResultViewer.this.fLastSelection.equals(event.getSelection())) {
                    SearchResultViewer.this.fLastSelection = event.getSelection();
                    SearchResultViewer.this.handleSelectionChanged();
                }
            }
        });
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SearchResultViewer.this.showResult();
            }
        });
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SearchPlugin.createStandardGroups(mgr);
                SearchResultViewer.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.getTable());
        this.getTable().setMenu(menu);
        this.fOuterPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
        IActionBars actionBars = this.fOuterPart.getViewSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler("next", (IAction)this.fShowNextResultAction);
            actionBars.setGlobalActionHandler("previous", (IAction)this.fShowPreviousResultAction);
        }
        this.fOuterPart.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    void init() {
        Search search = SearchManager.getDefault().getCurrentSearch();
        if (search != null) {
            this.setGotoMarkerAction(search.getGotoMarkerAction());
            this.setContextMenuTarget(search.getContextMenuContributor());
            this.setActionGroupFactory(null);
            this.setActionGroupFactory(search.getActionGroupFactory());
            this.setPageId(search.getPageId());
            this.setInput(search.getResults());
        }
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
        if (((SearchResultViewEntry)element).isPotentialMatch()) {
            TableItem ti = (TableItem)item;
            ti.setForeground(this.fPotentialMatchFgColor);
        }
    }

    private void handleSelectionChanged() {
        int selectionCount = this.getSelectedEntriesCount();
        boolean hasSingleSelection = selectionCount == 1;
        boolean hasElements = this.getItemCount() > 0;
        this.fShowNextResultAction.setEnabled(hasSingleSelection || hasElements && selectionCount == 0);
        this.fShowPreviousResultAction.setEnabled(hasSingleSelection || hasElements && selectionCount == 0);
        this.fGotoMarkerActionProxy.setEnabled(hasSingleSelection);
        this.fRemoveSelectedMatchesAction.setEnabled(selectionCount > 0);
        if (this.fHandleSelectionChangedEvents) {
            this.fMarkerToShow = -1;
            this.fCurrentMatchRemoved = false;
        } else {
            this.fHandleSelectionChangedEvents = true;
        }
        this.updateStatusLine();
    }

    void updateStatusLine() {
        ISearchResultViewEntry entry;
        IPath path;
        boolean hasSingleSelection = this.getSelectedEntriesCount() == 1;
        String location = "";
        if (hasSingleSelection && (path = (entry = (ISearchResultViewEntry)this.getTable().getItem(this.getTable().getSelectionIndex()).getData()).getResource().getFullPath()) != null) {
            location = path.makeRelative().toString();
        }
        this.setStatusLineMessage(location);
    }

    void enableActions() {
        boolean operationState;
        Search currentSearch;
        boolean state;
        boolean bl = state = this.getItemCount() > 0;
        if (state != this.fShowNextResultAction.isEnabled()) {
            this.fShowNextResultAction.setEnabled(state);
        }
        if (state != this.fShowPreviousResultAction.isEnabled()) {
            this.fShowPreviousResultAction.setEnabled(state);
        }
        if (state != this.fSortDropDownAction.isEnabled()) {
            this.fSortDropDownAction.setEnabled(state);
        }
        if (state != this.fRemoveAllResultsAction.isEnabled()) {
            this.fRemoveAllResultsAction.setEnabled(state);
        }
        state = (currentSearch = SearchManager.getDefault().getCurrentSearch()) != null;
        boolean bl2 = operationState = state && currentSearch.getOperation() != null;
        if (state != this.fSearchDropDownAction.isEnabled()) {
            this.fSearchDropDownAction.setEnabled(state);
        }
        if (operationState != this.fSearchAgainAction.isEnabled()) {
            this.fSearchAgainAction.setEnabled(operationState);
        }
        boolean bl3 = state = !this.getSelection().isEmpty();
        if (state != this.fGotoMarkerActionProxy.isEnabled()) {
            this.fGotoMarkerActionProxy.setEnabled(state);
        }
        if (state != this.fRemoveSelectedMatchesAction.isEnabled()) {
            this.fRemoveSelectedMatchesAction.setEnabled(state);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.fLastSelection = null;
        this.getTable().removeAll();
        super.inputChanged(input, oldInput);
        this.fMarkerToShow = -1;
        this.fCurrentMatchRemoved = false;
        this.updateTitle();
        this.enableActions();
        if (this.getItemCount() > 0) {
            this.selectResult(this.getTable(), 0);
        }
    }

    protected int getSelectedEntriesCount() {
        ISelection s = this.getSelection();
        if (s == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return 0;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        return selection.size();
    }

    protected boolean enableRemoveMatchMenuItem() {
        if (this.getSelectedEntriesCount() != 1) {
            return false;
        }
        Table table = this.getTable();
        int index = table.getSelectionIndex();
        SearchResultViewEntry entry = null;
        if (index > -1) {
            entry = (SearchResultViewEntry)table.getItem(index).getData();
        }
        return entry != null && entry.getMatchCount() > 1;
    }

    void fillContextMenu(IMenuManager menu) {
        ISelection selection = this.getSelection();
        if (this.fActionGroup != null) {
            ActionContext context = new ActionContext(selection);
            context.setInput(this.getInput());
            this.fActionGroup.setContext(context);
            this.fActionGroup.fillContextMenu(menu);
            this.fActionGroup.setContext(null);
        }
        if (this.fContextMenuContributor != null) {
            this.fContextMenuContributor.fill(menu, (IInputSelectionProvider)this);
        }
        if (!selection.isEmpty()) {
            menu.appendToGroup("group.reorganize", (IAction)this.fCopyToClipboardAction);
            menu.appendToGroup("group.goto", (IAction)this.fGotoMarkerActionProxy);
            if (this.enableRemoveMatchMenuItem()) {
                menu.appendToGroup("group.removeMatches", (IAction)new RemoveMatchAction((ISelectionProvider)this));
            }
            menu.appendToGroup("group.removeMatches", (IAction)new RemoveResultAction((ISelectionProvider)this, true));
            if (this.isPotentialMatchSelected()) {
                menu.appendToGroup("group.removeMatches", (IAction)new RemovePotentialMatchesAction((IWorkbenchSite)this.fOuterPart.getViewSite()));
            }
        }
        if (this.getItemCount() > 0) {
            menu.appendToGroup("group.removeMatches", (IAction)new RemoveAllResultsAction());
        }
        menu.appendToGroup("group.viewerSetup", (IAction)this.fSearchAgainAction);
        if (this.getItemCount() > 0) {
            this.fSortDropDownAction = this.fSortDropDownAction.renew();
            if (this.fSortDropDownAction.getSorterCount() > 1) {
                menu.appendToGroup("group.viewerSetup", (IAction)this.fSortDropDownAction);
            }
        }
    }

    private boolean isPotentialMatchSelected() {
        Object entry;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (entry = ((IStructuredSelection)selection).getFirstElement()) instanceof ISearchResultViewEntry) {
            IMarker marker = ((ISearchResultViewEntry)entry).getSelectedMarker();
            return marker != null && marker.getAttribute("potentialMatch", false);
        }
        return false;
    }

    IAction getGotoMarkerAction() {
        return this.fGotoMarkerAction;
    }

    void setGotoMarkerAction(IAction gotoMarkerAction) {
        this.fGotoMarkerAction = gotoMarkerAction;
    }

    void setContextMenuTarget(IContextMenuContributor contributor) {
        this.fContextMenuContributor = contributor;
    }

    void setActionGroupFactory(IActionGroupFactory groupFactory) {
        IActionBars actionBars = this.fOuterPart.getViewSite().getActionBars();
        if (this.fActionGroup != null) {
            this.fActionGroup.dispose();
            this.fActionGroup = null;
        }
        if (groupFactory != null) {
            this.fActionGroup = groupFactory.createActionGroup(this.fOuterPart);
            if (actionBars != null) {
                this.fActionGroup.fillActionBars(actionBars);
            }
        }
        if (actionBars != null) {
            actionBars.updateActionBars();
        }
    }

    void setPageId(String pageId) {
        ILabelProvider labelProvider = this.fOuterPart.getLabelProvider(pageId);
        if (labelProvider != null) {
            this.internalSetLabelProvider(labelProvider);
        }
        this.fSortDropDownAction.setPageId(pageId);
    }

    void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fShowNextResultAction);
        tbm.add((IAction)this.fShowPreviousResultAction);
        tbm.add((IAction)this.fRemoveSelectedMatchesAction);
        tbm.add((IAction)this.fRemoveAllResultsAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new OpenSearchDialogAction());
        tbm.add((IAction)this.fSearchDropDownAction);
        this.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    SearchResultViewer.this.fSearchAgainAction.run();
                    return;
                }
                if (e.character == '\u007f') {
                    new RemoveResultAction((ISelectionProvider)SearchResultViewer.this, true).run();
                    return;
                }
            }
        });
    }

    int getItemCount() {
        return SearchManager.getDefault().getCurrentItemCount();
    }

    void internalSetLabelProvider(ILabelProvider provider) {
        this.setLabelProvider((IBaseLabelProvider)new SearchResultLabelProvider(provider));
    }

    public void showResult() {
        Table table = this.getTable();
        if (!this.canDoShowResult(table)) {
            return;
        }
        int index = table.getSelectionIndex();
        if (index < 0) {
            return;
        }
        SearchResultViewEntry entry = (SearchResultViewEntry)this.getTable().getItem(index).getData();
        this.fMarkerToShow = 0;
        this.fCurrentMatchRemoved = false;
        entry.setSelectedMarkerIndex(0);
        this.openCurrentSelection();
    }

    public void showNextResult() {
        Table table = this.getTable();
        if (!this.canDoShowResult(table)) {
            return;
        }
        int index = table.getSelectionIndex();
        SearchResultViewEntry entry = null;
        if (index > -1) {
            entry = (SearchResultViewEntry)table.getItem(index).getData();
        }
        if (this.fCurrentMatchRemoved) {
            this.fCurrentMatchRemoved = false;
        } else {
            ++this.fMarkerToShow;
        }
        if (entry == null || this.fMarkerToShow >= entry.getMatchCount()) {
            if (index == -1) {
                index = 0;
            } else if (++index >= table.getItemCount()) {
                index = 0;
            }
            this.fMarkerToShow = 0;
            entry = (SearchResultViewEntry)this.getTable().getItem(index).getData();
            this.selectResult(table, index);
        }
        entry.setSelectedMarkerIndex(this.fMarkerToShow);
        this.openCurrentSelection();
        this.updateStatusLine();
    }

    public void showPreviousResult() {
        SearchResultViewEntry entry;
        this.fCurrentMatchRemoved = false;
        Table table = this.getTable();
        if (!this.canDoShowResult(table)) {
            return;
        }
        int index = table.getSelectionIndex();
        --this.fMarkerToShow;
        if (this.fMarkerToShow >= 0) {
            entry = (SearchResultViewEntry)this.getTable().getItem(this.getTable().getSelectionIndex()).getData();
        } else {
            int count = table.getItemCount();
            if (index == -1) {
                index = count - 1;
            } else if (--index < 0) {
                index = count - 1;
            }
            entry = (SearchResultViewEntry)this.getTable().getItem(index).getData();
            this.fMarkerToShow = entry.getMatchCount() - 1;
            this.selectResult(table, index);
        }
        entry.setSelectedMarkerIndex(this.fMarkerToShow);
        this.openCurrentSelection();
        this.updateStatusLine();
    }

    private boolean canDoShowResult(Table table) {
        return table != null && this.getItemCount() != 0;
    }

    private void selectResult(Table table, int index) {
        this.fHandleSelectionChangedEvents = false;
        Object element = this.getElementAt(index);
        if (element != null) {
            this.setSelection((ISelection)new StructuredSelection(this.getElementAt(index)), true);
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void openCurrentSelection() {
        IAction action = this.getGotoMarkerAction();
        if (action != null) {
            action.run();
        }
    }

    void updatedPotentialMatchFgColor() {
        if (this.fPotentialMatchFgColor != null) {
            this.fPotentialMatchFgColor.dispose();
        }
        this.fPotentialMatchFgColor = null;
        if (SearchPreferencePage.arePotentialMatchesEmphasized()) {
            this.fPotentialMatchFgColor = new Color((Device)SearchPlugin.getActiveWorkbenchShell().getDisplay(), SearchPreferencePage.getPotentialMatchForegroundColor());
        }
        this.refresh();
    }

    protected void updateTitle() {
        String title;
        boolean hasCurrentSearch;
        boolean bl = hasCurrentSearch = SearchManager.getDefault().getCurrentSearch() != null;
        if (hasCurrentSearch) {
            String description = SearchManager.getDefault().getCurrentSearch().getFullDescription();
            title = SearchMessages.getFormattedString("SearchResultView.titleWithDescription", description);
        } else {
            title = SearchMessages.getString("SearchResultView.title");
        }
        if (title == null || !title.equals(this.fOuterPart.getTitle())) {
            this.fOuterPart.setTitle(title);
        }
    }

    protected void clearTitle() {
        String title = SearchMessages.getString("SearchResultView.title");
        if (title == null || !title.equals(this.fOuterPart.getTitle())) {
            this.fOuterPart.setTitle(title);
        }
    }

    private void setStatusLineMessage(String message) {
        this.fOuterPart.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    protected void handleDispose(DisposeEvent event) {
        this.fLastSelection = null;
        Menu menu = this.getTable().getMenu();
        if (menu != null) {
            menu.dispose();
        }
        if (this.fPotentialMatchFgColor != null) {
            this.fPotentialMatchFgColor.dispose();
        }
        if (this.fActionGroup != null) {
            this.fActionGroup.dispose();
            this.fActionGroup = null;
        }
        super.handleDispose(event);
    }

    protected void handleAddMatch(ISearchResultViewEntry entry) {
        this.insert(entry, -1);
    }

    protected void handleRemoveMatch(ISearchResultViewEntry entry) {
        Widget item = this.findItem(entry);
        if (entry.getMatchCount() == 0) {
            this.remove(entry);
        } else {
            this.updateItem(item, entry);
        }
        this.updateStatusLine();
    }

    protected void handleRemoveAll() {
        this.setContextMenuTarget(null);
        this.setActionGroupFactory(null);
        this.setInput(null);
    }

    protected void handleUpdateMatch(ISearchResultViewEntry entry, boolean matchRemoved) {
        Widget item = this.findItem(entry);
        this.updateItem(item, entry);
        if (matchRemoved && this.getSelectionFromWidget().contains(entry)) {
            this.fCurrentMatchRemoved = true;
        }
    }

    void restoreState(IMemento memento) {
        this.fSortDropDownAction.restoreState(memento);
    }

    void saveState(IMemento memento) {
        this.fSortDropDownAction.saveState(memento);
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        Object[] changed = event.getElements();
        if (changed != null && !this.fResourceToItemsMapper.isEmpty()) {
            ArrayList<Object> others = new ArrayList<Object>(changed.length);
            int i = 0;
            while (i < changed.length) {
                Object curr = changed[i];
                if (curr instanceof IResource) {
                    this.fResourceToItemsMapper.resourceChanged((IResource)curr);
                } else if (curr instanceof IAdaptable) {
                    IResource resource;
                    IAdaptable iAdaptable = (IAdaptable)curr;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                        this.fResourceToItemsMapper.resourceChanged(resource);
                    }
                } else {
                    others.add(curr);
                }
                ++i;
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        }
        super.handleLabelProviderChanged(event);
    }

    protected void mapElement(Object element, Widget item) {
        super.mapElement(element, item);
        if (item instanceof Item) {
            this.fResourceToItemsMapper.addToMap(element, (Item)item);
        }
    }

    protected void unmapElement(Object element, Widget item) {
        if (item instanceof Item) {
            this.fResourceToItemsMapper.removeFromMap(element, (Item)item);
        }
        super.unmapElement(element, item);
    }

    protected void unmapAllElements() {
        this.fResourceToItemsMapper.clearMap();
        super.unmapAllElements();
    }
}

