/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;

public class CopyToClipboardAction
extends Action {
    private SearchResultViewer fViewer;

    public CopyToClipboardAction(SearchResultViewer viewer) {
        Assert.isNotNull((Object)((Object)viewer));
        this.fViewer = viewer;
        this.setText(SearchMessages.getString("CopyToClipboardAction.label"));
        this.setToolTipText(SearchMessages.getString("CopyToClipboardAction.tooltip"));
    }

    public void run() {
        block5: {
            Shell shell = SearchPlugin.getActiveWorkbenchShell();
            if (shell == null) {
                return;
            }
            ILabelProvider labelProvider = (ILabelProvider)this.fViewer.getLabelProvider();
            String lineDelim = System.getProperty("line.separator");
            StringBuffer buf = new StringBuffer();
            Iterator iter = this.getSelection();
            while (iter.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(lineDelim);
                }
                buf.append(labelProvider.getText(iter.next()));
            }
            if (buf.length() <= 0) break block5;
            Clipboard clipboard = new Clipboard(shell.getDisplay());
            try {
                this.copyToClipbard(clipboard, buf.toString(), shell);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                clipboard.dispose();
                throw throwable;
            }
            Object var7_9 = null;
            clipboard.dispose();
        }
    }

    private Iterator getSelection() {
        ISelection s = this.fViewer.getSelection();
        if (s instanceof IStructuredSelection) {
            return ((IStructuredSelection)s).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    private void copyToClipbard(Clipboard clipboard, String str, Shell shell) {
        block3: {
            try {
                clipboard.setContents((Object[])new String[]{str}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError ex) {
                String message;
                if (ex.code != 2002) {
                    throw ex;
                }
                String title = SearchMessages.getString("CopyToClipboardAction.error.title");
                if (!MessageDialog.openQuestion((Shell)shell, (String)title, (String)(message = SearchMessages.getString("CopyToClipboardAction.error.message")))) break block3;
                this.copyToClipbard(clipboard, str, shell);
            }
        }
    }
}

