/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.core.ISearchScope;

public class SearchScope
implements ISearchScope {
    private List fElements;
    private String fDescription;

    public SearchScope(String description) {
        Assert.isNotNull((Object)description);
        this.fDescription = description;
        this.fElements = new ArrayList(5);
    }

    public SearchScope(String description, IResource[] resources) {
        Assert.isNotNull((Object)description);
        int resourceCount = resources.length;
        this.fDescription = description;
        this.fElements = new ArrayList(resourceCount + 5);
        int i = 0;
        while (i < resourceCount) {
            this.fElements.add(resources[i]);
            ++i;
        }
    }

    public void add(IResource element) {
        this.fElements.add(element);
    }

    public boolean encloses(IResourceProxy proxy) {
        IPath elementPath = proxy.requestFullPath();
        Iterator iter = this.elements();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (!resource.getFullPath().isPrefixOf(elementPath)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.fDescription;
    }

    protected Iterator elements() {
        return this.fElements.iterator();
    }

    public boolean encloses(IResource element) {
        IPath elementPath = element.getFullPath();
        Iterator iter = this.elements();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (!resource.getFullPath().isPrefixOf(elementPath)) continue;
            return true;
        }
        return false;
    }
}

