/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.mmr;

import com.sap.caf.mp.mm.reader.CAFConnection;
import com.sap.caf.mp.mm.reader.IConnectionHelper;
import com.sap.caf.mp.mm.reader.IPrimaryKey;
import com.sap.caf.mp.mm.reader.IReaderAPI;
import com.sap.caf.mp.mmr.ConnectionHelperNotInitializedException;
import com.sap.caf.mp.mmr.MMRConnectionHelper;
import com.sap.caf.mp.mmr.MMResourceException;
import com.sap.caf.rt.bol.exceptions.BONotFoundException;
import com.sap.caf.rt.bol.exceptions.ConnectionException;
import com.sap.caf.rt.bol.exceptions.QueryException;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class MMRObjectReaderHelper
implements IReaderAPI {
    private static final String JARM_REQUEST = "CAF:RT:oal";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String MESSAGE_STORAGE_PATH_IS_MISSING = "The path to the MMR storage should be iniitialized!";
    private static final String SEARCH_FIELD_ID = "objectID";
    private static final String EXCEPTION_CONSTANT = "MMR_QUERY";
    private static MMRConnectionHelper mConnectionHelper = null;

    public static synchronized MMRObjectReaderHelper createReaderHelper() {
        MMRObjectReaderHelper result = new MMRObjectReaderHelper();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnectionHelper getConnectionHelper() {
        if (mConnectionHelper == null) {
            MMRObjectReaderHelper mMRObjectReaderHelper = this;
            synchronized (mMRObjectReaderHelper) {
                if (mConnectionHelper == null) {
                    throw new ConnectionHelperNotInitializedException(MESSAGE_STORAGE_PATH_IS_MISSING);
                }
            }
        }
        return mConnectionHelper;
    }

    public Object getObjectByGUID(Class aObjType, IPrimaryKey aGuid) throws QueryException, ConnectionException, BONotFoundException, MMResourceException {
        ArrayList typeList = this.getTypeAsArrayList(aObjType);
        Object bo = null;
        CAFConnection con = null;
        QueryFilters filters = new QueryFilters();
        QueryFilter filter = new QueryFilter(SEARCH_FIELD_ID, 0, aGuid.getUniqueIdAsString());
        filters.add(filter);
        try {
            con = this.getConnectionHelper().getConnection();
            Iterator objs = con.getConnection().queryM1((List)typeList, filters, true).iterator();
            while (objs.hasNext()) {
                bo = objs.next();
            }
            if (bo == null) {
                throw new BONotFoundException();
            }
        }
        catch (ResourceException exc) {
            throw new MMResourceException(exc);
        }
        return bo;
    }

    public List getObjectsByType(Class aObjType) throws QueryException, ConnectionException {
        ArrayList typeList = this.getTypeAsArrayList(aObjType);
        List result = null;
        CAFConnection con = null;
        try {
            con = this.getConnectionHelper().getConnection();
            result = con.getConnection().queryM1((List)typeList, null, true);
        }
        catch (ResourceException ex) {
            throw new QueryException(EXCEPTION_CONSTANT, (Object[])new String[]{"getObjectsByType"}, (Throwable)ex);
        }
        return result;
    }

    private ArrayList getTypeAsArrayList(Class aType) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer strTok = new StringTokenizer(aType.getName(), PACKAGE_SEPARATOR);
        while (strTok.hasMoreTokens()) {
            String nextToken = strTok.nextToken();
            result.add(nextToken);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnectionHelper createConnectionHelper(String aPathToStorage) {
        if (mConnectionHelper == null) {
            MMRObjectReaderHelper mMRObjectReaderHelper = this;
            synchronized (mMRObjectReaderHelper) {
                if (mConnectionHelper == null) {
                    mConnectionHelper = new MMRConnectionHelper(aPathToStorage);
                }
            }
        }
        return mConnectionHelper;
    }
}

