/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.mmr;

import com.sap.caf.mp.mm.reader.CAFConnection;
import com.sap.caf.mp.mm.reader.IConnectionHelper;
import com.sap.caf.mp.mm.reader.MMObjectReaderFactory;
import com.sap.caf.rt.bol.exceptions.ConnectionException;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.foundation.Utilities;
import javax.resource.ResourceException;

public class MMRConnectionHelper
implements IConnectionHelper {
    private static final String JARM_REQUEST = "CAF:RT:oal";
    private static final String OPEN_ERROR = "OPEN_ERROR";
    private static final String CLOSE_ERROR = "CLOSE_ERROR";
    private static final String WORKSPACE_NAME = "Read";
    private static CAFConnection con = null;
    private String mPathToStorage = null;

    protected MMRConnectionHelper(String aPathToStorage) {
        this.mPathToStorage = aPathToStorage;
    }

    public CAFConnection getConnection() throws ConnectionException {
        if (con == null) {
            this.createConnection();
        }
        return con;
    }

    private synchronized void createConnection() throws ConnectionException {
        if (con == null) {
            try {
                ConnectionSpec connSpec = new ConnectionSpec();
                connSpec.setComponentClassLoader(MMObjectReaderFactory.mmClassLoader);
                connSpec.setLog(Utilities.getUtilities().getConsoleLog());
                connSpec.setReadOnly(true);
                ConnectionFactory mdrf = new ConnectionFactory();
                con = new CAFConnection(mdrf.getConnection((javax.resource.cci.ConnectionSpec)connSpec));
            }
            catch (com.sap.ip.mmr.ResourceException ex) {
                throw new ConnectionException(OPEN_ERROR, new Object[0], (Throwable)ex);
            }
        }
    }

    public synchronized void closeConnection(CAFConnection aCon) throws ConnectionException {
        if (aCon != null) {
            try {
                aCon.close();
                aCon = null;
            }
            catch (ResourceException ex) {
                throw new ConnectionException(CLOSE_ERROR, new Object[0], (Throwable)ex);
            }
        }
    }
}

