/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.util;

import com.sap.security.api.IGroup;
import com.sap.security.api.IGroupFactory;
import com.sap.security.api.IGroupSearchFilter;
import com.sap.security.api.IPrincipal;
import com.sap.security.api.IRole;
import com.sap.security.api.IRoleFactory;
import com.sap.security.api.IRoleSearchFilter;
import com.sap.security.api.ISearchResult;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.IUserSearchFilter;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PrincipalUtils {
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$rt$util$PrincipalUtils == null ? (class$com$sap$caf$rt$util$PrincipalUtils = PrincipalUtils.class$("com.sap.caf.rt.util.PrincipalUtils")) : class$com$sap$caf$rt$util$PrincipalUtils));
    private static final char COMMA_DELIMITER = ',';
    private static final char SPACE_DELIMITER = ' ';
    public static final char PRINCIPAL_DELIMITER = ';';
    static /* synthetic */ Class class$com$sap$caf$rt$util$PrincipalUtils;

    public static IPrincipal[] searchPrincipal(String searchStr, String type) throws UMException {
        return PrincipalUtils.searchPrincipal(searchStr, type, 0);
    }

    public static IPrincipal[] searchPrincipal(String searchStr, String type, int limit) throws UMException {
        IUser[] result = null;
        if (searchStr != null && searchStr.length() > 0) {
            if ("IUser".equals(type)) {
                result = PrincipalUtils.getUsers(searchStr, false, limit);
            } else if ("IGroup".equals(type)) {
                result = PrincipalUtils.getGroups(searchStr, false, limit);
            } else if ("IRole".equals(type)) {
                result = PrincipalUtils.getRoles(searchStr, false, limit);
            } else {
                throw new UMException("unknown type:" + type);
            }
        }
        return result;
    }

    private static IPrincipal[] convertToArray(ISearchResult searchResult) throws UMException {
        IPrincipal[] principals = new IPrincipal[searchResult.size()];
        int i = 0;
        while (searchResult.hasNext()) {
            principals[i] = UMFactory.getPrincipalFactory().getPrincipal((String)searchResult.next());
            ++i;
        }
        return principals;
    }

    private static IPrincipal[] getGroups(String searchName, boolean useAsterisk, int limit) throws UMException {
        IGroupFactory factory = UMFactory.getGroupFactory();
        try {
            IGroup group = factory.getGroupByUniqueName(searchName);
            return new IGroup[]{group};
        }
        catch (UMException e) {
            logger.infoT("No group with exactly name {0}", new Object[]{searchName});
            logger.throwing((Throwable)e);
            IGroupSearchFilter filter = factory.getGroupSearchFilter();
            if (limit > 0) {
                filter.setMaxSearchResultSize(limit);
            }
            String nameWithAsteric = PrincipalUtils.getStrWithAsterisk(searchName, useAsterisk);
            int operatorToUse = PrincipalUtils.getOperatorByString(nameWithAsteric);
            filter.setUniqueName(nameWithAsteric, operatorToUse, false);
            logger.debugT("filter:" + filter);
            ISearchResult result = factory.searchGroups(filter);
            logger.debugT("Search result:" + result.size());
            if (result.size() > 0) {
                return PrincipalUtils.convertToArray(result);
            }
            filter.clear();
            if (limit > 0) {
                filter.setMaxSearchResultSize(limit);
            }
            filter.setDisplayName(nameWithAsteric, operatorToUse, false);
            logger.debugT("filter:" + filter);
            result = factory.searchGroups(filter);
            logger.debugT("Search result:" + result.size());
            if (result.size() > 0) {
                return PrincipalUtils.convertToArray(result);
            }
            return null;
        }
    }

    private static IPrincipal[] getRoles(String searchName, boolean useAsterisk, int limit) throws UMException {
        IRoleFactory factory = UMFactory.getRoleFactory();
        try {
            IRole role = factory.getRoleByUniqueName(searchName);
            return new IRole[]{role};
        }
        catch (UMException e) {
            logger.infoT("No role with exactly name {0}", new Object[]{searchName});
            logger.throwing((Throwable)e);
            IRoleSearchFilter filter = factory.getRoleSearchFilter();
            if (limit > 0) {
                filter.setMaxSearchResultSize(limit);
            }
            filter.setUniqueName(PrincipalUtils.getStrWithAsterisk(searchName, useAsterisk), 1, false);
            logger.debugT("filter:" + filter);
            ISearchResult result = factory.searchRoles(filter);
            logger.debugT("Search result:" + result.size());
            if (result.size() > 0) {
                return PrincipalUtils.convertToArray(result);
            }
            filter.clear();
            if (limit > 0) {
                filter.setMaxSearchResultSize(limit);
            }
            filter.setDisplayName(PrincipalUtils.getStrWithAsterisk(searchName, useAsterisk), 1, false);
            logger.debugT("filter:" + filter);
            result = factory.searchRoles(filter);
            logger.debugT("Search result:" + result.size());
            if (result.size() > 0) {
                return PrincipalUtils.convertToArray(result);
            }
            return null;
        }
    }

    public static IUser[] getUsers(String userName, boolean useAsterisk) throws UMException {
        return PrincipalUtils.getUsers(userName, useAsterisk, 0);
    }

    public static IUser[] getUsers(String userName, boolean useAsterisk, int limit) throws UMException {
        if (userName == null) {
            return null;
        }
        IUserFactory userFactory = UMFactory.getUserFactory();
        try {
            IUser user = userFactory.getUserByUniqueName(userName);
            return new IUser[]{user};
        }
        catch (UMException e) {
            String lastName;
            int i;
            logger.infoT("No user with exactly name {0}", new Object[]{userName});
            logger.throwing((Throwable)e);
            HashSet<String> resultSet = new HashSet<String>();
            IUserSearchFilter filter = userFactory.getUserSearchFilter();
            if (limit > 0) {
                filter.setMaxSearchResultSize(limit);
            }
            String userNameWithAsterisk = PrincipalUtils.getStrWithAsterisk(userName, useAsterisk);
            filter.setUniqueName(userNameWithAsterisk, 1, false);
            logger.debugT("filter:" + filter);
            ISearchResult result = userFactory.searchUsers(filter);
            logger.debugT("Search result:" + result.size());
            if (result.size() > 0) {
                i = 0;
                while (result.hasNext()) {
                    resultSet.add((String)result.next());
                    ++i;
                }
            }
            filter.clear();
            if (limit > 0) {
                filter.setMaxSearchResultSize(limit);
            }
            filter.setFirstName(userNameWithAsterisk, 1, false);
            logger.debugT("filter:" + filter);
            result = userFactory.searchUsers(filter);
            logger.debugT("Search result:" + result.size());
            if (result.size() > 0) {
                i = 0;
                while (result.hasNext()) {
                    resultSet.add((String)result.next());
                    ++i;
                }
            }
            filter.clear();
            if (limit > 0) {
                filter.setMaxSearchResultSize(limit);
            }
            filter.setLastName(userNameWithAsterisk, 1, false);
            logger.debugT("filter:" + filter);
            result = userFactory.searchUsers(filter);
            logger.debugT("Search result:" + result.size());
            if (result.size() > 0) {
                i = 0;
                while (result.hasNext()) {
                    resultSet.add((String)result.next());
                    ++i;
                }
            }
            filter.clear();
            filter.setMaxSearchResultSize(0);
            String firstName = PrincipalUtils.getFirstName(userName);
            if (firstName.length() > 0) {
                filter.setFirstName(PrincipalUtils.getStrWithAsterisk(firstName, useAsterisk), 1, false);
            }
            if ((lastName = PrincipalUtils.getLastName(userName)).length() > 0) {
                filter.setLastName(PrincipalUtils.getStrWithAsterisk(lastName, useAsterisk), 1, false);
            }
            filter.setSearchMethod(0);
            logger.debugT("filter:" + filter);
            result = userFactory.searchUsers(filter);
            logger.debugT("Search result:" + result.size());
            if (result.size() > 0) {
                int i2 = 0;
                while (result.hasNext()) {
                    resultSet.add((String)result.next());
                    ++i2;
                }
            }
            if (resultSet.isEmpty()) {
                return null;
            }
            IUser[] resultArray = new IUser[resultSet.size()];
            int i3 = 0;
            Iterator iter = resultSet.iterator();
            while (iter.hasNext()) {
                resultArray[i3] = userFactory.getUser((String)iter.next());
                ++i3;
            }
            return resultArray;
        }
    }

    private static String getFirstName(String name) {
        int spaceIndex;
        int commaIndex = (name = name.trim()).indexOf(44);
        String result = commaIndex >= 0 ? name.substring(commaIndex + 1) : ((spaceIndex = name.lastIndexOf(32)) >= 0 ? name.substring(0, spaceIndex) : "");
        return result.trim();
    }

    private static String getLastName(String name) {
        int spaceIndex;
        int commaIndex = (name = name.trim()).indexOf(44);
        String result = commaIndex >= 0 ? name.substring(0, commaIndex) : ((spaceIndex = name.lastIndexOf(32)) >= 0 ? name.substring(spaceIndex + 1) : name);
        return result.trim();
    }

    private static final String getStrWithAsterisk(String str, boolean useAsterisk) {
        return useAsterisk && !str.endsWith("*") ? str + "*" : str;
    }

    private static final int getOperatorByString(String name) {
        boolean isExactSearch = name.indexOf(42) < 0 && name.indexOf(63) < 0;
        return isExactSearch ? 0 : 1;
    }

    public static List parsePrincipalIDs(String principalIDs) {
        ArrayList<String> principals = null;
        if (principalIDs == null || principalIDs.length() == 0) {
            principals = Collections.EMPTY_LIST;
        } else {
            principals = new ArrayList<String>();
            int index1 = principalIDs.indexOf(59);
            while (index1 > 0) {
                principals.add(principalIDs.substring(0, index1));
                principalIDs = principalIDs.substring(index1 + 1);
                index1 = principalIDs.indexOf(59);
            }
            if (principalIDs.length() > 0) {
                principals.add(principalIDs);
            }
        }
        return principals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

