/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.util;

import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.util.monitor.jarm.IMonitor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public final class CAFPublicLogger {
    public static final int LEVEL_BASIC = 0;
    public static final int LEVEL_MEDIUM = 1;
    public static final int LEVEL_DETAIL = 2;
    public static final Location LOC_CAF = Location.getLocation((Class)(class$com$sap$caf$rt$util$CAFPublicLogger == null ? (class$com$sap$caf$rt$util$CAFPublicLogger = CAFPublicLogger.class$("com.sap.caf.rt.util.CAFPublicLogger")) : class$com$sap$caf$rt$util$CAFPublicLogger));
    private static Map locations = new HashMap();
    public static final Category categoryCAF = Category.getCategory((Category)Category.APPLICATIONS, (String)"/Applications/CAF");
    public static final Category categoryXAPPS = Category.getCategory((Category)Category.APPLICATIONS, (String)"/Applications/XAPPS");
    static /* synthetic */ Class class$com$sap$caf$rt$util$CAFPublicLogger;

    public static void entering(String user, String request, String methodName, String application) {
        Location.getLocation((String)application).entering(methodName);
        CAFContext.getMonitor(user, request).startComponent(2, methodName);
    }

    public static void entering(String user, String request, String methodName, String application, int traceLevel) {
        CAFPublicLogger.entering(user, request, methodName, Location.getLocation((String)application), traceLevel);
    }

    public static void entering(String user, String request, String methodName, Location loc) {
        loc.entering(methodName);
        CAFContext.getMonitor(user, request).startComponent(2, methodName);
    }

    public static void entering(String user, String request, String methodName, Location loc, int traceLevel) {
        loc.entering(methodName);
        if (traceLevel == 0) {
            CAFContext.getMonitor(user, request).startComponent(0, methodName);
        } else if (traceLevel == 1) {
            CAFContext.getMonitor(user, request).startComponent(1, methodName);
        } else {
            CAFContext.getMonitor(user, request).startComponent(2, methodName);
        }
    }

    public static void entering(String user, String request, String methodName, String application, Object[] params) {
        Location.getLocation((String)application).entering(methodName, params);
        CAFContext.getMonitor(user, request).startComponent(2, methodName);
    }

    public static void entering(String user, String request, String methodName, String application, Object[] params, int traceLevel) {
        Location.getLocation((String)application).entering(methodName, params);
        if (traceLevel == 0) {
            CAFContext.getMonitor(user, request).startComponent(0, methodName);
        } else if (traceLevel == 1) {
            CAFContext.getMonitor(user, request).startComponent(1, methodName);
        } else {
            CAFContext.getMonitor(user, request).startComponent(2, methodName);
        }
    }

    public static void entering(String user, String request, String methodName, Location loc, Object[] params) {
        loc.entering(methodName, params);
        CAFContext.getMonitor(user, request).startComponent(2, methodName);
    }

    public static void entering(String user, String request, String methodName, Location loc, Object[] params, int traceLevel) {
        loc.entering(methodName, params);
        if (traceLevel == 0) {
            CAFContext.getMonitor(user, request).startComponent(0, methodName);
        } else if (traceLevel == 1) {
            CAFContext.getMonitor(user, request).startComponent(1, methodName);
        } else {
            CAFContext.getMonitor(user, request).startComponent(2, methodName);
        }
    }

    public static void exiting(String user, String request, String methodName, String application) {
        Location.getLocation((String)application).exiting();
        Location.getLocation((String)application).exiting();
        IMonitor mon = CAFContext.getMonitor(user, request);
        mon.endComponent(2, methodName);
        mon.endRequest(request);
    }

    public static void exiting(String user, String request, String methodName, Location loc) {
        loc.exiting();
        IMonitor mon = CAFContext.getMonitor(user, request);
        mon.endComponent(2, methodName);
        mon.endRequest(request);
    }

    public static void exiting(String user, String request, String methodName, Location loc, Object res) {
        loc.exiting(res);
        IMonitor mon = CAFContext.getMonitor(user, request);
        mon.endComponent(2, methodName);
        mon.endRequest(request);
    }

    public static void exiting(String user, String request, String methodName, Location loc, int traceLevel) {
        loc.exiting();
        IMonitor mon = CAFContext.getMonitor(user, request);
        if (traceLevel == 0) {
            CAFContext.getMonitor(user, request).endComponent(0, methodName);
        } else if (traceLevel == 1) {
            CAFContext.getMonitor(user, request).endComponent(1, methodName);
        } else {
            CAFContext.getMonitor(user, request).endComponent(2, methodName);
        }
        mon.endRequest(request);
    }

    public static void exiting(String user, String request, String methodName, Location loc, Object res, int traceLevel) {
        loc.exiting(res);
        IMonitor mon = CAFContext.getMonitor(user, request);
        if (traceLevel == 0) {
            CAFContext.getMonitor(user, request).endComponent(0, methodName);
        } else if (traceLevel == 1) {
            CAFContext.getMonitor(user, request).endComponent(1, methodName);
        } else {
            CAFContext.getMonitor(user, request).endComponent(2, methodName);
        }
        mon.endRequest(request);
    }

    public static void traceThrowable(int severity, String method, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        LOC_CAF.logT(severity, method, throwable.toString());
        LOC_CAF.logT(severity, method, writer.toString());
    }

    public static void traceThrowable(int severity, Location location, String method, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        location.logT(severity, method, throwable.toString());
        location.logT(severity, method, writer.toString());
    }

    public static void traceThrowableT(int severity, Location location, String method, String message, Object[] params, Throwable throwable) {
        location.traceThrowableT(severity, method, message, params, throwable);
    }

    public static void traceThrowableT(int severity, Location location, String method, String message, Throwable throwable) {
        location.traceThrowableT(severity, method, message, throwable);
    }

    public static void logThrowable(int severity, Category category, String method, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        category.logT(severity, LOC_CAF, method, throwable.getMessage());
        LOC_CAF.logT(severity, method, throwable.toString());
        LOC_CAF.logT(severity, method, writer.toString());
    }

    public static void logThrowable(int severity, Category category, Location location, String method, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        category.logT(severity, location, method, throwable.getMessage());
        location.logT(severity, method, throwable.toString());
        location.logT(severity, method, writer.toString());
    }

    public static void logThrowable(int severity, Category category, String method, String message, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        category.logT(severity, LOC_CAF, method, message + " " + throwable.getMessage());
        LOC_CAF.logT(severity, method, throwable.toString());
        LOC_CAF.logT(severity, method, writer.toString());
    }

    public static void logThrowable(int severity, Category category, Location location, String method, String message, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        category.logT(severity, location, method, message + " " + throwable.getMessage());
        location.logT(severity, method, throwable.toString());
        location.logT(severity, method, writer.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

