/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldService;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.typeservices.ModifiableSimpleValueSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.naming.InitialContext;

public class TypedFieldDescriptorFactory {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$metadata$TypedFieldService == null ? (class$com$sap$caf$rt$ui$cool$metadata$TypedFieldService = TypedFieldDescriptorFactory.class$("com.sap.caf.rt.ui.cool.metadata.TypedFieldService")) : class$com$sap$caf$rt$ui$cool$metadata$TypedFieldService).getName();
    private static final String jARMRequest = "CAF:RT:oal" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private static final String SERVICE_NAME_LOCAL = "localejbs/sap.com/caf.tc/CustomEnumTypeService";
    private static final String METHOD_FIND = "findByLocales";
    private static final String METHOD_UNIFY = "unifyKeyValuesInType";
    private static final String PROP_VALUEKEY = "valueKey";
    private static final String PROP_VALUE = "value";
    private Object customEnumTypeServiceLocal;
    private Method findByLocalesMethod;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$metadata$TypedFieldService;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;

    public TypedFieldDescriptor getTypedFieldDescriptor(String name, String type, String customType, ClassLoader cl, Locale locale) {
        TypedFieldDescriptor tfd = new TypedFieldDescriptor(name, type, customType, cl, locale);
        this.addRequiredServices(tfd);
        return tfd;
    }

    public TypedFieldDescriptor getTypedFieldDescriptor(String name, String type, ClassLoader cl) {
        TypedFieldDescriptor tfd = new TypedFieldDescriptor(name, type, cl);
        this.addRequiredServices(tfd);
        return tfd;
    }

    private void addRequiredServices(TypedFieldDescriptor tfd) {
        if (tfd.isCustomEnumType()) {
            ModifiableSimpleValueSet valueSet = this.getCETValues(tfd.getCustomType(), tfd.getDefaultLocale());
            TypedFieldService tfs = new TypedFieldService(tfd.getCustomType(), tfd.getDefaultLocale(), valueSet);
            tfd.setSimpleValueService(tfs);
        }
    }

    private ModifiableSimpleValueSet getCETValues(String type, Locale loc) {
        String method = jARMRequest + ":getCETValues(String,Locale)";
        CAFPublicLogger.entering(null, jARMRequest, method, logger);
        ModifiableSimpleValueSet set = new ModifiableSimpleValueSet(loc);
        try {
            set.setLocale(loc);
            List localeNames = TypedFieldDescriptorFactory.calculateLocaleNames(loc);
            Object[] parameters = new Object[]{"*", type, localeNames};
            Collection sortedValues = this.findSortedValuesDirectlyFromEnumService(parameters);
            Iterator i = sortedValues.iterator();
            while (i.hasNext()) {
                IDataContainerBean value = (IDataContainerBean)i.next();
                set.put(value.getProperty(PROP_VALUEKEY), value.getProperty(PROP_VALUE));
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(500, logger, method, e);
        }
        CAFPublicLogger.exiting(null, jARMRequest, method, logger);
        return set;
    }

    protected static List calculateLocaleNames(Locale locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        result.add(null);
        result.add(language);
        if (languageLength > 0 && countryLength > 0) {
            result.add(language + "_" + country);
        }
        return result;
    }

    private Collection findSortedValuesDirectlyFromEnumService(Object[] params) throws Exception {
        Collection result = null;
        Method findByLocales_meth = this.getFindMethod();
        if (findByLocales_meth != null) {
            result = (Collection)findByLocales_meth.invoke(this.getLocalService(), params);
        }
        return result;
    }

    private Method getFindMethod() throws Exception {
        if (this.findByLocalesMethod == null) {
            this.findByLocalesMethod = this.getLocalService().getClass().getMethod(METHOD_FIND, class$java$lang$String == null ? (class$java$lang$String = TypedFieldDescriptorFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TypedFieldDescriptorFactory.class$("java.lang.String")) : class$java$lang$String, class$java$util$Collection == null ? (class$java$util$Collection = TypedFieldDescriptorFactory.class$("java.util.Collection")) : class$java$util$Collection);
        }
        return this.findByLocalesMethod;
    }

    private Object getLocalService() throws Exception {
        if (this.customEnumTypeServiceLocal == null) {
            InitialContext ic = new InitialContext();
            Object home = ic.lookup(SERVICE_NAME_LOCAL);
            Method cr_meth = home.getClass().getMethod("create", new Class[0]);
            this.customEnumTypeServiceLocal = cr_meth.invoke(home, new Object[0]);
        }
        return this.customEnumTypeServiceLocal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

