/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.dictionary.runtime.DdTypeString;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import java.util.Locale;
import java.util.StringTokenizer;

public class MultiUserType
extends DdTypeString {
    public static final String DEFAULT_VALUE = "<undefined>";
    public static final String USERS_DELIMETER = ";";

    public MultiUserType(IDataProvider provider, Locale locale, XmlMap map) {
        super(provider, locale, map);
    }

    public String format(String userIDs) {
        String result = null;
        result = userIDs == null || userIDs.length() == 0 ? DEFAULT_VALUE : this.getUserDisplayNames(userIDs);
        return super.format(result);
    }

    private String getUserDisplayNames(String userIDs) {
        StringTokenizer st = new StringTokenizer(userIDs, USERS_DELIMETER);
        StringBuffer resultBuffer = new StringBuffer();
        IUserFactory userFactory = UMFactory.getUserFactory();
        while (st.hasMoreTokens()) {
            String userID = st.nextToken();
            String displayName = this.resolveUserDisplayName(userID, userFactory);
            resultBuffer.append(displayName);
            if (!st.hasMoreTokens()) continue;
            resultBuffer.append(USERS_DELIMETER);
        }
        return resultBuffer.toString();
    }

    private String resolveUserDisplayName(String userID, IUserFactory userFactory) {
        try {
            IUser user = userFactory.getUser(userID);
            return user.getDisplayName();
        }
        catch (UMException e) {
            return DEFAULT_VALUE;
        }
    }
}

