/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.caf.rt.ui.cool.metadata.AbstractDescriptor;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.caf.rt.ui.cool.metadata.StructureDescriptor;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.dictionary.types.services.NamingService;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;
import com.sap.typeservices.IModifiableTextServices;
import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ITextServices;
import java.util.HashMap;
import java.util.Locale;

public class FieldDescriptor
extends AbstractDescriptor
implements IFieldDescriptor,
ITextServices,
IDataProvider {
    private static HashMap sTypeMap;
    protected static final Location _logger;
    private ISimpleType mSimpleType;
    private boolean mExtension;
    private StructureDescriptor mStructureDescriptor;
    public static final int TEXT_FIELDTEXT = 0;
    public static final int TEXT_SCRTEXT_S = 1;
    public static final int TEXT_SCRTEXT_M = 2;
    public static final int TEXT_SCRTEXT_L = 3;
    private String mType;
    private String mMaxlength;
    private String mDecimals;
    private String[] texts;
    private HashMap mVariants;
    private HashMap mAttributes = new HashMap();
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$metadata$FieldDescriptor;

    public FieldDescriptor() {
    }

    public FieldDescriptor(String name, String type) {
        this(name, type, "", "");
    }

    public FieldDescriptor(String name, String type, String maxlength) {
        this(name, type, maxlength, "");
    }

    public FieldDescriptor(String name, String type, String maxlength, String decimals) {
        this(name, type, maxlength, decimals, false);
    }

    public FieldDescriptor(String name, String type, String maxlength, String decimals, boolean extension) {
        super(name);
        this.mSimpleType = null;
        this.mVariants = new HashMap();
        this.setType(type);
        this.mMaxlength = maxlength;
        this.mDecimals = decimals;
        this.mExtension = extension;
        this.mStructureDescriptor = null;
        this.texts = new String[4];
    }

    void setStructureDescriptor(StructureDescriptor structure) {
        this.mStructureDescriptor = structure;
    }

    public String getType() {
        return this.mType;
    }

    public ISimpleType createSimpleType() {
        return this.createSimpleType(Locale.getDefault());
    }

    public ISimpleType createSimpleType(Locale locale) {
        ISimpleType theSimpleType;
        block9: {
            String _method = "createSimpleType(Locale)";
            if (this.isVariant()) {
                throw new UnsupportedOperationException("Cannot create ISimpleType: field '" + this.getName() + "' in structure '" + this.mStructureDescriptor.getName() + "' is of type " + "VARIANT");
            }
            XmlMap theMap = new XmlMap();
            XmlMap simpleTypeMap = new XmlMap();
            if (sTypeMap.containsKey(this.mType)) {
                simpleTypeMap.put((Object)"builtInType", sTypeMap.get(this.mType));
            } else {
                simpleTypeMap.put((Object)"builtInType", (Object)"string");
                if (_logger.beWarning()) {
                    _logger.warningT("createSimpleType(Locale)", "Unknown type " + this.mType + ", using string instead.");
                }
            }
            String typeName = (this.mStructureDescriptor == null ? "" : this.mStructureDescriptor.getName() + ".") + this.getName();
            simpleTypeMap.put((Object)"name", (Object)NamingService.Structure.getJavaNameFromBackendName((String)NamingService.Structure.getBackendNameFromABAPName((String)typeName)));
            if (!"".equals(this.mMaxlength)) {
                XmlMap schemaTypeMap = new XmlMap();
                if (this.mType.equals("DECIMAL")) {
                    schemaTypeMap.put((Object)"totalDigits", (Object)this.mMaxlength);
                    schemaTypeMap.put((Object)"fractionDigits", (Object)this.mDecimals);
                } else {
                    schemaTypeMap.put((Object)"maxLength", (Object)this.mMaxlength);
                }
                simpleTypeMap.put((Object)"SchemaType", (Object)schemaTypeMap);
            }
            theMap.put((Object)"SimpleType", (Object)simpleTypeMap);
            theSimpleType = null;
            try {
                theSimpleType = DdSimpleType.makeNew((IDataProvider)this, (Locale)locale, (XmlMap)theMap);
            }
            catch (DdException ex) {
                if (!_logger.beError()) break block9;
                _logger.errorT("createSimpleType(Locale)", ex.toString());
            }
        }
        return theSimpleType;
    }

    public ISimpleType getSimpleType() {
        if (this.mSimpleType == null) {
            ServiceModuleDescriptor smd = this.mStructureDescriptor == null ? null : this.mStructureDescriptor.getServiceModuleDescriptor();
            Locale theLocale = smd != null ? smd.getLocale() : Locale.US;
            this.mSimpleType = this.createSimpleType(theLocale);
        }
        return this.mSimpleType;
    }

    public void setTextInfo(String fieldText, String scrText_s, String scrText_m, String scrText_l) {
        this.texts[0] = fieldText;
        this.texts[1] = scrText_s;
        this.texts[2] = scrText_m;
        this.texts[3] = scrText_l;
    }

    public String getText() {
        return this.getText(0);
    }

    public String getText(int textId) {
        if (textId < 0 || textId > 3) {
            throw new RuntimeException("Unknown text id " + textId);
        }
        if (this.texts[textId] == null) {
            return "";
        }
        return this.texts[textId];
    }

    public IStructureDescriptor getVariant(String variantName) {
        if (!this.isVariant()) {
            throw new UnsupportedOperationException("Field '" + this.getName() + "' in structure '" + this.mStructureDescriptor.getName() + "' is not of type " + "VARIANT");
        }
        if (this.mVariants.containsKey(variantName)) {
            return (IStructureDescriptor)this.mVariants.get(variantName);
        }
        throw new IllegalArgumentException("Undefined variant '" + variantName + "' for field '" + this.getName() + "' in structure '" + this.mStructureDescriptor.getName() + "'");
    }

    public boolean isVariant() {
        return "VARIANT" == this.mType;
    }

    public IStructureDescriptor[] getVariants() {
        if (!this.isVariant()) {
            throw new UnsupportedOperationException("Field '" + this.getName() + "' in structure '" + this.mStructureDescriptor.getName() + "' is not of type " + "VARIANT");
        }
        IStructureDescriptor[] structureDescriptors = new StructureDescriptor[this.mVariants.size()];
        this.mVariants.values().toArray(structureDescriptors);
        return structureDescriptors;
    }

    public void addVariant(StructureDescriptor descriptor) {
        if (!this.isVariant()) {
            throw new UnsupportedOperationException("Field '" + this.getName() + "' in structure '" + this.mStructureDescriptor.getName() + "' is not of type " + "VARIANT");
        }
        if (descriptor != null) {
            this.mVariants.put(descriptor.getName(), descriptor);
        }
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <Field name=\"").append(this.getName()).append("\"");
        buf.append(" type=\"").append(this.getType()).append("\"");
        buf.append(" </Field>").append(nl);
        return buf.toString();
    }

    public boolean isExtension() {
        return this.mExtension;
    }

    public Object clone() {
        return null;
    }

    public String getColumnLabel() {
        return this.getText(0);
    }

    public String getColumnLabel(Locale arg0) {
        return this.getText(0);
    }

    public String getDescription() {
        return this.getText(0);
    }

    public String getDescription(Locale arg0) {
        return this.getText(0);
    }

    public String getFieldLabel() {
        String text = this.getText(2);
        if ("".equals(text)) {
            text = this.getText(3);
        }
        if ("".equals(text)) {
            text = this.getText(1);
        }
        return text;
    }

    public String getFieldLabel(Locale arg0) {
        return this.getFieldLabel();
    }

    public Locale getLocale() {
        if (this.mStructureDescriptor == null || this.mStructureDescriptor.getServiceModuleDescriptor() == null) {
            return null;
        }
        return this.mStructureDescriptor.getServiceModuleDescriptor().getLocale();
    }

    public String getQuickInfo() {
        return this.getDescription();
    }

    public String getQuickInfo(Locale arg0) {
        return this.getDescription();
    }

    public boolean belongsToAppend(String arg0, String arg1) throws DdException {
        return false;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public ISimpleType getCurrencyUnitType(String arg0, Locale arg1) throws DdException {
        return null;
    }

    public IDataType getDataType(String arg0, Locale arg1, Object arg2) throws DdException {
        return null;
    }

    public IDataType getDataType(String arg0, Locale arg1) throws DdException {
        return null;
    }

    public ITextServices getTextService(ISimpleType arg0) throws DdException {
        return this;
    }

    public ISimpleType getUnitOfMeasureType(String arg0, Locale arg1) throws DdException {
        return null;
    }

    public ISimpleValueServices getValueService(ISimpleType arg0) throws DdException {
        return null;
    }

    public IDataType getDataTypeFromCache(String name, Locale locale) {
        return null;
    }

    public boolean needsTranslator() {
        boolean fake = true;
        return fake;
    }

    public IModifiableTextServices getModifiableVariant() {
        return null;
    }

    protected void setType(String type) {
        this.mType = type;
    }

    public void addAttribute(String attributeName, String value) {
        this.mAttributes.put(attributeName, value);
    }

    public String getAttributeStringValue(String attributeName) {
        return (String)this.mAttributes.get(attributeName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _logger = Location.getLocation((Class)(class$com$sap$caf$rt$ui$cool$metadata$FieldDescriptor == null ? (class$com$sap$caf$rt$ui$cool$metadata$FieldDescriptor = FieldDescriptor.class$("com.sap.caf.rt.ui.cool.metadata.FieldDescriptor")) : class$com$sap$caf$rt$ui$cool$metadata$FieldDescriptor));
        sTypeMap = new HashMap();
        sTypeMap.put("STRING", "string");
        sTypeMap.put("INTEGER", "integer");
        sTypeMap.put("DATE", "date");
        sTypeMap.put("BOOLEAN", "boolean");
        sTypeMap.put("TIMESTAMP", "timestamp");
        sTypeMap.put("DECIMAL", "decimal");
        sTypeMap.put("TIME", "time");
        sTypeMap.put("DOUBLE", "double");
        sTypeMap.put("BINARY", "binary");
        sTypeMap.put("VARIANT", "string");
    }
}

