/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.metadata;

import com.sap.caf.rt.ui.cool.metadata.AbstractDescriptor;
import com.sap.caf.rt.ui.cool.metadata.AspectActionDescriptor;
import com.sap.caf.rt.ui.cool.metadata.AspectGroupDescriptor;
import com.sap.caf.rt.ui.cool.metadata.KeyAspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.RelationDescriptor;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.caf.rt.ui.cool.metadata.StructureDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectGroupDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.api.IValueSetDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AspectDescriptor
extends AbstractDescriptor
implements IAspectDescriptor {
    private ServiceModuleDescriptor mServiceModuleDescriptor;
    private HashMap mAttributes;
    private HashMap mFieldAttributes;
    private HashMap mRowFieldAttributes;
    private HashMap mActionAttributes;
    private HashMap mRowActionAttributes;
    private HashMap mValueSets;
    private String description;
    private KeyAspectDescriptor keyDescriptor;
    private StructureDescriptor structure;
    private HashMap supportedActions;
    private HashMap mAspectGroups;
    private HashMap relations;

    public AspectDescriptor() {
    }

    public AspectDescriptor(ServiceModuleDescriptor serviceModuleDesc, String name, String description, StructureDescriptor structure, KeyAspectDescriptor key) {
        super(name);
        this.mAttributes = new HashMap();
        this.mFieldAttributes = new HashMap();
        this.mRowFieldAttributes = new HashMap();
        this.mActionAttributes = new HashMap();
        this.mRowActionAttributes = new HashMap();
        this.mValueSets = new HashMap();
        this.supportedActions = new HashMap();
        this.mAspectGroups = new HashMap();
        this.relations = new HashMap();
        this.setServiceModuleDescriptor(serviceModuleDesc);
        this.description = description;
        this.structure = structure;
        this.keyDescriptor = key;
    }

    public String getDescription() {
        return this.description;
    }

    public void addRelationDescriptor(RelationDescriptor relationDescriptor) {
        this.relations.put(relationDescriptor.getName(), relationDescriptor);
        if (this.mServiceModuleDescriptor != null && this.mServiceModuleDescriptor.getRelationDescriptor(relationDescriptor.getName()) != relationDescriptor) {
            this.mServiceModuleDescriptor.addRelationDescriptor(relationDescriptor);
        }
    }

    public IRelationDescriptor getRelationDescriptor(String name) {
        return (IRelationDescriptor)this.relations.get(name);
    }

    public IRelationDescriptor[] getRelationDescriptors() {
        IRelationDescriptor[] relationDescriptors = new RelationDescriptor[this.relations.size()];
        this.relations.values().toArray(relationDescriptors);
        return relationDescriptors;
    }

    public void addAspectActionDescriptor(AspectActionDescriptor aspectActionDescriptor) {
        if (aspectActionDescriptor != null) {
            this.supportedActions.put(aspectActionDescriptor.getName(), aspectActionDescriptor);
        }
    }

    public IAspectActionDescriptor getAspectActionDescriptor(String name) {
        return (AspectActionDescriptor)this.supportedActions.get(name);
    }

    public IAspectActionDescriptor[] getAspectActionDescriptors() {
        IAspectActionDescriptor[] actionDescriptors = new AspectActionDescriptor[this.supportedActions.size()];
        this.supportedActions.values().toArray(actionDescriptors);
        return actionDescriptors;
    }

    public void addAspectGroupDescriptor(AspectGroupDescriptor anAspectGroupDescriptor) {
        if (anAspectGroupDescriptor != null) {
            this.mAspectGroups.put(anAspectGroupDescriptor.getName(), anAspectGroupDescriptor);
        }
    }

    public IAspectGroupDescriptor getAspectGroupDescriptor(String name) {
        return (AspectGroupDescriptor)this.mAspectGroups.get(name);
    }

    public IAspectGroupDescriptor[] getAspectGroupDescriptors() {
        IAspectGroupDescriptor[] groupDescriptors = new AspectGroupDescriptor[this.mAspectGroups.size()];
        this.mAspectGroups.values().toArray(groupDescriptors);
        return groupDescriptors;
    }

    public void addAttribute(String attributeName, String value) {
        this.mAttributes.put(attributeName, value);
    }

    public String getAttributeStringValue(String attributeName) {
        return (String)this.mAttributes.get(attributeName);
    }

    public String[] getAttributeNames() {
        String[] attributes = new String[this.mAttributes.size()];
        this.mAttributes.keySet().toArray(attributes);
        return attributes;
    }

    public boolean getAttributeNoChange() {
        String value = this.getAttributeStringValue("COL_NO_CHANGE");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_NO_CHANGE' is not provided by the backend!");
        }
        return value.equalsIgnoreCase("X");
    }

    public boolean getAttributeExternalKeys() {
        String value = this.getAttributeStringValue("COL_EXTERNAL_KEYS");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_EXTERNAL_KEYS' is not provided by the backend!");
        }
        return value.equalsIgnoreCase("X");
    }

    public boolean getAttributeFieldwiseOperation() {
        String value = this.getAttributeStringValue("COL_FIELDWISE_OP");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_FIELDWISE_OP' is not provided by the backend!");
        }
        return value.equalsIgnoreCase("X");
    }

    public boolean getAttributeLockmodeExclusive() {
        String value = this.getAttributeStringValue("COL_LOCKMODE_E");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_LOCKMODE_E' is not provided by the backend!");
        }
        return value.equalsIgnoreCase("X");
    }

    public boolean getAttributeLockmodeSharedPromotable() {
        String value = this.getAttributeStringValue("COL_LOCKMODE_SP");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_LOCKMODE_SP' is not provided by the backend!");
        }
        return value.equalsIgnoreCase("X");
    }

    public boolean getAttributeLockmodeShared() {
        String value = this.getAttributeStringValue("COL_LOCKMODE_S");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_LOCKMODE_S' is not provided by the backend!");
        }
        return value.equalsIgnoreCase("X");
    }

    public boolean getAttributeMultiInstanceSupport() {
        String value = this.getAttributeStringValue("COL_MULTI_INSTANCE_SUPPORT");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_MULTI_INSTANCE_SUPPORT' is not provided by the backend!");
        }
        return value.equalsIgnoreCase("X");
    }

    public boolean getAttributeRowwiseOperation() {
        String value = this.getAttributeStringValue("COL_ROWWISE_OP");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_ROWWISE_OP' is not provided by the backend!");
        }
        return value.equalsIgnoreCase("X");
    }

    public String getAttributeInsertRelation() {
        String value = this.getAttributeStringValue("COL_INSERT_RELATION");
        if (value == null) {
            value = "";
        }
        return value;
    }

    public boolean getAttributeInsertRelationRequired() {
        String value = this.getAttributeStringValue("COL_INSERT_RELATION_REQUIRED");
        if (value == null) {
            value = " ";
        }
        return value.equalsIgnoreCase("X");
    }

    public void addFieldAttribute(String fieldName, String attributeName, String value) {
        this.addNestedAttribute(this.mFieldAttributes, fieldName, attributeName, value);
    }

    public String getFieldAttributeStringValue(String fieldName, String attributeName) {
        return this.getNestedAttributeStringValue(this.mFieldAttributes, fieldName, attributeName);
    }

    public String[] getFieldAttributeNames(String fieldName) {
        if (this.getStructure().getFieldDescriptor(fieldName) == null) {
            throw new IllegalArgumentException("No such field '" + fieldName + "' in aspect '" + this.getName() + "'");
        }
        Set attributeSet = this.getNestedAttributeNames(this.mFieldAttributes, fieldName);
        String[] attributes = new String[attributeSet.size()];
        attributeSet.toArray(attributes);
        return attributes;
    }

    public String[] getFieldAttributeNames(String rowKey, String fieldName) {
        Set attributeSet = this.getNestedAttributeNames(this.mFieldAttributes, fieldName);
        HashMap rowMap = (HashMap)this.mRowFieldAttributes.get(rowKey);
        if (rowMap != null) {
            Set dynamicAttributes = this.getNestedAttributeNames(rowMap, fieldName);
            attributeSet.addAll(dynamicAttributes);
        }
        String[] attributes = new String[attributeSet.size()];
        attributeSet.toArray(attributes);
        return attributes;
    }

    public String getFieldAttributeStringValue(String rowKey, String fieldName, String attributeName) {
        String value;
        HashMap rowMap = (HashMap)this.mRowFieldAttributes.get(rowKey);
        if (rowMap != null && (value = this.getNestedAttributeStringValue(rowMap, fieldName, attributeName)) != null) {
            return value;
        }
        return this.getNestedAttributeStringValue(this.mFieldAttributes, fieldName, attributeName);
    }

    public void clearRowAttributes(String rowKey) {
        this.mRowFieldAttributes.remove(rowKey);
        this.mRowActionAttributes.remove(rowKey);
        Iterator relIt = this.relations.values().iterator();
        while (relIt.hasNext()) {
            RelationDescriptor rel = (RelationDescriptor)relIt.next();
            rel.clearRowAttributes(rowKey);
        }
    }

    public void clearRowAttributes() {
        this.mRowFieldAttributes.clear();
        this.mRowActionAttributes.clear();
        Iterator relIt = this.relations.values().iterator();
        while (relIt.hasNext()) {
            RelationDescriptor rel = (RelationDescriptor)relIt.next();
            rel.clearRowAttributes();
        }
    }

    public void addFieldAttribute(String rowKey, String fieldName, String attributeName, String value) {
        HashMap rowMap = (HashMap)this.mRowFieldAttributes.get(rowKey);
        if (rowMap == null) {
            rowMap = new HashMap();
            this.mRowFieldAttributes.put(rowKey, rowMap);
        }
        this.addNestedAttribute(rowMap, fieldName, attributeName, value);
    }

    private String getNestedAttributeStringValue(HashMap map, String keyName, String attributeName) {
        HashMap innerMap = (HashMap)map.get(keyName);
        if (innerMap != null) {
            return (String)innerMap.get(attributeName);
        }
        return null;
    }

    private Set getNestedAttributeNames(HashMap map, String keyName) {
        HashMap innerMap = (HashMap)map.get(keyName);
        if (innerMap != null) {
            return innerMap.keySet();
        }
        return new HashSet();
    }

    private void addNestedAttribute(HashMap map, String keyName, String attributeName, String value) {
        HashMap<String, String> innerMap = (HashMap<String, String>)map.get(keyName);
        if (innerMap == null) {
            innerMap = new HashMap<String, String>();
            map.put(keyName, innerMap);
        }
        innerMap.put(attributeName, value);
    }

    public boolean isKeyAspect() {
        return false;
    }

    public IStructureDescriptor getStructure() {
        return this.structure;
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor() {
        return this.mServiceModuleDescriptor;
    }

    private void setServiceModuleDescriptor(ServiceModuleDescriptor descriptor) {
        if (descriptor != null) {
            this.mServiceModuleDescriptor = descriptor;
            this.mServiceModuleDescriptor.addAspectDescriptor(this);
            Iterator it = this.relations.values().iterator();
            while (it.hasNext()) {
                RelationDescriptor rel = (RelationDescriptor)it.next();
                this.mServiceModuleDescriptor.addRelationDescriptor(rel);
            }
        }
    }

    public IKeyAspectDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    public void setKeyDescriptor(KeyAspectDescriptor keyDescriptor) {
        this.keyDescriptor = keyDescriptor;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("  <AspectDescriptor name=\"").append(this.getName()).append("\"");
        buf.append(" key=\"").append(this.keyDescriptor.getName()).append("\">").append(nl);
        buf.append(this.structure.toString());
        buf.append("  </AspectDescriptor>").append(nl);
        return buf.toString();
    }

    public int getActionAttributeAffects(String rowKey, String actionName) {
        String value = this.getActionAttributeStringValue(rowKey, actionName, "COL_AFFECTS");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_AFFECTS' for the action '" + actionName + "' is not provided by the backend!");
        }
        return new Integer(value);
    }

    public int getActionAttributeAffects(String actionName) {
        String value = this.getActionAttributeStringValue(actionName, "COL_AFFECTS");
        if (value == null) {
            throw new UnsupportedOperationException("The system property 'COL_AFFECTS' for the action '" + actionName + "' is not provided by the backend!");
        }
        return new Integer(value);
    }

    public String getActionAttributeRelation(String actionName) {
        String value = this.getActionAttributeStringValue(actionName, "COL_ACTION_RELATION");
        return value != null ? value : "";
    }

    public String[] getActionAttributeNames(String rowKey, String actionName) {
        Set attributeSet = this.getNestedAttributeNames(this.mActionAttributes, actionName);
        HashMap rowMap = (HashMap)this.mRowActionAttributes.get(rowKey);
        if (rowMap != null) {
            Set dynamicAttributes = this.getNestedAttributeNames(rowMap, actionName);
            attributeSet.addAll(dynamicAttributes);
        }
        String[] attributes = new String[attributeSet.size()];
        attributeSet.toArray(attributes);
        return attributes;
    }

    public String[] getActionAttributeNames(String actionName) {
        Set attributeSet = this.getNestedAttributeNames(this.mActionAttributes, actionName);
        String[] attributes = new String[attributeSet.size()];
        attributeSet.toArray(attributes);
        return attributes;
    }

    public String getActionAttributeStringValue(String rowKey, String actionName, String attributeName) {
        String value;
        HashMap rowMap = (HashMap)this.mRowActionAttributes.get(rowKey);
        if (rowMap != null && (value = this.getNestedAttributeStringValue(rowMap, actionName, attributeName)) != null) {
            return value;
        }
        return this.getNestedAttributeStringValue(this.mActionAttributes, actionName, attributeName);
    }

    public String getActionAttributeStringValue(String actionName, String attributeName) {
        return this.getNestedAttributeStringValue(this.mActionAttributes, actionName, attributeName);
    }

    public void addActionAttribute(String actionName, String attributeName, String value) {
        this.addNestedAttribute(this.mActionAttributes, actionName, attributeName, value);
    }

    public void addActionAttribute(String rowKey, String actionName, String attributeName, String value) {
        HashMap rowMap = (HashMap)this.mRowActionAttributes.get(rowKey);
        if (rowMap == null) {
            rowMap = new HashMap();
            this.mRowActionAttributes.put(rowKey, rowMap);
        }
        this.addNestedAttribute(rowMap, actionName, attributeName, value);
    }

    public IValueSetDescriptor getValueSetDescriptor(String fieldName) {
        return (IValueSetDescriptor)this.mValueSets.get(fieldName);
    }

    public void setValueSetDescriptor(String fieldName, IValueSetDescriptor valueSetDescriptor) {
        this.mValueSets.put(fieldName, valueSetDescriptor);
    }
}

