/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.srv.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class EJBHomeFactory {
    private static EJBHomeFactory instance;
    private Map homeInterfaces = new HashMap();
    private Context context;

    private EJBHomeFactory() throws NamingException {
        Properties props = System.getProperties();
        this.context = new InitialContext(props);
    }

    public static EJBHomeFactory getInstance() throws NamingException {
        if (instance == null) {
            instance = new EJBHomeFactory();
        }
        return instance;
    }

    public EJBHome getRemoteHome(String jndiName, Class homeInterfaceClass) throws NamingException {
        EJBHome homeInterface = (EJBHome)this.homeInterfaces.get(jndiName);
        if (homeInterface == null) {
            Object obj = this.context.lookup(jndiName);
            homeInterface = (EJBHome)PortableRemoteObject.narrow((Object)obj, (Class)homeInterfaceClass);
            this.homeInterfaces.put(jndiName, homeInterface);
        }
        return homeInterface;
    }

    public EJBLocalHome getLocalHome(String jndiName) throws NamingException {
        EJBLocalHome localHomeInterface = (EJBLocalHome)this.homeInterfaces.get(jndiName);
        if (localHomeInterface == null) {
            localHomeInterface = (EJBLocalHome)this.context.lookup(jndiName);
            this.homeInterfaces.put(jndiName, localHomeInterface);
        }
        return localHomeInterface;
    }
}

