/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.serviceaccess;

import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.serviceaccess.ICAFServiceAccess;
import com.sap.caf.rt.services.serviceaccess.SimpleDataContainer;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.metadata.AspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.FieldDescriptor;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOUnsupportedOptionException;
import javax.naming.InitialContext;

public class ServiceWrapper {
    private static final String APPLICATION = (class$com$sap$caf$rt$services$serviceaccess$ServiceWrapper == null ? (class$com$sap$caf$rt$services$serviceaccess$ServiceWrapper = ServiceWrapper.class$("com.sap.caf.rt.services.serviceaccess.ServiceWrapper")) : class$com$sap$caf$rt$services$serviceaccess$ServiceWrapper).getName();
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private static final String JARM_REQUEST = "CAF:RT:oal";
    private static final String jARMRequest = "CAF:RT:oal" + APPLICATION;
    public static String METHOD_FIND = "find";
    public static String KEY = "key";
    ServiceModuleDescriptor descriptor;
    ICAFServiceAccess owner;
    String serviceName;
    Object service;
    String jndi_key;
    static /* synthetic */ Class class$com$sap$caf$rt$services$serviceaccess$ServiceWrapper;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$sap$caf$rt$bol$util$QueryFilter;
    static /* synthetic */ Class class$com$sap$caf$rt$bol$IDependentObject;
    static /* synthetic */ Class class$java$util$List;

    public ServiceWrapper(ICAFServiceAccess owner, ServiceModuleDescriptor descriptor) {
        this.owner = owner;
        this.descriptor = descriptor;
    }

    public ServiceWrapper(ICAFServiceAccess owner, ServiceModuleDescriptor descriptor, String jndi_key) {
        this.owner = owner;
        this.descriptor = descriptor;
        this.jndi_key = jndi_key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection readDataObject(String aspectName, Collection keys) throws ServiceException {
        String method = "readDataObject(String, Collection)";
        CAFPublicLogger.entering(null, jARMRequest, "readDataObject(String, Collection)", logger, 1);
        try {
            ArrayList<IDataContainerBean> result = new ArrayList<IDataContainerBean>();
            if (keys != null) {
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    try {
                        result.add(this.readDataObject(aspectName, key));
                    }
                    catch (Exception e) {
                        CAFPublicLogger.traceThrowableT(100, logger, "readDataObject(String, Collection)", "Error in readDataObject(String, Collection)", e);
                        logger.throwing("readDataObject(String, Collection)", (Throwable)e);
                    }
                }
            }
            ArrayList<IDataContainerBean> arrayList = result;
            return arrayList;
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, "readDataObject(String, Collection)", logger, 1);
        }
    }

    IDataContainerBean readDataObject(String aspectName, String key) throws ServiceException {
        IDataContainerBean result = null;
        Object srv = this.getService();
        try {
            Method meth = this.getReadDataObjectMethod(aspectName);
            key = this.resolveTechKey(key);
            Object[] pars = this.makeParametersOfReadObject(srv, aspectName, key);
            IDependentObject depO = (IDependentObject)meth.invoke(srv, pars);
            result = this.convertToDataContainerBean(depO);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    public IDataContainerBean readRelatedDataObject(String aspectName, String parentAspect, String parentAspectKey) throws ServiceException {
        return null;
    }

    public IDataContainerBean updateDataObject(String aspectName, IDataContainerBean data) throws ServiceException {
        IDataContainerBean result = null;
        try {
            String key = this.resolveTechKey(aspectName, data);
            IDependentObject depO = this.readDependentObject(aspectName, key);
            this.applyToDependentObject(depO, (SimpleDataContainer)data);
            this.checkDates(depO, (SimpleDataContainer)data);
            this.updateDependentObject(aspectName, depO);
            this.applyToDataContainerBean(data, depO);
            result = data;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    public IDataContainerBean createDataContainerBean(String aspectName, IDataContainerBean data) throws ServiceException {
        IDataContainerBean result = null;
        try {
            IDependentObject depO = this.createDependentObject(aspectName, data);
            this.applyToDependentObject(depO, (SimpleDataContainer)data);
            this.updateDependentObject(aspectName, depO);
            this.applyToDataContainerBean(data, depO);
            result = data;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    public boolean deleteDataObject(String aspectName, Collection keys) throws ServiceException {
        boolean result = false;
        try {
            IAspectActionDescriptor actionDesc = this.descriptor.getOperationDescriptor(aspectName, "delete");
            if (actionDesc != null) {
                Method deleteMethod = this.findMethod(aspectName, actionDesc.getName());
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String key = this.resolveTechKey((String)it.next());
                    IDependentObject depO = this.readDependentObject(aspectName, key);
                    deleteMethod.invoke(this.getService(), depO);
                }
            } else {
                throw new ServiceException("METHOD_DESCRIPTOR_NOT_FOUND", new Object[]{"delete", aspectName, this.service.getClass().getName()});
            }
            result = true;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    public Collection findByDataObject(String queryName, Collection parameters) throws ServiceException {
        ArrayList<IDataContainerBean> result;
        block25: {
            result = null;
            Object service = this.getService();
            Method method = null;
            Object[] args = null;
            IQueryDescriptor query = this.descriptor.getQueryDescriptor(queryName);
            if (query != null && "true".equals(query.getAttributeStringValue("findByMultipleParameters"))) {
                method = this.findMethod(service.getClass(), queryName);
                if (method != null) {
                    args = this.makeFindByMultParsParameters(parameters, query);
                }
            } else if (query != null && "true".equals(query.getAttributeStringValue("findByKMPropertySearch"))) {
                method = this.findMethod(service.getClass(), queryName, 1);
                if (method != null) {
                    args = this.makeFindByKMPropertySearchParameters(parameters, query);
                }
            } else {
                method = this.findMethod(service.getClass(), queryName);
                if (method != null) {
                    args = this.makeParameters(parameters, method.getParameterTypes());
                }
            }
            if (method != null) {
                try {
                    Object tmp_res = method.invoke(service, args);
                    if (tmp_res instanceof Collection) {
                        AspectDescriptor resultAspect = null;
                        if (query != null) {
                            resultAspect = (AspectDescriptor)query.getResultAspectDescriptor();
                        }
                        if (resultAspect != null && ("true".equals(query.getAttributeStringValue("findByKMPropertySearch")) || "true".equals(query.getAttributeStringValue("searchidxForBOInRelatedDoc")))) {
                            result = this.readDataObject(resultAspect.getName(), (Collection)tmp_res);
                        } else if (resultAspect != null && "true".equals(resultAspect.getAttributeStringValue("generic"))) {
                            result = new ArrayList(((Collection)tmp_res).size());
                            Iterator it = ((Collection)tmp_res).iterator();
                            while (it.hasNext()) {
                                SimpleDataContainer sc = new SimpleDataContainer();
                                sc.setProperty("value", it.next());
                                result.add(sc);
                            }
                        } else {
                            result = this.convertToDataContainerBean((Collection)tmp_res);
                        }
                        break block25;
                    }
                    if (query != null) {
                        AspectDescriptor resultAspect = (AspectDescriptor)query.getResultAspectDescriptor();
                        if (resultAspect != null && "true".equals(resultAspect.getAttributeStringValue("generic"))) {
                            result = new ArrayList<IDataContainerBean>(1);
                            if (method.getReturnType().isArray() && !(tmp_res instanceof byte[])) {
                                int arSize = Array.getLength(tmp_res);
                                for (int n = 0; n < arSize; ++n) {
                                    SimpleDataContainer sc = new SimpleDataContainer();
                                    sc.setProperty("value", Array.get(tmp_res, n));
                                    result.add(sc);
                                }
                            } else {
                                SimpleDataContainer sc = new SimpleDataContainer();
                                sc.setProperty("value", tmp_res);
                                result.add(sc);
                            }
                        } else if (tmp_res != null && tmp_res instanceof IDependentObject) {
                            IDataContainerBean retValue = this.convertToDataContainerBean((IDependentObject)tmp_res);
                            result = new ArrayList(1);
                            result.add(retValue);
                        }
                        break block25;
                    }
                    throw new ServiceException("QUERY_DESCRIPTOR_NOT_FOUND", new Object[]{queryName, service.getClass().getName()});
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            } else {
                throw new ServiceException("QUERY_NOT_FOUND", new Object[]{queryName, service.getClass().getName()});
            }
        }
        return result;
    }

    public Object invokeCustom(String operationName, Object parameters, Collection keys) throws ServiceException {
        Object[] pars = new Object[]{};
        if (parameters instanceof Object[]) {
            pars = (Object[])parameters;
        } else if (parameters instanceof Collection) {
            pars = this.makeParameters((Collection)parameters);
        } else if (parameters != null) {
            pars = new Object[]{parameters};
        }
        Method meth = this.findMethod(this.getService().getClass(), operationName);
        if (meth == null) {
            throw new ServiceException("METHOD_WITH_PARAMETERS_NOT_FOUND", new Object[]{operationName, new Integer(pars.length), this.getService().getClass().getName()});
        }
        Object result = null;
        try {
            Class<?>[] paramTypes = meth.getParameterTypes();
            if (paramTypes != null && paramTypes.length > 0 && (class$java$util$Collection == null ? (class$java$util$Collection = ServiceWrapper.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(paramTypes[0])) {
                Object[] parsNew = new Object[pars.length + 1];
                ArrayList<String> keyList = new ArrayList<String>();
                if (keys != null) {
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        String key = this.resolveTechKey((String)it.next());
                        keyList.add(key);
                    }
                }
                parsNew[0] = keyList;
                System.arraycopy(pars, 0, parsNew, 1, pars.length);
                pars = parsNew;
            }
            result = meth.invoke(this.getService(), pars);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    public IDataContainerBean recalculate(IDataContainerBean data) throws ServiceException {
        return null;
    }

    private Object getService() throws ServiceException {
        if (this.service == null) {
            try {
                InitialContext ic = new InitialContext();
                Object home = ic.lookup(this.getJNDI_KEY());
                Method cr_meth = home.getClass().getMethod("create", new Class[0]);
                this.service = cr_meth.invoke(home, new Object[0]);
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        }
        return this.service;
    }

    private String getJNDI_KEY() {
        return this.jndi_key;
    }

    private IDependentObject createDependentObject(String aspectName, IDataContainerBean bean) throws ServiceException {
        IDependentObject result;
        block5: {
            result = null;
            try {
                IAspectActionDescriptor actionDesc = this.descriptor.getOperationDescriptor(aspectName, "create");
                if (actionDesc != null) {
                    Object[] args = this.makeCreateParameters(aspectName, bean, actionDesc);
                    Method createMethod = this.findMethod(aspectName, actionDesc.getName(), args.length);
                    if (args != null || args.length > 0) {
                        args = this.makeParameters(Arrays.asList(args), createMethod.getParameterTypes());
                    }
                    result = (IDependentObject)createMethod.invoke(this.getService(), args);
                    bean.setProperty("key", result.getKey());
                    List propList = result.getPropertyList();
                    for (int i = 0; i < propList.size(); ++i) {
                        String propName = (String)propList.get(i);
                        Object propValue = result.getProperty(propName);
                        if (propValue == null || propValue instanceof Collection && ((Collection)propValue).isEmpty() || propValue instanceof String && "".equals(propValue) || propValue instanceof Number && ((Number)propValue).intValue() == 0 || propValue instanceof Boolean && propValue.equals(new Boolean(false)) || propValue instanceof Character && "".equals(propValue)) continue;
                        bean.setProperty(propName, propValue);
                    }
                    break block5;
                }
                throw new ServiceException("METHOD_DESCRIPTOR_NOT_FOUND", new Object[]{"create", aspectName, this.service.getClass().getName()});
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return result;
    }

    private IDependentObject readDependentObject(String aspectName, String key) throws ServiceException {
        IDependentObject result = null;
        try {
            Method readMethod = this.getReadDataObjectMethod(aspectName);
            result = (IDependentObject)readMethod.invoke(this.getService(), key);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return result;
    }

    private void updateDependentObject(String aspectName, IDependentObject depO) throws ServiceException {
        try {
            IAspectActionDescriptor actionDesc = this.descriptor.getOperationDescriptor(aspectName, "update");
            if (actionDesc == null) {
                throw new ServiceException("METHOD_DESCRIPTOR_NOT_FOUND", new Object[]{"update", aspectName, this.service.getClass().getName()});
            }
            Method readMethod = this.findMethod(aspectName, actionDesc.getName());
            readMethod.invoke(this.getService(), depO);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private Method getReadDataObjectMethod(String aspectName) throws Exception {
        IAspectActionDescriptor actionDesc = this.descriptor.getOperationDescriptor(aspectName, "read");
        if (actionDesc != null) {
            return this.findMethod(aspectName, actionDesc.getName());
        }
        throw new ServiceException("METHOD_DESCRIPTOR_NOT_FOUND", new Object[]{"read", aspectName, this.service.getClass().getName()});
    }

    private Method getFindByMethod(IQueryDescriptor query) throws ServiceException {
        Object service = this.getService();
        Class<?> serviceClass = service.getClass();
        return this.findMethod(serviceClass, query.getName());
    }

    private Method findMethod(String aspectName, String method) throws Exception {
        Object service = this.getService();
        Class<?> serviceClass = service.getClass();
        Method m = this.findMethod(serviceClass, method);
        if (m == null) {
            throw new ServiceException("METHOD_NOT_FOUND", new Object[]{method, serviceClass.getName()});
        }
        return m;
    }

    private Method findMethod(String aspectName, String method, int pars_count) throws Exception {
        Object service = this.getService();
        Class<?> serviceClass = service.getClass();
        Method m = this.findMethod(serviceClass, method, pars_count);
        if (m == null) {
            throw new ServiceException("METHOD_WITH_PARAMETERS_NOT_FOUND", new Object[]{method, new Integer(pars_count), serviceClass.getName()});
        }
        return m;
    }

    private Method findMethod(Class cl, String methodName) {
        Method[] meths = cl.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            if (!methodName.equals(meths[i].getName())) continue;
            return meths[i];
        }
        return null;
    }

    private Method findDeclaredMethod(Class cl, String methodName) {
        Method[] meths = cl.getDeclaredMethods();
        for (int i = 0; i < meths.length; ++i) {
            if (!methodName.equals(meths[i].getName())) continue;
            return meths[i];
        }
        return null;
    }

    private Method findMethod(Class cl, String methodName, int pars_count) {
        Method[] meths = cl.getMethods();
        for (int i = 0; i < meths.length; ++i) {
            if (!methodName.equals(meths[i].getName()) || meths[i].getParameterTypes().length != pars_count) continue;
            return meths[i];
        }
        return null;
    }

    private Object[] makeParameters(Collection pars) {
        Object[] res = null;
        if (pars != null) {
            res = pars.toArray();
        }
        return res;
    }

    private Object[] makeParameters(Collection pars, Class[] classes) {
        Object[] res = null;
        if (classes != null) {
            res = new Object[classes.length];
            Object par = null;
            Class parCl = null;
            Iterator it = null;
            if (pars != null) {
                it = pars.iterator();
            }
            for (int i = 0; i < classes.length; ++i) {
                parCl = classes[i];
                Object object = par = pars != null && it.hasNext() ? (Object)it.next() : null;
                if (parCl.isPrimitive()) {
                    if (par == null) {
                        par = this.getDefualtValueForType(parCl);
                    }
                    if (parCl.isAssignableFrom(Integer.TYPE) && (class$java$lang$Integer == null ? ServiceWrapper.class$("java.lang.Integer") : class$java$lang$Integer).isInstance(par) || parCl.isAssignableFrom(Byte.TYPE) && (class$java$lang$Byte == null ? ServiceWrapper.class$("java.lang.Byte") : class$java$lang$Byte).isInstance(par) || parCl.isAssignableFrom(Double.TYPE) && (class$java$lang$Double == null ? ServiceWrapper.class$("java.lang.Double") : class$java$lang$Double).isInstance(par) || parCl.isAssignableFrom(Float.TYPE) && (class$java$lang$Float == null ? ServiceWrapper.class$("java.lang.Float") : class$java$lang$Float).isInstance(par) || parCl.isAssignableFrom(Long.TYPE) && ((class$java$lang$Long == null ? ServiceWrapper.class$("java.lang.Long") : class$java$lang$Long).isInstance(par) || (class$java$lang$Integer == null ? ServiceWrapper.class$("java.lang.Integer") : class$java$lang$Integer).isInstance(par)) || parCl.isAssignableFrom(Short.TYPE) && (class$java$lang$Short == null ? ServiceWrapper.class$("java.lang.Short") : class$java$lang$Short).isInstance(par) || parCl.isAssignableFrom(Boolean.TYPE) && (class$java$lang$Boolean == null ? ServiceWrapper.class$("java.lang.Boolean") : class$java$lang$Boolean).isInstance(par)) {
                        res[i] = par;
                        continue;
                    }
                    res[i] = null;
                    continue;
                }
                if ((class$com$sap$caf$rt$bol$util$QueryFilter == null ? ServiceWrapper.class$("com.sap.caf.rt.bol.util.QueryFilter") : class$com$sap$caf$rt$bol$util$QueryFilter).isAssignableFrom(parCl)) {
                    res[i] = QueryFilter.getQueryFilter(par);
                    continue;
                }
                if (parCl.isInstance(par)) {
                    res[i] = par;
                    continue;
                }
                if ((class$com$sap$caf$rt$bol$IDependentObject == null ? ServiceWrapper.class$("com.sap.caf.rt.bol.IDependentObject") : class$com$sap$caf$rt$bol$IDependentObject).isAssignableFrom(parCl) && par instanceof IDataContainerBean) {
                    try {
                        IDependentObject dep = (IDependentObject)parCl.newInstance();
                        this.applyToDependentObject(dep, (SimpleDataContainer)par);
                        res[i] = dep;
                    }
                    catch (Exception e) {
                        res[i] = null;
                    }
                    continue;
                }
                res[i] = null;
            }
        }
        return res;
    }

    private Object[] makeFindByMultParsParameters(Collection pars, IQueryDescriptor query) {
        boolean isBwExtractOperation = "true".equals(query.getAttributeStringValue("is_BW_EXTRACT_OPERATION"));
        Object[] res = null;
        res = isBwExtractOperation ? new Object[1] : new Object[3];
        HashMap<String, QueryFilter> map = new HashMap<String, QueryFilter>();
        Object par = null;
        Iterator it = null;
        if (pars != null) {
            it = pars.iterator();
        }
        IStructureDescriptor desc = query.getInputParameters();
        int size = desc.size();
        for (int i = 0; i < size; ++i) {
            par = pars != null && it.hasNext() ? it.next() : null;
            FieldDescriptor fd = (FieldDescriptor)desc.getFieldDescriptor(i);
            String key = fd.getName();
            if ("true".equals(fd.getAttributeStringValue("isComplexSubattribute"))) {
                key = fd.getAttributeStringValue("sourceAttributeName") + "." + fd.getAttributeStringValue("targetAttributeName");
            }
            if (par == null) continue;
            QueryFilter value = QueryFilter.getQueryFilter(par);
            map.put(key, value);
        }
        res[0] = map;
        if (res.length > 1) {
            res[1] = "true".equals(query.getAttributeStringValue("implicitCheck")) ? new Boolean(true) : new Boolean(false);
            res[2] = "findByMultipleParameters";
        }
        return res;
    }

    private Object[] makeFindByKMPropertySearchParameters(Collection pars, IQueryDescriptor query) {
        Object[] res = new Object[1];
        ArrayList<QueryFilter> collectionAttrsAndCategories = new ArrayList<QueryFilter>();
        String par = null;
        Iterator it = null;
        if (pars != null) {
            it = pars.iterator();
        }
        IStructureDescriptor desc = query.getInputParameters();
        int size = desc.size();
        for (int i = 0; i < size; ++i) {
            par = pars != null && it.hasNext() ? (String)it.next() : null;
            FieldDescriptor fd = (FieldDescriptor)desc.getFieldDescriptor(i);
            String key = fd.getName();
            QueryFilter value = null;
            if (par != null || "STRING".equals(fd.getType())) {
                if (par != null && !(par instanceof String)) {
                    if (par instanceof Date) {
                        if (!"createdAt".equalsIgnoreCase(key) && !"lastChangedAt".equalsIgnoreCase(key)) {
                            par = String.valueOf(par);
                        }
                    } else {
                        par = String.valueOf(par);
                    }
                }
                value = QueryFilter.getQueryFilter(par);
            }
            if (value == null) continue;
            value.attribute = key;
            if (fd instanceof TypedFieldDescriptor) {
                if (((TypedFieldDescriptor)fd).getCategoryID() != null && !"".equals(((TypedFieldDescriptor)fd).getCategoryID())) {
                    value.operation = "category";
                    value.attribute = ((TypedFieldDescriptor)fd).getCategoryID();
                } else {
                    value.operation = "attribute";
                }
            } else {
                value.operation = "attribute";
            }
            collectionAttrsAndCategories.add(value);
            QueryFilter andQueryFilter = new QueryFilter();
            andQueryFilter.operation = "and";
            collectionAttrsAndCategories.add(andQueryFilter);
        }
        if (collectionAttrsAndCategories.size() > 0) {
            collectionAttrsAndCategories.remove(collectionAttrsAndCategories.size() - 1);
        }
        res[0] = collectionAttrsAndCategories;
        return res;
    }

    private Object[] makeParametersOfReadObject(Object srv, String aspect, String key) {
        return new Object[]{key};
    }

    private Object[] makeCreateParameters(String aspectName, IDataContainerBean bean, IAspectActionDescriptor actionDesc) {
        Object[] result = new Object[]{};
        ArrayList<Object> resultList = new ArrayList<Object>();
        IStructureDescriptor structureDesc = actionDesc.getInputParameters();
        if (structureDesc != null) {
            IFieldDescriptor[] params = structureDesc.getFieldDescriptors();
            result = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                String name = params[i].getName();
                resultList.add(bean.getProperty(name));
            }
        }
        result = resultList.toArray();
        return result;
    }

    private void handleException(Exception e) throws ServiceException {
        if (e instanceof InvocationTargetException) {
            e = (Exception)((InvocationTargetException)e).getCause();
        }
        if (!(e instanceof ServiceException)) {
            e = new ServiceException((Throwable)e);
        }
        throw (ServiceException)((Object)e);
    }

    private Collection convertToDataContainerBean(Collection coll) throws Exception {
        ArrayList<IDataContainerBean> result = new ArrayList<IDataContainerBean>();
        if (coll != null) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                IDependentObject depO = (IDependentObject)it.next();
                IDataContainerBean dcb = this.convertToDataContainerBean(depO);
                result.add(dcb);
            }
        }
        return result;
    }

    private IDataContainerBean convertToDataContainerBean(IDependentObject depO) throws Exception {
        SimpleDataContainer dcb = new SimpleDataContainer(depO.getPropertyList());
        dcb.apply(depO);
        return dcb;
    }

    private void applyToDependentObject(IDependentObject depO, SimpleDataContainer bean) throws Exception {
        List props = bean.getPropertyList();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            try {
                String propName = (String)props.get(i);
                Object propValue = bean.getProperty(propName);
                if (propValue != null && (propValue instanceof SimpleDataContainer || this.isCollectionOfComplexAttributes(propValue))) {
                    String methodName = null;
                    if (propName != null && propName.length() != 0) {
                        methodName = "" + Character.toUpperCase(propName.charAt(0));
                        if (propName.length() > 1) {
                            methodName = methodName + propName.substring(1);
                        }
                    }
                    Method method = null;
                    Class<?> clazz = null;
                    if (propValue instanceof Collection) {
                        methodName = "add" + methodName;
                        method = this.findMethod(depO.getClass(), methodName);
                        if (method == null) {
                            throw new ServiceException("METHOD_NOT_FOUND", new Object[]{methodName, depO.getClass().getName()});
                        }
                        clazz = method.getParameterTypes()[0];
                        Collection propValues = this.getCollectionByProperty(depO, propName);
                        Iterator it = ((Collection)propValue).iterator();
                        while (it.hasNext()) {
                            Object value = it.next();
                            IDependentObject depObj = (IDependentObject)clazz.newInstance();
                            this.applyToDependentObject(depObj, (SimpleDataContainer)value);
                            propValues.add(depObj);
                        }
                        depO.setProperty(propName, propValues);
                        continue;
                    }
                    methodName = "get" + methodName;
                    method = this.findMethod(depO.getClass(), methodName);
                    if (method == null) {
                        throw new ServiceException("METHOD_NOT_FOUND", new Object[]{methodName, depO.getClass().getName()});
                    }
                    clazz = method.getReturnType();
                    IDependentObject depObj = (IDependentObject)clazz.newInstance();
                    this.applyToDependentObject(depObj, (SimpleDataContainer)propValue);
                    depO.setProperty(propName, depObj);
                    continue;
                }
                if (propValue instanceof Collection) {
                    Collection propValues = this.getCollectionByProperty(depO, propName);
                    propValues.addAll((Collection)propValue);
                    depO.setProperty(propName, propValues);
                    continue;
                }
                depO.setProperty(propName, propValue);
                continue;
            }
            catch (Exception e) {
                if (e instanceof JDOUnsupportedOptionException && "javax.jdo.option.ChangeApplicationIdentity".equals(e.getMessage())) continue;
                logger.catching((Throwable)e);
            }
        }
    }

    private Collection getCollectionByProperty(IDependentObject depO, String propName) throws Exception {
        Method method;
        String methodName = "set" + Character.toUpperCase(propName.charAt(0));
        if (propName.length() > 1) {
            methodName = methodName + propName.substring(1);
        }
        if ((method = this.findDeclaredMethod(depO.getClass(), methodName)) == null) {
            throw new ServiceException("METHOD_NOT_FOUND", new Object[]{methodName, depO.getClass().getName()});
        }
        Class<?> clazz = method.getParameterTypes()[0];
        if (clazz.isInterface()) {
            if ((class$java$util$List == null ? (class$java$util$List = ServiceWrapper.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
                return new ArrayList();
            }
            return new HashSet();
        }
        Collection collectionInstance = (Collection)clazz.newInstance();
        return collectionInstance;
    }

    private void applyToDataContainerBean(IDataContainerBean dcb, IDependentObject depO) throws Exception {
        ((SimpleDataContainer)dcb).apply(depO);
    }

    private boolean isCollectionOfComplexAttributes(Object propValue) {
        if (propValue != null && propValue instanceof Collection) {
            Collection complexAttrs = (Collection)propValue;
            Iterator it = complexAttrs.iterator();
            while (it.hasNext()) {
                Object value = it.next();
                if (value == null || !(value instanceof SimpleDataContainer)) continue;
                return true;
            }
        }
        return false;
    }

    private String resolveTechKey(String aspectName, IDataContainerBean bean) {
        return (String)bean.getProperty(KEY);
    }

    private String resolveTechKey(String original) {
        if (original != null && original.startsWith("[") && original.endsWith("]")) {
            return original.substring(1, original.length() - 1);
        }
        return original;
    }

    private Object getDefualtValueForType(Class cl) {
        Constable ret = null;
        if (cl.isAssignableFrom(Integer.TYPE)) {
            ret = new Integer(0);
        } else if (cl.isAssignableFrom(Byte.TYPE)) {
            ret = new Byte(0);
        } else if (cl.isAssignableFrom(Double.TYPE)) {
            ret = new Double(0.0);
        } else if (cl.isAssignableFrom(Float.TYPE)) {
            ret = new Float(0.0);
        } else if (cl.isAssignableFrom(Long.TYPE)) {
            ret = new Long(0L);
        } else if (cl.isAssignableFrom(Short.TYPE)) {
            ret = new Short(0);
        } else if (cl.isAssignableFrom(Boolean.TYPE)) {
            ret = Boolean.FALSE;
        }
        return ret;
    }

    private void checkDates(IDependentObject depO, SimpleDataContainer bean) throws Exception {
        if (!CAFContext.OPTIMISTIC_LOCKING_ENABLED) {
            return;
        }
        Date pDate = null;
        if (depO instanceof IBusinessObject) {
            pDate = ((IBusinessObject)depO).getLastChangedAt();
        }
        Date bDate = (Date)bean.getProperty("lastChangedAt");
        if (pDate != null && bean != null && pDate.compareTo(bDate) > 0) {
            CAFUpdateException e = new CAFUpdateException("BO_UPDATE");
            CAFPublicLogger.traceThrowableT(100, logger, "checkDates", "Error in checkDates", (Throwable)((Object)e));
            logger.throwing("checkDates", (Throwable)((Object)e));
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

